/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.task;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.jelly.tags.ant.AntTagLibrary;
import org.apache.commons.jelly.task.AntJellyContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.SAXException;

public class JellyTask
extends Task {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$Jelly == null ? (class$org$apache$commons$jelly$Jelly = JellyTask.class$("org.apache.commons.jelly.Jelly")) : class$org$apache$commons$jelly$Jelly));
    private JellyContext context;
    private URL url;
    private URL rootContext;
    private XMLOutput xmlOutput;
    private File output;
    static /* synthetic */ Class class$org$apache$commons$jelly$Jelly;

    public void execute() throws BuildException {
        try {
            this.log("Running script: " + this.getUrl());
            if (this.output != null) {
                this.log("Sending output to: " + this.output);
            }
            Script script = this.compileScript();
            JellyContext context = this.getJellyContext();
            context.setVariable("project", (Object)this.getProject());
            script.run(context, this.getXMLOutput());
            this.getXMLOutput().flush();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public void setScript(String script) throws MalformedURLException {
        this.setUrl(this.resolveURL(script));
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setFile(File file) throws MalformedURLException {
        this.setUrl(file.toURL());
    }

    public void setOutput(File output) throws IOException {
        this.output = output;
        this.xmlOutput = XMLOutput.createXMLOutput((Writer)new FileWriter(output));
    }

    public XMLOutput getXMLOutput() throws IOException {
        if (this.xmlOutput == null) {
            this.xmlOutput = XMLOutput.createXMLOutput((OutputStream)System.out);
        }
        return this.xmlOutput;
    }

    public void setXMLOutput(XMLOutput xmlOutput) {
        this.xmlOutput = xmlOutput;
    }

    public URL getRootContext() throws MalformedURLException {
        if (this.rootContext == null) {
            this.rootContext = new File(System.getProperty("user.dir")).toURL();
        }
        return this.rootContext;
    }

    public void setRootContext(URL rootContext) {
        this.rootContext = rootContext;
    }

    public JellyContext getJellyContext() throws MalformedURLException {
        if (this.context == null) {
            String text = this.getUrl().toString();
            int idx = text.lastIndexOf(47);
            text = text.substring(0, idx + 1);
            JellyContext parentContext = new JellyContext(this.getRootContext(), new URL(text));
            this.context = new AntJellyContext(this.getProject(), parentContext);
            this.context.registerTagLibrary("jelly:ant", (TagLibrary)new AntTagLibrary());
        }
        return this.context;
    }

    protected Script compileScript() throws JellyException {
        XMLParser parser = new XMLParser();
        Script script = null;
        try {
            parser.setContext(this.getJellyContext());
            script = parser.parse(this.getUrl().toString());
        }
        catch (IOException e) {
            throw new JellyException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JellyException((Throwable)e);
        }
        script = script.compile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compiled script: " + this.getUrl()));
        }
        return script;
    }

    protected URL resolveURL(String name) throws MalformedURLException {
        File file = this.getProject().resolveFile(name);
        if (file.exists()) {
            return file.toURL();
        }
        return new URL(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

