/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.ant;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.ant.AntTag;
import org.apache.commons.jelly.tags.ant.FileScanner;
import org.apache.commons.jelly.tags.ant.FileScannerTag;
import org.apache.commons.jelly.tags.ant.GrantProject;
import org.apache.commons.jelly.tags.ant.JellyPropsHandler;
import org.apache.commons.jelly.tags.ant.SetPropertyTag;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.xml.sax.Attributes;

public class AntTagLibrary
extends TagLibrary {
    public static final String PROJECT_CONTEXT_HANDLE = "org.apache.commons.jelly.ant.Project";
    static /* synthetic */ Class class$org$apache$tools$ant$types$Reference;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$junit$FormatterElement$TypeAttribute;

    public static Project getProject(JellyContext context) {
        Project project = (Project)context.findVariable(PROJECT_CONTEXT_HANDLE);
        if (project == null) {
            project = AntTagLibrary.createProject(context);
            context.setVariable(PROJECT_CONTEXT_HANDLE, (Object)project);
        }
        return project;
    }

    public static void setProject(JellyContext context, Project project) {
        context.setVariable(PROJECT_CONTEXT_HANDLE, (Object)project);
    }

    public static Project createProject(JellyContext context) {
        GrantProject project = new GrantProject();
        project.setPropsHandler(new JellyPropsHandler(context));
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.init();
        project.getBaseDir();
        if (context.getCurrentURL() != null) {
            project.setProperty("ant.file", context.getCurrentURL().toExternalForm());
        }
        return project;
    }

    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        TagScript answer = this.createCustomTagScript(name, attributes);
        if (answer == null) {
            answer = new TagScript(new TagFactory(){

                public Tag createTag(String name, Attributes attributes) throws JellyException {
                    return AntTagLibrary.this.createTag(name, attributes);
                }
            });
        }
        return answer;
    }

    public TagScript createCustomTagScript(String name, Attributes attributes) {
        if (name.equals("fileScanner")) {
            return new TagScript(new TagFactory(){

                public Tag createTag(String name, Attributes attributes) {
                    return new FileScannerTag(new FileScanner());
                }
            });
        }
        if (name.equals("setProperty")) {
            return new TagScript(new TagFactory(){

                public Tag createTag(String name, Attributes attributes) {
                    return new SetPropertyTag();
                }
            });
        }
        return null;
    }

    public Tag createTag(String name, Attributes attributes) throws JellyException {
        AntTag tag = new AntTag(name);
        if (name.equals("echo")) {
            tag.setTrim(false);
        }
        return tag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                if (value instanceof Reference) {
                    return (Reference)value;
                }
                if (value != null) {
                    String text = value.toString();
                    return new Reference(text);
                }
                return null;
            }
        }, (Class)(class$org$apache$tools$ant$types$Reference == null ? (class$org$apache$tools$ant$types$Reference = AntTagLibrary.class$("org.apache.tools.ant.types.Reference")) : class$org$apache$tools$ant$types$Reference));
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                if (value instanceof EnumeratedAttribute) {
                    return (EnumeratedAttribute)value;
                }
                if (value instanceof String) {
                    FormatterElement.TypeAttribute attr = new FormatterElement.TypeAttribute();
                    attr.setValue((String)value);
                    return attr;
                }
                return null;
            }
        }, (Class)(class$org$apache$tools$ant$taskdefs$optional$junit$FormatterElement$TypeAttribute == null ? (class$org$apache$tools$ant$taskdefs$optional$junit$FormatterElement$TypeAttribute = AntTagLibrary.class$("org.apache.tools.ant.taskdefs.optional.junit.FormatterElement$TypeAttribute")) : class$org$apache$tools$ant$taskdefs$optional$junit$FormatterElement$TypeAttribute));
    }
}

