/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.ant;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MapTagSupport;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.BeanSource;
import org.apache.commons.jelly.impl.StaticTag;
import org.apache.commons.jelly.tags.ant.AntTagLibrary;
import org.apache.commons.jelly.tags.ant.TaskSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.DataType;

public class AntTag
extends MapTagSupport
implements TaskSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$ant$AntTag == null ? (class$org$apache$commons$jelly$tags$ant$AntTag = AntTag.class$("org.apache.commons.jelly.tags.ant.AntTag")) : class$org$apache$commons$jelly$tags$ant$AntTag));
    private static final Class[] addTaskParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AntTag.class$("java.lang.String")) : class$java$lang$String};
    private static final String ANT_MANIFEST_TAG = "manifest";
    protected String tagName;
    protected Object object;
    protected Task task;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$ant$AntTag;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public AntTag(String tagName) {
        this.tagName = tagName;
    }

    public String toString() {
        return "[AntTag: name=" + this.getTagName() + "]";
    }

    public Object getTaskObject() {
        return this.object;
    }

    public void setTaskProperty(String name, Object value) throws JellyTagException {
        Object object = this.getTaskObject();
        if (object != null) {
            this.setBeanProperty(object, name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag(XMLOutput output) throws JellyTagException {
        String body;
        Object id;
        Project project = this.getAntProject();
        String tagName = this.getTagName();
        Object parentObject = this.findBeanAncestor();
        Object parentTask = this.findParentTaskObject();
        Object nested = null;
        if (parentObject != null && !(parentTask instanceof TaskContainer)) {
            nested = this.createNestedObject(parentObject, tagName);
        }
        if (nested == null) {
            this.task = this.createTask(tagName);
            if (this.task != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating an ant Task for name: " + tagName));
                }
                if (this.task instanceof TaskAdapter) {
                    this.setObject(((TaskAdapter)this.task).getProxy());
                } else {
                    this.setObject(this.task);
                }
                id = this.getAttributes().remove("id");
                if (id != null) {
                    project.addReference((String)id, (Object)this.task);
                }
                this.task.init();
                body = this.getBodyText();
                this.setBeanProperties();
                Method method = MethodUtils.getAccessibleMethod(this.task.getClass(), (String)"addText", (Class[])addTaskParamTypes);
                if (method != null) {
                    Object[] args = new Object[]{body};
                    try {
                        method.invoke((Object)this.task, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new JellyTagException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new JellyTagException((Throwable)e);
                    }
                }
                PrintStream initialOut = System.out;
                PrintStream initialErr = System.err;
                PrintStream newOut = new PrintStream((OutputStream)new DemuxOutputStream(project, false));
                PrintStream newErr = new PrintStream((OutputStream)new DemuxOutputStream(project, true));
                try {
                    System.setOut(newOut);
                    System.setErr(newErr);
                    this.task.perform();
                }
                finally {
                    System.setOut(initialOut);
                    System.setErr(initialErr);
                }
            }
        }
        if (this.task == null) {
            if (nested == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying to create a data type for tag: " + tagName));
                }
                nested = this.createDataType(tagName);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Created nested property tag: " + tagName));
            }
            if (nested != null) {
                this.setObject(nested);
                id = this.getAttributes().remove("id");
                if (id != null) {
                    project.addReference((String)id, nested);
                }
                body = this.getBodyText();
                this.setBeanProperties();
                if (parentObject != null) {
                    IntrospectionHelper ih = IntrospectionHelper.getHelper(parentObject.getClass());
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("About to set the: " + tagName + " property on: " + parentObject + " to value: " + nested + " with type: " + nested.getClass()));
                        }
                        ih.storeElement(project, parentObject, nested, tagName.toLowerCase());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Caught exception setting nested: " + tagName), (Throwable)e);
                    }
                    try {
                        BeanUtils.setProperty((Object)parentObject, (String)tagName, (Object)nested);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Caught exception trying to set property: " + tagName + " on: " + parentObject));
                    }
                }
            } else {
                log.warn((Object)("Could not convert tag: " + tagName + " into an Ant task, data type or property"));
                StaticTag tag = new StaticTag("", tagName, tagName);
                tag.setParent(this.getParent());
                tag.setBody(this.getBody());
                tag.setContext(((TagSupport)this).context);
                Iterator iter = this.getAttributes().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    tag.setAttribute(name, value);
                }
                tag.doTag(output);
            }
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Project getAntProject() {
        Project project = AntTagLibrary.getProject(((TagSupport)this).context);
        if (project == null) {
            throw new NullPointerException("No Ant Project object is available");
        }
        return project;
    }

    public void setBeanProperties() throws JellyTagException {
        Object object = this.getTaskObject();
        if (object != null) {
            Map map = this.getAttributes();
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.setBeanProperty(object, name, value);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            super.setAttribute(name, (Object)"");
        } else if (value instanceof Expression) {
            super.setAttribute(name, ((Expression)value).evaluateRecurse(((TagSupport)this).context));
        } else {
            super.setAttribute(name, (Object)value.toString());
        }
    }

    public void setBeanProperty(Object object, String name, Object value) throws JellyTagException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting bean property on: " + object + " name: " + name + " value: " + value));
        }
        IntrospectionHelper ih = IntrospectionHelper.getHelper(object.getClass());
        if (value instanceof String) {
            try {
                ih.setAttribute(this.getAntProject(), object, name.toLowerCase(), (String)value);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            ih.storeElement(this.getAntProject(), object, value, name);
        }
        catch (Exception e) {
            try {
                BeanUtils.setProperty((Object)object, (String)name, (Object)value);
            }
            catch (IllegalAccessException ex) {
                throw new JellyTagException((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new JellyTagException((Throwable)ex);
            }
        }
    }

    public Object createNestedObject(Object object, String name) {
        IntrospectionHelper ih;
        Object dataType = null;
        if (object != null && (ih = IntrospectionHelper.getHelper(object.getClass())) != null) {
            try {
                dataType = ih.createElement(this.getAntProject(), object, name.toLowerCase());
            }
            catch (BuildException be) {
                if (object instanceof Tag) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Failed attempt to create an ant datatype for a jelly tag", (Throwable)be);
                    }
                }
                log.error((Object)be);
            }
        }
        if (dataType == null) {
            dataType = this.createDataType(name);
        }
        return dataType;
    }

    public Object createDataType(String name) {
        Object dataType = null;
        Class type = (Class)this.getAntProject().getDataTypeDefinitions().get(name);
        if (type != null) {
            Constructor ctor = null;
            boolean noArg = false;
            try {
                ctor = type.getConstructor(new Class[0]);
                noArg = true;
            }
            catch (NoSuchMethodException nse) {
                try {
                    ctor = type.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntTag.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                    noArg = false;
                }
                catch (NoSuchMethodException nsme) {
                    log.info((Object)("datatype '" + name + "' didn't have a constructor with an Ant Project"), (Throwable)nsme);
                }
            }
            dataType = noArg ? this.createDataType(ctor, new Object[0], name, "no-arg constructor") : this.createDataType(ctor, new Object[]{this.getAntProject()}, name, "an Ant project");
            if (dataType != null) {
                ((DataType)dataType).setProject(this.getAntProject());
            }
        }
        return dataType;
    }

    private Object createDataType(Constructor ctor, Object[] args, String name, String argDescription) {
        try {
            Object datatype = ctor.newInstance(args);
            return datatype;
        }
        catch (InstantiationException ie) {
            log.error((Object)("datatype '" + name + "' couldn't be created with " + argDescription), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            log.error((Object)("datatype '" + name + "' couldn't be created with " + argDescription), (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            log.error((Object)("datatype '" + name + "' couldn't be created with " + argDescription), (Throwable)ite);
        }
        return null;
    }

    public Task createTask(String taskName) throws JellyTagException {
        return this.createTask(taskName, (Class)this.getAntProject().getTaskDefinitions().get(taskName));
    }

    public Task createTask(String taskName, Class taskType) throws JellyTagException {
        if (taskType == null) {
            return null;
        }
        Object o = null;
        try {
            o = taskType.newInstance();
        }
        catch (InstantiationException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException((Throwable)e);
        }
        Task task = null;
        if (o instanceof Task) {
            task = o;
        } else {
            TaskAdapter taskA = new TaskAdapter();
            taskA.setProxy(o);
            task = taskA;
        }
        task.setProject(this.getAntProject());
        task.setTaskName(taskName);
        return task;
    }

    protected Object findBeanAncestor() throws JellyTagException {
        for (Tag tag = this.getParent(); tag != null; tag = tag.getParent()) {
            if (tag instanceof BeanSource) {
                BeanSource beanSource = (BeanSource)tag;
                return beanSource.getBean();
            }
            if (!(tag instanceof TaskSource)) continue;
            TaskSource taskSource = (TaskSource)tag;
            return taskSource.getTaskObject();
        }
        return this.getParent();
    }

    protected Object findParentTaskObject() throws JellyTagException {
        for (Tag tag = this.getParent(); tag != null; tag = tag.getParent()) {
            if (!(tag instanceof TaskSource)) continue;
            TaskSource source = (TaskSource)tag;
            return source.getTaskObject();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

