/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.util.HttpUtils;

public abstract class AbstractSourcesDownloader
extends AbstractMavenComponent {
    protected static final String PROXY_LOGINHOST = "maven.proxy.ntlm.host";
    protected static final String PROXY_LOGINDOMAIN = "maven.proxy.ntlm.domain";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$eclipse$AbstractSourcesDownloader == null ? (class$org$apache$maven$plugin$eclipse$AbstractSourcesDownloader = AbstractSourcesDownloader.class$("org.apache.maven.plugin.eclipse.AbstractSourcesDownloader")) : class$org$apache$maven$plugin$eclipse$AbstractSourcesDownloader));
    private Project project;
    private String groupId;
    private String artifactId;
    private String version;
    static /* synthetic */ Class class$org$apache$maven$plugin$eclipse$AbstractSourcesDownloader;

    public void downloadSources() throws Exception {
        if (this.project == null) {
            throw new NullPointerException("project should be set.");
        }
        if (this.groupId == null) {
            throw new NullPointerException("groupId should be set.");
        }
        if (this.artifactId == null) {
            throw new NullPointerException("artifactId should be set.");
        }
        if (this.version == null) {
            throw new NullPointerException("version should be set.");
        }
        String dependencyId = this.groupId + ":" + this.artifactId;
        Dependency dependency = this.project.getDependency(dependencyId);
        if (dependency == null) {
            log.warn((Object)("Could not retrieve dependency object for[" + dependencyId + "] - skipping"));
            return;
        }
        String relativePath = this.buildRelativePath();
        File localFile = new File(this.project.getContext().getMavenRepoLocal(), relativePath);
        if (this.isSnapshot()) {
            this.getRemoteArtifact(localFile, relativePath, dependency);
        } else if (localFile.exists()) {
            log.debug((Object)(this.getSourceName() + " for[" + this.groupId + ":" + this.artifactId + ":" + this.version + "] is available in the local repository."));
        } else {
            this.getRemoteArtifact(localFile, relativePath, dependency);
        }
    }

    protected abstract String buildRelativePath();

    protected abstract String getSourceName();

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected boolean isSnapshot() {
        return this.version.endsWith("SNAPSHOT");
    }

    protected boolean getRemoteArtifact(File destinationFile, String relativePath, Dependency relatedDependency) {
        File directory = destinationFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        log.info((Object)("Attempting to download " + this.getSourceName() + " for " + relatedDependency.getArtifact()));
        boolean artifactFound = false;
        Iterator i = this.getProject().getContext().getMavenRepoRemote().iterator();
        while (i.hasNext()) {
            String remoteRepo = (String)i.next();
            if (remoteRepo.endsWith("/")) {
                remoteRepo = remoteRepo.substring(0, remoteRepo.length() - 1);
            }
            String url = remoteRepo + "/" + relativePath;
            if (!(url = StringUtils.replace((String)url, (String)"//", (String)"/")).startsWith("file")) {
                url = url.startsWith("https") ? StringUtils.replace((String)url, (String)"https:/", (String)"https://") : StringUtils.replace((String)url, (String)"http:/", (String)"http://");
            }
            log.debug((Object)("Trying to download " + this.getSourceName() + " at " + url));
            try {
                String loginHost = (String)this.getProject().getContext().getVariable(PROXY_LOGINHOST);
                String loginDomain = (String)this.getProject().getContext().getVariable(PROXY_LOGINDOMAIN);
                HttpUtils.getFile((String)url, (File)destinationFile, (boolean)false, (boolean)true, (String)this.getProject().getContext().getProxyHost(), (String)this.getProject().getContext().getProxyPort(), (String)this.getProject().getContext().getProxyUserName(), (String)this.getProject().getContext().getProxyPassword(), (String)loginHost, (String)loginDomain, (boolean)true);
                artifactFound = true;
                if (this.isSnapshot()) continue;
                break;
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"File not found on one of the repos", (Throwable)e);
            }
            catch (Exception e) {
                String[] parsedUrl = HttpUtils.parseUrl((String)url);
                log.warn((Object)("Error retrieving artifact from [" + parsedUrl[2] + "]: " + e));
                if (parsedUrl[0] != null) {
                    log.debug((Object)("Username was '" + parsedUrl[0] + "', password hidden"));
                }
                log.debug((Object)"Error details", (Throwable)e);
            }
        }
        return artifactFound;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

