/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.project.Project;
import org.apache.maven.util.HttpUtils;

public class JavaSourcesDownloader
extends AbstractMavenComponent {
    private static final String PROXY_LOGINHOST = "maven.proxy.ntlm.host";
    private static final String PROXY_LOGINDOMAIN = "maven.proxy.ntlm.domain";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$source$JavaSourcesDownloader == null ? (class$org$apache$maven$plugin$source$JavaSourcesDownloader = JavaSourcesDownloader.class$("org.apache.maven.plugin.source.JavaSourcesDownloader")) : class$org$apache$maven$plugin$source$JavaSourcesDownloader));
    private Project project;
    private String groupId;
    private String artifactId;
    private String version;
    private boolean ignoreErrors;
    private boolean backwardCompatible;
    static /* synthetic */ Class class$org$apache$maven$plugin$source$JavaSourcesDownloader;

    public void downloadJavaSources() throws NullPointerException, FileNotFoundException {
        boolean artifactFound;
        if (this.project == null) {
            throw new NullPointerException("project should be set.");
        }
        if (this.groupId == null) {
            throw new NullPointerException("groupId should be set.");
        }
        if (this.artifactId == null) {
            throw new NullPointerException("artifactId should be set.");
        }
        if (this.version == null) {
            throw new NullPointerException("version should be set.");
        }
        String dependencyId = this.groupId + ":" + this.artifactId + ":" + this.version;
        String relativePath = this.buildRelativePath();
        File localFile = new File(this.project.getContext().getMavenRepoLocal(), relativePath);
        String backwareCompatibleRelativePath = this.buildBackwardCompatibleRelativePath();
        File backwardCompatibleLocalFile = new File(this.project.getContext().getMavenRepoLocal(), backwareCompatibleRelativePath);
        if (this.isSnapshot()) {
            artifactFound = this.getRemoteArtifact(localFile, relativePath, dependencyId);
            if (this.backwardCompatible) {
                artifactFound = this.getRemoteArtifact(backwardCompatibleLocalFile, backwareCompatibleRelativePath, dependencyId);
            }
            if (localFile.exists() || this.backwardCompatible && backwardCompatibleLocalFile.exists()) {
                return;
            }
        } else {
            if (localFile.exists() || this.backwardCompatible && backwardCompatibleLocalFile.exists()) {
                log.debug((Object)("source for " + dependencyId + " is available in the local repository."));
                return;
            }
            artifactFound = this.getRemoteArtifact(localFile, relativePath, dependencyId);
            if (!artifactFound && this.backwardCompatible) {
                artifactFound = this.getRemoteArtifact(backwardCompatibleLocalFile, backwareCompatibleRelativePath, dependencyId);
            }
        }
        if (!this.ignoreErrors && !artifactFound) {
            throw new FileNotFoundException("Could not download source for " + dependencyId + " from any repository " + this.getProject().getContext().getMavenRepoRemote());
        }
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isBackwardCompatible() {
        return this.backwardCompatible;
    }

    public void setBackwardCompatible(boolean backwardCompatible) {
        this.backwardCompatible = backwardCompatible;
    }

    private String buildRelativePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.groupId).append("/java-sources/").append(this.artifactId).append("-").append(this.version).append("-sources.jar");
        return sb.toString();
    }

    private String buildBackwardCompatibleRelativePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.groupId).append("/src/").append(this.artifactId).append("-").append(this.version).append(".zip");
        return sb.toString();
    }

    private boolean isSnapshot() {
        return this.version.endsWith("SNAPSHOT");
    }

    private boolean getRemoteArtifact(File destinationFile, String relativePath, String dependencyId) {
        File directory = destinationFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        log.info((Object)("Attempting to download sources for " + dependencyId + " (" + relativePath + ")"));
        boolean artifactFound = false;
        Iterator i = this.getProject().getContext().getMavenRepoRemote().iterator();
        while (i.hasNext()) {
            String remoteRepo = (String)i.next();
            if (remoteRepo.endsWith("/")) {
                remoteRepo = remoteRepo.substring(0, remoteRepo.length() - 1);
            }
            String url = remoteRepo + "/" + relativePath;
            if (!(url = StringUtils.replace((String)url, (String)"//", (String)"/")).startsWith("file")) {
                url = url.startsWith("https") ? StringUtils.replace((String)url, (String)"https:/", (String)"https://") : StringUtils.replace((String)url, (String)"http:/", (String)"http://");
            }
            log.debug((Object)("Trying to download source at " + url));
            try {
                String loginHost = (String)this.getProject().getContext().getVariable(PROXY_LOGINHOST);
                String loginDomain = (String)this.getProject().getContext().getVariable(PROXY_LOGINDOMAIN);
                HttpUtils.getFile((String)url, (File)destinationFile, (boolean)false, (boolean)true, (String)this.getProject().getContext().getProxyHost(), (String)this.getProject().getContext().getProxyPort(), (String)this.getProject().getContext().getProxyUserName(), (String)this.getProject().getContext().getProxyPassword(), (String)loginHost, (String)loginDomain, (boolean)true);
                artifactFound = true;
                if (this.isSnapshot()) continue;
                log.info((Object)("Downloded source for " + dependencyId + " at " + url));
                break;
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"File not found on one of the repos", (Throwable)e);
            }
            catch (Exception e) {
                String[] parsedUrl = HttpUtils.parseUrl((String)url);
                log.warn((Object)("Error retrieving artifact from [" + parsedUrl[2] + "]: " + e));
                if (parsedUrl[0] != null) {
                    log.debug((Object)("Username was '" + parsedUrl[0] + "', password hidden"));
                }
                log.debug((Object)"Error details", (Throwable)e);
            }
        }
        return artifactFound;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

