/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.werkz.jelly;

import java.util.StringTokenizer;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.werkz.Action;
import org.apache.maven.werkz.CyclicGoalChainException;
import org.apache.maven.werkz.DefaultAction;
import org.apache.maven.werkz.Goal;
import org.apache.maven.werkz.Session;
import org.apache.maven.werkz.jelly.WerkzTagSupport;

public class GoalTag
extends WerkzTagSupport {
    private static final Log LOGGER = LogFactory.getLog((Class)GoalTag.class);
    private String name;
    private String prereqs;
    private String description;

    public void doTag(final XMLOutput output) throws JellyTagException {
        LOGGER.debug((Object)("doTag(..):" + this.name));
        Goal goal = this.getProject().getGoal(this.getName(), true);
        goal.setDescription(this.description);
        try {
            this.addPrereqs(goal);
        }
        catch (CyclicGoalChainException e) {
            throw new JellyTagException((Throwable)e);
        }
        Action action = this.getAction();
        if (action == null) {
            action = new DefaultAction(){

                public void performAction(Session session) throws Exception {
                    this.performAction();
                }

                public void performAction() throws Exception {
                    LOGGER.debug((Object)("Running action of target: " + GoalTag.this.getName()));
                    GoalTag.this.invokeBody(output);
                }
            };
        }
        goal.setAction(action);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        LOGGER.debug((Object)("setName(" + name + ")"));
        this.name = name;
    }

    public void setPrereqs(String prereqs) {
        this.prereqs = prereqs;
    }

    public String getPrereqs() {
        return this.prereqs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void addPrereqs(Goal goal) throws CyclicGoalChainException {
        String prereqs = this.getPrereqs();
        if (prereqs == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(this.getPrereqs(), ",");
        String eachToken = null;
        Goal eachPrereq = null;
        while (tokens.hasMoreTokens()) {
            eachToken = tokens.nextToken().trim();
            eachPrereq = this.getProject().getGoal(eachToken, true);
            goal.addPrecursor(eachPrereq);
        }
    }

    protected Action getAction() {
        return null;
    }
}

