/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.werkz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.werkz.Action;
import org.apache.maven.werkz.CyclicGoalChainException;
import org.apache.maven.werkz.NoActionDefinitionException;
import org.apache.maven.werkz.PostActionCallback;
import org.apache.maven.werkz.PostGoalCallback;
import org.apache.maven.werkz.PreActionCallback;
import org.apache.maven.werkz.PreGoalCallback;
import org.apache.maven.werkz.Session;
import org.apache.maven.werkz.UnattainableGoalException;

public class Goal {
    public static final Goal[] EMPTY_ARRAY = new Goal[0];
    private String name;
    private List precursors;
    private List postcursors;
    private Action action;
    private List preGoalCallbacks;
    private List postGoalCallbacks;
    private List preActionCallbacks;
    private List postActionCallbacks;
    private String description;

    public Goal(String name) {
        this.name = name;
        this.precursors = Collections.EMPTY_LIST;
        this.postcursors = Collections.EMPTY_LIST;
        this.preGoalCallbacks = Collections.EMPTY_LIST;
        this.postGoalCallbacks = Collections.EMPTY_LIST;
        this.preActionCallbacks = Collections.EMPTY_LIST;
        this.postActionCallbacks = Collections.EMPTY_LIST;
    }

    public Goal(String name, Action action) {
        this(name);
        this.setAction(action);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void addPreGoalCallback(PreGoalCallback callback) {
        if (((Object)Collections.EMPTY_LIST).equals(this.preGoalCallbacks)) {
            this.preGoalCallbacks = Collections.synchronizedList(new ArrayList(3));
        }
        this.preGoalCallbacks.add(callback);
    }

    public void removePreGoalCallback(PreGoalCallback callback) {
        while (this.preGoalCallbacks.remove(callback)) {
        }
    }

    public List getPreGoalCallbacks() {
        return Collections.unmodifiableList(this.preGoalCallbacks);
    }

    public void addPostGoalCallback(PostGoalCallback callback) {
        if (((Object)Collections.EMPTY_LIST).equals(this.postGoalCallbacks)) {
            this.postGoalCallbacks = Collections.synchronizedList(new ArrayList(3));
        }
        this.postGoalCallbacks.add(callback);
    }

    public void removePostGoalCallback(PostGoalCallback callback) {
        while (this.postGoalCallbacks.remove(callback)) {
        }
    }

    public List getPostGoalCallbacks() {
        return Collections.unmodifiableList(this.postGoalCallbacks);
    }

    public void addPreActionCallback(PreActionCallback callback) {
        if (((Object)this.preActionCallbacks).equals(Collections.EMPTY_LIST)) {
            this.preActionCallbacks = Collections.synchronizedList(new ArrayList(3));
        }
        this.preActionCallbacks.add(callback);
    }

    public void removePreActionCallback(PreActionCallback callback) {
        while (this.preActionCallbacks.remove(callback)) {
        }
    }

    public List getPreActionCallbacks() {
        return Collections.unmodifiableList(this.preActionCallbacks);
    }

    public void addPostActionCallback(PostActionCallback callback) {
        if (((Object)this.postActionCallbacks).equals(Collections.EMPTY_LIST)) {
            this.postActionCallbacks = Collections.synchronizedList(new ArrayList(3));
        }
        this.postActionCallbacks.add(callback);
    }

    public void removePostActionCallback(PostActionCallback callback) {
        while (this.postActionCallbacks.remove(callback)) {
        }
    }

    public List getPostActionCallbacks() {
        return Collections.unmodifiableList(this.postActionCallbacks);
    }

    public boolean isSatisfied(Session session) {
        return session.isGoalSatisfied(this);
    }

    public void addPrecursor(Goal precursor) throws CyclicGoalChainException {
        if (((Object)Collections.EMPTY_LIST).equals(this.precursors)) {
            this.precursors = Collections.synchronizedList(new ArrayList());
        }
        this.precursors.add(precursor);
        try {
            this.checkForCycles();
            precursor.addInternalPostcursor(this);
        }
        catch (CyclicGoalChainException e) {
            e.fillInStackTrace();
            this.precursors.remove(precursor);
            throw e;
        }
    }

    public void addPostcursor(Goal postcursor) throws CyclicGoalChainException {
        postcursor.addPrecursor(this);
    }

    private void addInternalPostcursor(Goal postcursor) {
        if (((Object)Collections.EMPTY_LIST).equals(this.postcursors)) {
            this.postcursors = Collections.synchronizedList(new ArrayList());
        }
        this.postcursors.add(postcursor);
    }

    public List getPrecursors() {
        return Collections.unmodifiableList(this.precursors);
    }

    public List getPostcursors() {
        return Collections.unmodifiableList(this.postcursors);
    }

    void attainPrecursors(Session session) throws UnattainableGoalException, NoActionDefinitionException {
        Iterator precursorIter = this.getPrecursors().iterator();
        Goal eachPrereq = null;
        while (precursorIter.hasNext()) {
            eachPrereq = (Goal)precursorIter.next();
            eachPrereq.attain(session);
        }
    }

    void percolatePostcursors(Session session) throws UnattainableGoalException, NoActionDefinitionException {
        Iterator postreqIter = this.getPostcursors().iterator();
        Goal eachPostreq = null;
        while (postreqIter.hasNext()) {
            eachPostreq = (Goal)postreqIter.next();
            eachPostreq.percolate(session);
        }
    }

    void checkForCycles() throws CyclicGoalChainException {
        HashSet visited = new HashSet();
        this.checkForCycles(this, visited);
    }

    void checkForCycles(Goal initialGoal, Set visited) throws CyclicGoalChainException {
        if (visited.contains(this)) {
            throw new CyclicGoalChainException(initialGoal);
        }
        visited.add(this);
        Iterator precursorIter = this.getPrecursors().iterator();
        Goal eachPrereq = null;
        while (precursorIter.hasNext()) {
            eachPrereq = (Goal)precursorIter.next();
            eachPrereq.checkForCycles(initialGoal, visited);
            visited.remove(eachPrereq);
        }
    }

    public final void attain(Session session) throws UnattainableGoalException, NoActionDefinitionException {
        if (session.isGoalSatisfied(this)) {
            return;
        }
        this.attainPrecursors(session);
        this.fire(session);
    }

    public final void percolate(Session session) throws UnattainableGoalException, NoActionDefinitionException {
        if (session.isGoalSatisfied(this)) {
            return;
        }
        this.fire(session);
        this.percolatePostcursors(session);
    }

    private final void fire(Session session) throws UnattainableGoalException, NoActionDefinitionException {
        session.info(this.getName() + ":");
        try {
            this.firePreGoalCallbacks();
        }
        catch (Exception e) {
            throw new UnattainableGoalException(this.getName(), e);
        }
        Action action = this.getAction();
        if (action == null) {
            throw new NoActionDefinitionException(this);
        }
        if (action.requiresAction()) {
            try {
                this.firePreActionCallbacks();
                this.getAction().performAction(session);
                this.firePostActionCallbacks();
            }
            catch (Exception e) {
                throw new UnattainableGoalException(this.getName(), e);
            }
        }
        try {
            this.firePostGoalCallbacks();
        }
        catch (Exception e) {
            throw new UnattainableGoalException(this.getName(), e);
        }
        session.addSatisfiedGoal(this);
        session.info("");
    }

    void firePreGoalCallbacks() throws Exception {
        Iterator callbackIter = this.preGoalCallbacks.iterator();
        PreGoalCallback eachCallback = null;
        if (!callbackIter.hasNext()) {
            return;
        }
        while (callbackIter.hasNext()) {
            eachCallback = (PreGoalCallback)callbackIter.next();
            eachCallback.firePreGoal(this);
        }
    }

    void firePostGoalCallbacks() throws Exception {
        Iterator callbackIter = this.postGoalCallbacks.iterator();
        PostGoalCallback eachCallback = null;
        while (callbackIter.hasNext()) {
            eachCallback = (PostGoalCallback)callbackIter.next();
            eachCallback.firePostGoal(this);
        }
    }

    void firePreActionCallbacks() throws Exception {
        Iterator callbackIter = this.preActionCallbacks.iterator();
        PreActionCallback eachCallback = null;
        while (callbackIter.hasNext()) {
            eachCallback = (PreActionCallback)callbackIter.next();
            eachCallback.firePreAction(this);
        }
    }

    void firePostActionCallbacks() throws Exception {
        Iterator callbackIter = this.postActionCallbacks.iterator();
        PostActionCallback eachCallback = null;
        while (callbackIter.hasNext()) {
            eachCallback = (PostActionCallback)callbackIter.next();
            eachCallback.firePostAction(this);
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object thatObj) {
        Goal that = (Goal)thatObj;
        return this.getName().equals(that.getName());
    }

    public String toString() {
        return "[Goal: name=\"" + this.getName() + "\"]" + "; precursor=" + this.getPrecursors() + "]";
    }
}

