/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.net.URL;

public class ResourceBean {
    private ClassLoader classLoader;

    public URL findResource(String name) {
        URL answer = null;
        if (this.classLoader != null) {
            answer = this.classLoader.getResource(name);
        }
        if (answer == null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                answer = contextClassLoader.getResource(name);
            }
            if (answer == null) {
                answer = this.getClass().getClassLoader().getResource(name);
            }
        }
        return answer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

