/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.util.BootstrapDownloadMeter;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public class HttpUtils {
    private static final Log LOGGER = LogFactory.getLog((Class)HttpUtils.class);

    public static void useProxyUser(String proxyHost, String proxyPort, final String proxyUserName, final String proxyPassword) {
        if (proxyHost != null && proxyPort != null) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", proxyHost);
            System.getProperties().put("proxyPort", proxyPort);
            if (proxyUserName != null) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUserName, proxyPassword == null ? new char[]{} : proxyPassword.toCharArray());
                    }
                });
            }
        }
    }

    public static void getFile(String url, File destinationFile, boolean ignoreErrors, boolean useTimestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword, boolean useChecksum) throws IOException {
        HttpUtils.getFile(url, destinationFile, ignoreErrors, useTimestamp, proxyHost, proxyPort, proxyUserName, proxyPassword, null, null, useChecksum);
    }

    public static void getFile(String url, File destinationFile, boolean ignoreErrors, boolean useTimestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword, String loginHost, String loginDomain, boolean useChecksum) throws IOException {
        HttpUtils.getFile(url, destinationFile, ignoreErrors, useTimestamp, proxyHost, proxyPort, proxyUserName, proxyPassword, loginHost, loginDomain);
        if (useChecksum) {
            File checksumFile = new File(destinationFile + ".md5");
            try {
                HttpUtils.getFile(url + ".md5", checksumFile, ignoreErrors, useTimestamp, proxyHost, proxyPort, proxyUserName, proxyPassword, loginHost, loginDomain);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void getFile(String url, File destinationFile, boolean ignoreErrors, boolean useTimestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword) throws IOException {
        HttpUtils.getFile(url, destinationFile, ignoreErrors, useTimestamp, proxyHost, proxyPort, proxyUserName, proxyPassword, null, null);
    }

    public static void getFile(String url, File destinationFile, boolean ignoreErrors, boolean useTimestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword, String loginHost, String loginDomain) throws IOException {
        block3: {
            long timestamp = -1L;
            if (useTimestamp && destinationFile.exists()) {
                timestamp = destinationFile.lastModified();
            }
            try {
                HttpUtils.getFile(url, destinationFile, timestamp, proxyHost, proxyPort, proxyUserName, proxyPassword, loginHost, loginDomain);
            }
            catch (IOException ex) {
                if (ignoreErrors) break block3;
                throw ex;
            }
        }
    }

    public static void getFile(String url, File destinationFile, long timestamp, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword, String loginHost, String loginDomain) throws IOException {
        int index = url.lastIndexOf("/");
        String file = url.substring(index + 1);
        Repository repository = new Repository("httputils", url = url.substring(0, index));
        Object wagon = "http".equals(repository.getProtocol()) ? new HttpWagon() : new FileWagon();
        wagon.addTransferListener((TransferListener)new BootstrapDownloadMeter());
        ProxyInfo proxyInfo = null;
        if (proxyHost != null) {
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(proxyHost);
            proxyInfo.setPort(Integer.valueOf(proxyPort).intValue());
            proxyInfo.setUserName(proxyUserName);
            proxyInfo.setPassword(proxyPassword);
            proxyInfo.setNtlmHost(loginHost);
            proxyInfo.setNtlmDomain(loginDomain);
        }
        try {
            wagon.connect(repository, proxyInfo);
            wagon.getIfNewer(file, destinationFile, timestamp);
        }
        catch (Exception e) {
            throw new IOException("Transfer failure: " + e);
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                LOGGER.debug((Object)"Failure to disconnect", (Throwable)e);
            }
        }
    }

    public static String[] parseUrl(String url) {
        String[] parsedUrl = new String[]{null, null, url};
        int i = url.indexOf("@");
        if (i > 0) {
            String protocol = url.substring(0, url.indexOf("://")) + "://";
            String s = url.substring(protocol.length(), i);
            int j = s.indexOf(":");
            parsedUrl[0] = s.substring(0, j);
            parsedUrl[1] = s.substring(j + 1);
            parsedUrl[2] = protocol + url.substring(i + 1);
        }
        return parsedUrl;
    }
}

