/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.util.FileUtils;

public class Expand {
    private static final Log LOGGER = LogFactory.getLog((Class)Expand.class);
    private File dest;
    private File source;
    private boolean overwrite = true;
    private FileUtils fileUtils;

    public void execute() throws IOException {
        this.expandFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandFile() throws IOException {
        ZipInputStream zis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.source);
            zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            this.setFileUtils(FileUtils.newFileUtils());
            while ((ze = zis.getNextEntry()) != null) {
                this.extractFile(zis, ze.getName(), new Date(ze.getTime()), ze.isDirectory());
            }
            LOGGER.debug((Object)"expand complete");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                }
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
        File f = this.fileUtils.resolveFile(this.dest, entryName);
        if (!this.overwrite && f.exists() && f.lastModified() >= entryDate.getTime()) {
            LOGGER.debug((Object)("Skipping " + f + " as it is up-to-date"));
            return;
        }
        File dirF = f.getParentFile();
        dirF.mkdirs();
        if (isDirectory) {
            f.mkdirs();
        } else {
            byte[] buffer = new byte[1024];
            int length = 0;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                while ((length = compressedInputStream.read(buffer)) >= 0) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
                fos = null;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                    }
                }
            }
        }
        this.fileUtils.setFileLastModified(f, entryDate.getTime());
    }

    public void setDest(File d) {
        this.dest = d;
    }

    public void setSrc(File s) {
        this.source = s;
    }

    public void setOverwrite(boolean shouldOverwrite) {
        this.overwrite = shouldOverwrite;
    }

    public void setFileUtils(FileUtils utils) {
        this.fileUtils = utils;
    }
}

