/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.util.BootstrapDownloadMeter;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;

public class ConsoleDownloadMeter
implements TransferListener {
    private static final Log LOGGER = LogFactory.getLog((Class)BootstrapDownloadMeter.class);
    private long complete;

    public void transferInitiated(TransferEvent transferEvent) {
    }

    public void transferStarted(TransferEvent transferEvent) {
        this.complete = 0L;
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        long total = transferEvent.getResource().getContentLength();
        this.complete += (long)length;
        System.out.print(this.complete / 1024L + "/" + (total == 0L ? "?" : total / 1024L + "K") + "\r");
    }

    public void transferCompleted(TransferEvent transferEvent) {
        long total = transferEvent.getResource().getContentLength();
        LOGGER.info((Object)(total / 1024L + "K downloaded"));
    }

    public void transferError(TransferEvent transferEvent) {
        LOGGER.error((Object)transferEvent.getException().getMessage());
    }

    public void debug(String message) {
        LOGGER.debug((Object)message);
    }
}

