/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.ByteArrayOutputStream;

public final class Base64 {
    private static final String CRLF = System.getProperty("line.separator");
    private static final int LINE_END = 64;

    public static String encode(byte[] data) {
        return Base64.encode(data, true);
    }

    public static String encode(byte[] data, boolean useLineDelimiter) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        int padding = 3 - data.length % 3;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; i += 3) {
            int neutral = data[i] < 0 ? data[i] + 256 : data[i];
            int block = neutral & 0xFF;
            boolean inLastSegment = false;
            block <<= 8;
            if (i + 1 < data.length) {
                neutral = data[i + 1] < 0 ? data[i + 1] + 256 : data[i + 1];
                block |= neutral & 0xFF;
            } else {
                inLastSegment = true;
            }
            block <<= 8;
            if (i + 2 < data.length) {
                neutral = data[i + 2] < 0 ? data[i + 2] + 256 : data[i + 2];
                block |= neutral & 0xFF;
            } else {
                inLastSegment = true;
            }
            char[] encoded = new char[]{Base64.toBase64Char(block >>> 18 & 0x3F), Base64.toBase64Char(block >>> 12 & 0x3F), inLastSegment && padding > 1 ? (char)'=' : Base64.toBase64Char(block >>> 6 & 0x3F), inLastSegment && padding > 0 ? (char)'=' : Base64.toBase64Char(block & 0x3F)};
            buffer.append(encoded);
        }
        if (useLineDelimiter) {
            return Base64.canonicalize(buffer.toString());
        }
        return buffer.toString();
    }

    public static byte[] decode(String src) {
        return Base64.decode(src, true);
    }

    public static byte[] decode(String src, boolean useLineDelimiter) {
        if (src == null) {
            return null;
        }
        if (src.length() < 1) {
            return new byte[0];
        }
        String data = src;
        if (useLineDelimiter) {
            data = Base64.deCanonicalize(src);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        char[] input = data.toCharArray();
        for (int i = 0; i < input.length; i += 4) {
            int block = Base64.toBase64Int(input[i]) & 0x3F;
            block <<= 6;
            block |= Base64.toBase64Int(input[i + 1]) & 0x3F;
            boolean inPadding = false;
            boolean twoCharPadding = false;
            block <<= 6;
            if (input[i + 2] != '=') {
                block |= Base64.toBase64Int(input[i + 2]) & 0x3F;
            } else {
                twoCharPadding = true;
                inPadding = true;
            }
            block <<= 6;
            if (input[i + 3] != '=') {
                block |= Base64.toBase64Int(input[i + 3]) & 0x3F;
            } else {
                inPadding = true;
            }
            baos.write(block >>> 16 & 0xFF);
            if (!inPadding || !twoCharPadding) {
                baos.write(block >>> 8 & 0xFF);
            }
            if (inPadding) continue;
            baos.write(block & 0xFF);
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    private static char toBase64Char(int input) {
        if (input > -1 && input < 26) {
            return (char)(65 + input);
        }
        if (input > 25 && input < 52) {
            return (char)(97 + input - 26);
        }
        if (input > 51 && input < 62) {
            return (char)(48 + input - 52);
        }
        if (input == 62) {
            return '+';
        }
        if (input == 63) {
            return '/';
        }
        return '?';
    }

    private static int toBase64Int(char input) {
        if (input >= 'A' && input <= 'Z') {
            return input - 65;
        }
        if (input >= 'a' && input <= 'z') {
            return input + 26 - 97;
        }
        if (input >= '0' && input <= '9') {
            return input + 52 - 48;
        }
        if (input == '+') {
            return 62;
        }
        if (input == '/') {
            return 63;
        }
        return 0;
    }

    private static String deCanonicalize(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(data.length());
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '\r' || c == '\n') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String canonicalize(String data) {
        StringBuffer buffer = new StringBuffer((int)((double)data.length() * 1.1));
        int col = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (col == 64) {
                buffer.append(CRLF);
                col = 0;
            }
            buffer.append(data.charAt(i));
            ++col;
        }
        buffer.append(CRLF);
        return buffer.toString();
    }
}

