/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import com.werken.forehead.Forehead;
import com.werken.forehead.ForeheadClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.AntProjectBuilder;
import org.apache.maven.MavenException;
import org.apache.maven.MavenSession;
import org.apache.maven.MavenUtils;
import org.apache.maven.UnknownGoalException;
import org.apache.maven.jelly.JellyUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.GoalToJellyScriptHousingMapper;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginCacheManager;
import org.apache.maven.plugin.UnknownPluginException;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.apache.maven.util.Expand;
import org.apache.maven.werkz.Goal;
import org.apache.maven.werkz.NoSuchGoalException;
import org.apache.maven.werkz.WerkzProject;
import org.apache.maven.werkz.jelly.JellySession;

public class PluginManager
extends AbstractMavenComponent {
    private static final Log LOGGER = LogFactory.getLog((Class)PluginManager.class);
    public static final String GLOBAL_SESSION_KEY = "maven.session.global";
    public static final String PLUGIN_MANAGER = "maven.plugin.manager";
    public static final String PLUGIN_HOUSING = "maven.plugin.script.housing";
    public static final String GOAL_MAPPER = "maven.plugin.mapper";
    public static final String BASE_CONTEXT = "maven.goalAttainmentContext";
    private File pluginsDir;
    private File unpackedPluginsDir;
    private File userPluginsDir;
    private final Map pluginHousings = new HashMap();
    private final Map artifactIdToHousingMap = new HashMap();
    private MavenSession mavenSession;
    private final PluginCacheManager cacheManager = new PluginCacheManager();
    private GoalToJellyScriptHousingMapper mapper;
    private GoalToJellyScriptHousingMapper transientMapper = this.mapper = new GoalToJellyScriptHousingMapper();
    private Set delayedPops = new HashSet();
    private MavenJellyContext baseContext;
    private static final String PLUGIN_TEMP_MAP = "PluginManager.PLUGIN_TEMP_MAP";

    public PluginManager(MavenSession session) {
        this.mavenSession = session;
    }

    private Map getPluginFiles(File directory, boolean acceptDirectories) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, File> pluginFiles = new HashMap<String, File>();
        for (int i = 0; i < files.length; ++i) {
            String plugin = files[i].getName();
            if (files[i].isDirectory() && acceptDirectories) {
                pluginFiles.put(plugin, files[i]);
                continue;
            }
            int index = plugin.indexOf(".jar");
            if (index < 0) continue;
            String name = plugin.substring(0, index);
            pluginFiles.put(name, files[i]);
        }
        return pluginFiles;
    }

    private void loadUncachedPlugins(Map pluginFiles) throws IOException, MavenException {
        LOGGER.debug((Object)"Now loading uncached plugins");
        Iterator i = pluginFiles.keySet().iterator();
        while (i.hasNext()) {
            JellyScriptHousing housing;
            String name = (String)i.next();
            File pluginDir = (File)pluginFiles.get(name);
            if (this.isLoaded(name) || (housing = this.createPluginHousing(pluginDir)) == null) continue;
            this.cacheManager.registerPlugin(name, housing);
            housing.parse(this.cacheManager);
            housing.parse(this.mapper);
        }
    }

    public void initialize() throws IOException, MavenException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing Plugins!");
        }
        this.setPluginsDir(new File(this.mavenSession.getRootContext().getPluginsDir()));
        this.setUnpackedPluginsDir(new File(this.mavenSession.getRootContext().getUnpackedPluginsDir()));
        this.setUserPluginsDir(new File(this.mavenSession.getRootContext().getUserPluginsDir()));
        if (!this.getPluginsDir().isDirectory() || this.getPluginsDir().listFiles() != null && this.getPluginsDir().listFiles().length == 0) {
            throw new MavenException("Maven was badly installed. Please reinstall it.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Set plugin source directory to " + this.getPluginsDir().getAbsolutePath()));
            LOGGER.debug((Object)("Set unpacked plugin directory to " + this.getUnpackedPluginsDir().getAbsolutePath()));
            LOGGER.debug((Object)("Set user plugin directory to " + this.getUserPluginsDir().getAbsolutePath()));
        }
        this.verifyUnpackedPluginsDir();
        Map pluginFiles = this.getPluginFiles(this.pluginsDir, true);
        Map userPluginFiles = this.getPluginFiles(this.userPluginsDir, false);
        if (!userPluginFiles.isEmpty()) {
            pluginFiles.putAll(userPluginFiles);
        }
        this.cacheManager.loadCache(this.unpackedPluginsDir);
        Map pluginDirs = this.expandPluginFiles(pluginFiles);
        LOGGER.debug((Object)"Now mapping cached plugins");
        if (!this.cacheManager.mapPlugins(this.mapper, this, pluginDirs)) {
            LOGGER.info((Object)"Cache invalidated due to out of date plugins");
            Iterator i = this.pluginHousings.values().iterator();
            while (i.hasNext()) {
                JellyScriptHousing housing = (JellyScriptHousing)i.next();
                this.cacheManager.registerPlugin(housing.getName(), housing);
                housing.parse(this.cacheManager);
                housing.parse(this.mapper);
            }
        }
        this.loadUncachedPlugins(pluginDirs);
        this.cacheManager.saveCache(this.unpackedPluginsDir);
        LOGGER.debug((Object)"Finished initializing Plugins!");
    }

    private Map expandPluginFiles(Map pluginFiles) throws MavenException {
        HashMap<String, File> pluginDirs = new HashMap<String, File>();
        Iterator i = pluginFiles.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            File jarFile = (File)pluginFiles.get(name);
            File dir = jarFile;
            if (!dir.isDirectory()) {
                dir = this.unpackPlugin(name, jarFile, true);
            }
            pluginDirs.put(name, dir);
        }
        return pluginDirs;
    }

    JellyScriptHousing loadPluginHousing(String name, File pluginDir) throws IOException {
        JellyScriptHousing housing = (JellyScriptHousing)this.pluginHousings.get(name);
        return housing == null ? this.createLazyPluginHousing(pluginDir) : housing;
    }

    private JellyScriptHousing createPluginHousing(File pluginDir) throws MavenException, IOException {
        JellyScriptHousing housing = this.createLazyPluginHousing(pluginDir);
        if (housing != null) {
            String artifactId = housing.getProject().getArtifactId();
            this.mapArtifactIdToPluginHousing(artifactId, housing);
        }
        return housing;
    }

    void mapArtifactIdToPluginHousing(String artifactId, JellyScriptHousing housing) {
        if (this.artifactIdToHousingMap.containsKey(artifactId)) {
            JellyScriptHousing h = (JellyScriptHousing)this.artifactIdToHousingMap.get(artifactId);
            LOGGER.warn((Object)("WARNING: Plugin '" + artifactId + "' is already loaded from " + h.getName() + "; attempting to load " + housing.getName()));
        }
        this.artifactIdToHousingMap.put(artifactId, housing);
    }

    private JellyScriptHousing createLazyPluginHousing(File pluginDir) throws IOException {
        if (!pluginDir.isDirectory() || !new File(pluginDir, "project.xml").exists()) {
            LOGGER.debug((Object)("Not a plugin directory: " + pluginDir));
            return null;
        }
        String pluginName = pluginDir.getName();
        LOGGER.debug((Object)("Loading plugin '" + pluginName + "'"));
        JellyScriptHousing jellyScriptHousing = new JellyScriptHousing(pluginDir, this.mavenSession.getRootContext());
        this.pluginHousings.put(pluginName, jellyScriptHousing);
        return jellyScriptHousing;
    }

    private boolean isLoaded(String name) {
        return this.pluginHousings.containsKey(name);
    }

    private JellyScriptHousing createJellyScriptHousing(Project project, String systemId, InputStream jelly) throws Exception {
        JellyScriptHousing jellyScriptHousing = new JellyScriptHousing();
        try {
            Script script = JellyUtils.compileScript(jelly, systemId, project.getContext());
            jellyScriptHousing.setProject(project);
            jellyScriptHousing.setScript(script);
        }
        catch (Exception e) {
            throw new MavenException("Error parsing driver.jelly", e);
        }
        return jellyScriptHousing;
    }

    private JellyScriptHousing createJellyScriptHousing(Project project, File jelly) {
        JellyScriptHousing jellyScriptHousing = new JellyScriptHousing();
        jellyScriptHousing.setProject(project);
        jellyScriptHousing.setSource(jelly);
        return jellyScriptHousing;
    }

    public void processDependencies(Project project) throws MalformedURLException, Exception {
        if (project.getArtifacts() == null || project.getArtifacts().isEmpty()) {
            LOGGER.debug((Object)("No dependencies to process for project " + project.getName()));
            return;
        }
        ClassLoader cl = project.getContext().getClassLoader();
        if (!(cl instanceof ForeheadClassLoader)) {
            return;
        }
        ForeheadClassLoader projectClassLoader = (ForeheadClassLoader)cl;
        LOGGER.debug((Object)("Processing dependencies for project " + project.getName() + "; classloader " + projectClassLoader));
        Iterator i = project.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            Dependency dependency = artifact.getDependency();
            if (dependency.isPlugin()) {
                this.installPlugin(artifact.getFile(), project);
            }
            String dependencyClassLoader = dependency.getProperty("classloader");
            if (artifact.exists()) {
                if (dependency.isAddedToClasspath()) {
                    if (dependencyClassLoader != null) {
                        LOGGER.debug((Object)("DEPRECATION: " + dependency.getId() + " in project " + project.getId() + " forces the classloader '" + dependencyClassLoader + "'"));
                        LOGGER.debug((Object)"             This behaviour is deprecated. Please refer to the FAQ");
                        ForeheadClassLoader loader = Forehead.getInstance().getClassLoader(dependencyClassLoader);
                        if (loader == null) {
                            LOGGER.warn((Object)("classloader '" + dependencyClassLoader + "' not found. Adding dependencies to the project classloader instead"));
                            loader = projectClassLoader;
                        } else {
                            LOGGER.debug((Object)("poking dependency " + artifact.getFile() + " into classloader " + dependencyClassLoader));
                        }
                        loader.addURL(artifact.getFile().toURL());
                        continue;
                    }
                    LOGGER.debug((Object)("adding dependency " + artifact.getFile() + " into project classloader"));
                    projectClassLoader.addURL(artifact.getFile().toURL());
                    continue;
                }
                LOGGER.debug((Object)("Non classpath dependency: '" + artifact.getFile() + "' not added to classpath"));
                continue;
            }
            LOGGER.info((Object)("Artifact '" + artifact.getFile() + "' not found to add to classpath"));
        }
        project.getContext().setClassLoader((ClassLoader)projectClassLoader);
    }

    List readMavenXml(Project project, GoalToJellyScriptHousingMapper mapper) throws MavenException {
        ArrayList<JellyScriptHousing> projectHousings = new ArrayList<JellyScriptHousing>();
        for (Project p = project; p != null; p = p.getParent()) {
            if (!p.hasMavenXml()) continue;
            File mavenXml = p.getMavenXml();
            JellyScriptHousing jellyScriptHousing = this.createJellyScriptHousing(project, mavenXml);
            jellyScriptHousing.parse(mapper);
            projectHousings.add(jellyScriptHousing);
        }
        return projectHousings;
    }

    MavenJellyContext setupBaseContext(Project project) {
        MavenJellyContext prevBaseContext = this.baseContext;
        this.baseContext = new MavenJellyContext(this.mavenSession.getRootContext());
        this.baseContext.setInherit(true);
        JellyUtils.populateVariables(this.baseContext, project.getContext());
        project.pushContext(this.baseContext);
        this.baseContext.setProject(project);
        return prevBaseContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attainGoals(Project project, List goals) throws Exception {
        MavenJellyContext prevBaseContext = this.setupBaseContext(project);
        AntProjectBuilder.build(project, this.baseContext);
        this.transientMapper = new GoalToJellyScriptHousingMapper();
        JellySession session = new JellySession(this.baseContext.getXMLOutput());
        session.setAttribute(BASE_CONTEXT, (Object)this.baseContext);
        session.setAttribute(PLUGIN_MANAGER, this);
        session.setAttribute(GOAL_MAPPER, this.transientMapper);
        this.baseContext.setVariable(GLOBAL_SESSION_KEY, session);
        InputStream driver = this.getClass().getResourceAsStream("/driver.jelly");
        JellyScriptHousing driverHousing = this.createJellyScriptHousing(project, this.getClass().getResource("/driver.jelly").toString(), driver);
        driver.close();
        driver = this.getClass().getResourceAsStream("/driver.jelly");
        driverHousing.parse(this.transientMapper, null, driver);
        driver.close();
        List projectHousings = this.readMavenXml(project, this.transientMapper);
        if (goals != null) {
            Iterator i = goals.iterator();
            while (i.hasNext()) {
                String goal = (String)i.next();
                if (goal.trim().length() != 0) continue;
                i.remove();
            }
        }
        String defaultGoalName = this.transientMapper.getDefaultGoalName();
        if (project.getBuild() != null && project.getBuild().getDefaultGoal() != null) {
            defaultGoalName = project.getBuild().getDefaultGoal();
        }
        if (defaultGoalName != null) {
            Expression e = JellyUtils.decomposeExpression(defaultGoalName, this.baseContext);
            defaultGoalName = e.evaluateAsString((JellyContext)this.baseContext);
            this.baseContext.setVariable("maven.default.goal", defaultGoalName);
            if (goals != null && goals.size() == 0) {
                LOGGER.debug((Object)("Using default goal: " + defaultGoalName));
                goals.add(defaultGoalName);
            }
        }
        if (goals == null) {
            goals = Collections.EMPTY_LIST;
        } else {
            goals.add(0, "build:start");
            goals.add("build:end");
        }
        this.transientMapper.merge(this.mapper);
        WerkzProject werkzProject = new WerkzProject();
        this.baseContext.setWerkzProject(werkzProject);
        HashSet pluginSet = new HashSet();
        HashSet oldDelayedPops = new HashSet(this.delayedPops);
        this.delayedPops.clear();
        Thread.currentThread().setContextClassLoader(null);
        try {
            String goalName;
            this.runScript(driverHousing, this.baseContext);
            this.transientMapper.addResolvedPlugins(Collections.singletonList(driverHousing));
            project.verifyDependencies();
            this.processDependencies(project);
            Iterator j = projectHousings.iterator();
            while (j.hasNext()) {
                JellyScriptHousing housing = (JellyScriptHousing)j.next();
                this.runScript(housing, this.baseContext);
            }
            this.transientMapper.addResolvedPlugins(projectHousings);
            Iterator i = goals.iterator();
            while (i.hasNext()) {
                goalName = (String)i.next();
                pluginSet.addAll(this.prepAttainGoal(goalName, this.baseContext, this.transientMapper));
            }
            i = goals.iterator();
            while (i.hasNext()) {
                goalName = (String)i.next();
                LOGGER.debug((Object)("attaining goal " + goalName));
                try {
                    Goal goal = werkzProject.getGoal(goalName);
                    if (goal == null || goal.getAction() == null) {
                        throw new NoSuchGoalException(goalName);
                    }
                    goal.attain(session);
                }
                catch (NoSuchGoalException e) {
                    throw new UnknownGoalException(goalName);
                    return;
                }
            }
        }
        finally {
            this.cleanupAttainGoal(pluginSet);
            this.delayedPops = oldDelayedPops;
            this.reinstallPlugins(project.getContext());
            project.popContext();
            this.baseContext = prevBaseContext;
        }
    }

    public void cleanupAttainGoal(Set pluginSet) throws Exception {
        this.delayedPops.addAll(pluginSet);
        Iterator j = this.delayedPops.iterator();
        while (j.hasNext()) {
            JellyScriptHousing housing = (JellyScriptHousing)j.next();
            this.reinstallPlugins(housing.getProject().getContext());
            housing.getProject().popContext();
        }
        this.delayedPops.clear();
    }

    public Set prepAttainGoal(String goalName, MavenJellyContext baseContext, GoalToJellyScriptHousingMapper goalMapper) throws Exception {
        Set pluginSet = goalMapper.resolveJellyScriptHousings(goalName);
        Iterator j = pluginSet.iterator();
        while (j.hasNext()) {
            JellyScriptHousing housing = (JellyScriptHousing)j.next();
            this.initialiseHousingPluginContext(housing, baseContext);
        }
        return pluginSet;
    }

    private MavenJellyContext initialiseHousingPluginContext(JellyScriptHousing housing, MavenJellyContext baseContext) throws Exception {
        Project project = housing.getProject();
        MavenUtils.integrateMapInContext(housing.getPluginProperties(), baseContext);
        MavenJellyContext pluginContext = new MavenJellyContext(baseContext);
        project.pushContext(pluginContext);
        pluginContext.setInherit(true);
        pluginContext.setVariable("context", (Object)pluginContext);
        pluginContext.setVariable("plugin", project);
        pluginContext.setVariable("plugin.dir", housing.getPluginDirectory());
        pluginContext.setVariable("plugin.resources", new File(housing.getPluginDirectory(), "plugin-resources"));
        LOGGER.debug((Object)("initialising plugin housing: " + project));
        this.runScript(housing, pluginContext);
        return pluginContext;
    }

    private void setPluginsDir(File dir) {
        this.pluginsDir = dir;
    }

    private File getPluginsDir() {
        return this.pluginsDir;
    }

    private void setUserPluginsDir(File dir) {
        this.userPluginsDir = dir;
    }

    private File getUserPluginsDir() {
        return this.userPluginsDir;
    }

    private void setUnpackedPluginsDir(File dir) {
        this.unpackedPluginsDir = dir;
    }

    private File getUnpackedPluginsDir() {
        return this.unpackedPluginsDir;
    }

    public Set getGoalNames() {
        return this.mapper.getGoalNames();
    }

    public Set getGoalNames(Project project) throws MavenException {
        this.mapper = new GoalToJellyScriptHousingMapper();
        this.readMavenXml(project, this.mapper);
        return this.mapper.getGoalNames();
    }

    public void installPlugin(File file, Project parentProject) throws MavenException {
        this.installPlugin(file, parentProject, false);
    }

    public void installPlugin(File file, Project parentProject, boolean cache) throws MavenException {
        block8: {
            LOGGER.debug((Object)("Using plugin file: " + file));
            try {
                String pluginName = file.getCanonicalFile().getName();
                pluginName = pluginName.substring(0, pluginName.indexOf(".jar"));
                if (this.isLoaded(pluginName)) {
                    return;
                }
                File unpackedPluginDir = this.unpackPlugin(pluginName, file, cache);
                if (unpackedPluginDir != null) {
                    String artifactId;
                    JellyScriptHousing housing = this.createLazyPluginHousing(unpackedPluginDir);
                    if (housing != null) {
                        artifactId = housing.getProject().getArtifactId();
                        if (this.artifactIdToHousingMap.containsKey(artifactId)) {
                            JellyScriptHousing oldHousing = (JellyScriptHousing)this.artifactIdToHousingMap.get(artifactId);
                            LOGGER.debug((Object)("Temporarily uninstalling: " + oldHousing));
                            this.addPluginToReinstall(parentProject.getContext(), artifactId, oldHousing);
                            this.pluginHousings.remove(oldHousing.getName());
                            this.mapper.invalidatePlugin(oldHousing);
                            this.transientMapper.invalidatePlugin(oldHousing);
                            this.artifactIdToHousingMap.remove(artifactId);
                        }
                    } else {
                        throw new MavenException("Not a valid plugin file: " + file);
                    }
                    this.mapArtifactIdToPluginHousing(artifactId, housing);
                    LOGGER.debug((Object)("Installing plugin: " + housing));
                    housing.parse(this.transientMapper);
                    housing.parse(this.mapper);
                    if (cache) {
                        FileUtils.copyFileToDirectory((File)file, (File)this.userPluginsDir);
                        this.cacheManager.registerPlugin(pluginName, housing);
                        housing.parse(this.cacheManager);
                        this.cacheManager.saveCache(this.unpackedPluginsDir);
                    }
                    break block8;
                }
                throw new MavenException("Not a valid JAR file: " + file);
            }
            catch (IOException e) {
                throw new MavenException("Error installing plugin", e);
            }
        }
    }

    private void addPluginToReinstall(MavenJellyContext context, String artifactId, JellyScriptHousing housing) {
        HashMap<String, JellyScriptHousing> m = (HashMap<String, JellyScriptHousing>)context.getVariables().get(PLUGIN_TEMP_MAP);
        if (m == null) {
            m = new HashMap<String, JellyScriptHousing>();
            context.setVariable(PLUGIN_TEMP_MAP, m);
        }
        m.put(artifactId, housing);
    }

    private void reinstallPlugins(MavenJellyContext context) throws MavenException {
        Map m = (Map)context.getVariables().get(PLUGIN_TEMP_MAP);
        if (m != null) {
            Iterator i = m.keySet().iterator();
            while (i.hasNext()) {
                String artifactId = (String)i.next();
                JellyScriptHousing housing = (JellyScriptHousing)m.get(artifactId);
                this.pluginHousings.remove(housing.getName());
                this.mapper.invalidatePlugin(housing);
                this.transientMapper.invalidatePlugin(housing);
                housing = (JellyScriptHousing)m.get(artifactId);
                LOGGER.debug((Object)("Reinstalling: " + housing));
                housing.parse(this.transientMapper);
                housing.parse(this.mapper);
            }
        }
    }

    public void uninstallPlugin(String artifactId) throws IOException {
        LOGGER.debug((Object)("Uninstalling plugin: " + artifactId));
        JellyScriptHousing housing = (JellyScriptHousing)this.artifactIdToHousingMap.get(artifactId);
        if (housing == null) {
            LOGGER.warn((Object)("Plugin not found when attempting to uninstall '" + artifactId + "'"));
            return;
        }
        String name = housing.getName();
        this.pluginHousings.remove(name);
        this.cacheManager.invalidateCache(name);
        this.mapper.invalidatePlugin(housing);
        this.transientMapper.invalidatePlugin(housing);
        this.artifactIdToHousingMap.remove(artifactId);
        this.cacheManager.saveCache(this.unpackedPluginsDir);
    }

    public MavenJellyContext getPluginContext(String id) throws MavenException, UnknownPluginException {
        JellyScriptHousing housing = (JellyScriptHousing)this.artifactIdToHousingMap.get(id);
        if (housing != null) {
            Project project = housing.getProject();
            if (((Object)((Object)this.baseContext)).equals(project.getContext().getParent())) {
                LOGGER.debug((Object)("Plugin context for " + id + " already initialised for this base context"));
                return project.getContext();
            }
            LOGGER.debug((Object)("Plugin context for " + id + " not initialised for this base context: initialising inside getPluginContext"));
            try {
                return this.initialiseHousingPluginContext(housing, this.baseContext);
            }
            catch (Exception e) {
                throw new MavenException("Error initialising plugin context", e);
            }
        }
        throw new UnknownPluginException(id);
    }

    public String getGoalDescription(String goalName) {
        return this.mapper.getGoalDescription(goalName);
    }

    public void addDelayedPops(Set set) {
        this.delayedPops.addAll(set);
    }

    File unpackPlugin(String pluginName, File jarFile, boolean cache) throws MavenException {
        File unzipDir = new File(this.unpackedPluginsDir, pluginName);
        boolean exists = unzipDir.exists();
        if (!exists || jarFile.lastModified() > unzipDir.lastModified()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Unpacking " + jarFile.getName() + " to directory --> " + unzipDir.getAbsolutePath()));
            }
            if (cache) {
                this.cacheManager.invalidateCache(pluginName);
            }
            try {
                if (exists) {
                    FileUtils.deleteDirectory((File)unzipDir);
                }
                Expand unzipper = new Expand();
                unzipper.setSrc(jarFile);
                unzipper.setDest(unzipDir);
                unzipper.execute();
            }
            catch (IOException e) {
                throw new MavenException("Unable to extract plugin: " + jarFile, e);
            }
        }
        return unzipDir;
    }

    private Script loadScript(JellyScriptHousing jellyScriptHousing) throws Exception {
        if (jellyScriptHousing.getPluginDirectory() != null) {
            jellyScriptHousing.getProject().verifyDependencies();
            this.processDependencies(jellyScriptHousing.getProject());
            ClassLoader cl = jellyScriptHousing.getProject().getContext().getClassLoader();
            if (cl instanceof ForeheadClassLoader) {
                ForeheadClassLoader pluginClassLoader = (ForeheadClassLoader)cl;
                pluginClassLoader.addURL(jellyScriptHousing.getPluginDirectory().toURL());
            }
        }
        MavenJellyContext context = jellyScriptHousing.getProject().getContext();
        URL oldRoot = context.getRootURL();
        URL oldCurrent = context.getCurrentURL();
        context.setRootURL(jellyScriptHousing.getSource().toURL());
        context.setCurrentURL(jellyScriptHousing.getSource().toURL());
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Jelly script to parse : " + jellyScriptHousing.getSource().toURL()));
            }
            Script script = JellyUtils.compileScript(jellyScriptHousing.getSource(), (JellyContext)context);
            context.setRootURL(oldRoot);
            context.setCurrentURL(oldCurrent);
            return script;
        }
        catch (Exception e) {
            throw new MavenException("Error parsing: " + jellyScriptHousing.getSource(), e);
        }
    }

    void runScript(JellyScriptHousing jellyScriptHousing, MavenJellyContext context) throws Exception {
        LOGGER.debug((Object)("running script " + jellyScriptHousing.getSource()));
        Script s = jellyScriptHousing.getScript();
        if (s == null) {
            s = this.loadScript(jellyScriptHousing);
            jellyScriptHousing.setScript(s);
        }
        if (context.getVariable(PLUGIN_HOUSING) != null) {
            throw new IllegalStateException("nested plugin housings");
        }
        context.setVariable(PLUGIN_HOUSING, jellyScriptHousing);
        s.run((JellyContext)context, context.getXMLOutput());
        context.removeVariable(PLUGIN_HOUSING);
    }

    public Project getPluginProjectFromGoal(String goal) throws MavenException {
        JellyScriptHousing housing = this.mapper.getPluginHousing(goal);
        return housing != null ? housing.getProject() : null;
    }

    public Collection getPluginList() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.pluginHousings.values().iterator();
        while (i.hasNext()) {
            JellyScriptHousing housing = (JellyScriptHousing)i.next();
            list.add(housing.getName());
        }
        Collections.sort(list);
        return list;
    }

    private void verifyUnpackedPluginsDir() throws MavenException {
        if (!this.unpackedPluginsDir.exists()) {
            LOGGER.warn((Object)this.getMessage("directory.nonexistant.warning", this.unpackedPluginsDir));
            if (!this.unpackedPluginsDir.mkdirs()) {
                throw new MavenException(this.getMessage("cannot.create.directory.warning", this.unpackedPluginsDir));
            }
        }
        if (!this.unpackedPluginsDir.isDirectory()) {
            throw new MavenException(this.getMessage("not.directory.warning", this.unpackedPluginsDir));
        }
        if (!this.unpackedPluginsDir.canWrite()) {
            throw new MavenException(this.getMessage("not.writable.warning", this.unpackedPluginsDir));
        }
    }
}

