/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenException;
import org.apache.maven.MavenSession;
import org.apache.maven.plugin.GoalToJellyScriptHousingMapper;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.apache.maven.plugin.PluginManager;
import org.codehaus.plexus.util.StringUtils;

final class PluginCacheManager
implements PluginDefinitionHandler {
    private static final Log LOGGER = LogFactory.getLog((Class)PluginCacheManager.class);
    private static final Log sessionLog = LogFactory.getLog((Class)MavenSession.class);
    public static final String LOCK_CACHE = "lock.cache";
    public static final String VALID_CACHE = "valid.cache";
    public static final String ARTIFACT_ID_CACHE = "artifactIdToPlugin.cache";
    public static final String PLUGINS_CACHE = "plugins.cache";
    public static final String GOALS_CACHE = "goals.cache";
    public static final String CALLBACKS_CACHE = "callbacks.cache";
    public static final String DYNAMIC_TAGLIBS_CACHE = "dynatag.cache";
    public static final String PLUGIN_DYNATAG_DEPS_CACHE = "plugin-dynatag-deps.cache";
    private boolean dirty = true;
    private Properties artifactIdCache = new Properties();
    private Properties goalCache = new Properties();
    private Properties pluginCache = new Properties();
    private Properties dynaTagLibCache = new Properties();
    private Properties callbackCache = new Properties();
    private Properties pluginDynaTagDepsCache = new Properties();

    void checkLockFile(File lockFile) {
        for (int i = 1; i <= 10 && lockFile.exists(); ++i) {
            LOGGER.info((Object)("Lock file " + lockFile + " exists, waiting... " + i + " of 10"));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (lockFile.exists()) {
            LOGGER.warn((Object)"Lock file still exists: ignoring");
            lockFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCache(File directory) throws IOException {
        if (!this.dirty) {
            return;
        }
        directory.mkdirs();
        File lockFile = new File(directory, LOCK_CACHE);
        this.checkLockFile(lockFile);
        LOGGER.debug((Object)("Locking " + lockFile));
        if (!lockFile.getParentFile().exists()) {
            lockFile.getParentFile().mkdirs();
        }
        lockFile.createNewFile();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Saving caches to " + directory.getAbsolutePath()));
            }
            File f = new File(directory, VALID_CACHE);
            f.delete();
            this.storeProperties(this.pluginCache, new File(directory, PLUGINS_CACHE), "plugins cache");
            this.storeProperties(this.goalCache, new File(directory, GOALS_CACHE), "goals cache");
            this.storeProperties(this.callbackCache, new File(directory, CALLBACKS_CACHE), "callbacks cache");
            this.storeProperties(this.dynaTagLibCache, new File(directory, DYNAMIC_TAGLIBS_CACHE), "taglibs cache");
            this.storeProperties(this.pluginDynaTagDepsCache, new File(directory, PLUGIN_DYNATAG_DEPS_CACHE), "plugin deps cache");
            this.storeProperties(this.artifactIdCache, new File(directory, ARTIFACT_ID_CACHE), "artifact ID to plugin mapping");
            f.createNewFile();
            this.dirty = false;
        }
        finally {
            LOGGER.debug((Object)("Unlocking " + lockFile));
            lockFile.delete();
        }
    }

    private void storeProperties(Properties properties, File file, String header) throws FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(file);
        properties.store(stream, header);
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            properties.load(stream);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    void loadCache(File directory) {
        File lockFile = new File(directory, LOCK_CACHE);
        this.checkLockFile(lockFile);
        File f = new File(directory, VALID_CACHE);
        if (!f.exists()) {
            LOGGER.info((Object)"Plugin cache will be regenerated");
            return;
        }
        LOGGER.debug((Object)"Loading plugin cache");
        try {
            this.pluginCache = this.loadProperties(new File(directory, PLUGINS_CACHE));
            this.goalCache = this.loadProperties(new File(directory, GOALS_CACHE));
            this.callbackCache = this.loadProperties(new File(directory, CALLBACKS_CACHE));
            this.dynaTagLibCache = this.loadProperties(new File(directory, DYNAMIC_TAGLIBS_CACHE));
            this.pluginDynaTagDepsCache = this.loadProperties(new File(directory, PLUGIN_DYNATAG_DEPS_CACHE));
            this.artifactIdCache = this.loadProperties(new File(directory, ARTIFACT_ID_CACHE));
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Clearing cache due to exception loading part of cache");
            LOGGER.debug((Object)"Exception", (Throwable)e);
            this.clearCache();
        }
        this.dirty = false;
    }

    private void appendCsvProperty(Properties properties, String key, String newEntry) {
        String csvProperty = properties.getProperty(key);
        if (csvProperty == null) {
            properties.setProperty(key, newEntry);
        } else {
            StringTokenizer st = new StringTokenizer(csvProperty, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(newEntry)) continue;
                return;
            }
            properties.setProperty(key, csvProperty + ',' + newEntry);
        }
    }

    public void addPluginDynaTagDep(JellyScriptHousing housing, String uri) {
        this.appendCsvProperty(this.pluginDynaTagDepsCache, housing.getName(), uri);
        this.dirty = true;
    }

    public void removePluginDynaTagDep(JellyScriptHousing housing, String uri) {
        String prop = (String)this.pluginDynaTagDepsCache.get(housing.getName());
        int tl = uri.length();
        if (prop.indexOf(",") < 0) {
            this.pluginDynaTagDepsCache.remove(housing.getName());
        } else {
            int i = prop.indexOf(uri + ",");
            prop = i == 0 ? prop.substring(tl + 1) : (i > 0 ? prop.substring(0, i) + prop.substring(i + tl + 1) : prop.substring(0, prop.length() - tl - 1));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Caching Taglib Dependency --> " + prop));
            }
            this.pluginDynaTagDepsCache.put(housing.getName(), prop);
        }
        this.dirty = true;
    }

    void registerPlugin(String name, JellyScriptHousing housing) throws MavenException {
        this.artifactIdCache.put(name, housing.getProject().getArtifactId());
    }

    public void addPostGoal(String name, JellyScriptHousing housing) {
        this.appendCsvProperty(this.callbackCache, name + ".post", housing.getName());
        this.dirty = true;
    }

    public void addPreGoal(String name, JellyScriptHousing housing) {
        this.appendCsvProperty(this.callbackCache, name + ".pre", housing.getName());
        this.dirty = true;
    }

    public void addGoal(String name, String prereqs, String description, JellyScriptHousing housing) {
        String goalProperty = description + ">";
        if (prereqs != null) {
            goalProperty = goalProperty + StringUtils.deleteWhitespace((String)prereqs);
        }
        this.goalCache.setProperty(name, goalProperty);
        this.pluginCache.setProperty(name, housing.getName());
        this.dirty = true;
    }

    public void addDynaTagLib(String tagLibUri, JellyScriptHousing housing) {
        this.dynaTagLibCache.setProperty(tagLibUri, housing.getName());
        this.dirty = true;
    }

    void invalidateCache(String pluginName) {
        LOGGER.debug((Object)("Invalidating plugin " + pluginName));
        Iterator<Object> i = this.dynaTagLibCache.keySet().iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            if (!this.dynaTagLibCache.getProperty(uri).equals(pluginName)) continue;
            sessionLog.debug((Object)("removing dynataglib cache entry for uri " + uri));
            i.remove();
        }
        i = this.callbackCache.keySet().iterator();
        while (i.hasNext()) {
            String callbackName = (String)i.next();
            String goalName = callbackName.endsWith(".pre") ? callbackName.substring(0, callbackName.length() - 4) : callbackName.substring(0, callbackName.length() - 5);
            String callbackPlugin = this.pluginCache.getProperty(goalName);
            String callbacks = this.callbackCache.getProperty(callbackName);
            if (pluginName.equals(callbackPlugin)) {
                sessionLog.debug((Object)("removing callback cache entry for goal " + callbackName + " (goal in source plugin)"));
                i.remove();
                continue;
            }
            if (pluginName.equals(callbacks)) {
                sessionLog.debug((Object)("removing callback cache entry for goal " + callbackName + " (lone callback removed)"));
                i.remove();
                continue;
            }
            StringTokenizer tok = new StringTokenizer(callbacks, ",");
            StringBuffer newCallback = new StringBuffer();
            boolean changed = false;
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                if (name.equals(pluginName)) {
                    changed = true;
                    continue;
                }
                if (newCallback.length() > 0) {
                    newCallback.append(",");
                }
                newCallback.append(name);
            }
            if (!changed) continue;
            callbacks = newCallback.toString();
            sessionLog.debug((Object)("removing callback cache value for goal " + callbackName + " (other callbacks remain: " + callbacks + ")"));
            this.callbackCache.setProperty(callbackName, callbacks);
        }
        i = this.goalCache.keySet().iterator();
        while (i.hasNext()) {
            String eachGoal = (String)i.next();
            if (!this.pluginCache.getProperty(eachGoal).equals(pluginName)) continue;
            sessionLog.debug((Object)("removing goal and plugin cache entry for goal " + eachGoal));
            i.remove();
            this.pluginCache.remove(eachGoal);
        }
        if (this.pluginDynaTagDepsCache.containsKey(pluginName)) {
            sessionLog.debug((Object)"removing dynatag dependency cache entry");
            this.pluginDynaTagDepsCache.remove(pluginName);
        }
        if (this.artifactIdCache.containsKey(pluginName)) {
            sessionLog.debug((Object)"removing artifactId cache entry");
            this.artifactIdCache.remove(pluginName);
        }
        this.dirty = true;
    }

    private JellyScriptHousing loadHousing(String pluginName, PluginManager manager, Map pluginDirs, String desc) throws IOException {
        File dir = (File)pluginDirs.get(pluginName);
        if (dir == null) {
            sessionLog.warn((Object)("plugin " + pluginName + " is cached (" + desc + ") but no longer present"));
            return null;
        }
        JellyScriptHousing housing = manager.loadPluginHousing(pluginName, dir);
        if (housing == null) {
            sessionLog.error((Object)("plugin " + pluginName + " is cached (" + desc + ") but no longer valid"));
            return null;
        }
        return housing;
    }

    private void clearCache() {
        this.pluginCache.clear();
        this.callbackCache.clear();
        this.goalCache.clear();
        this.dynaTagLibCache.clear();
        this.pluginDynaTagDepsCache.clear();
        this.artifactIdCache.clear();
    }

    boolean mapPlugins(GoalToJellyScriptHousingMapper mapper, PluginManager manager, Map pluginDirs) throws IOException {
        String pluginName;
        JellyScriptHousing housing;
        Iterator j;
        String goalName;
        JellyScriptHousing housing2;
        String uri;
        JellyScriptHousing housing3;
        String pluginName2;
        Iterator<Object> i = this.pluginDynaTagDepsCache.keySet().iterator();
        while (i.hasNext()) {
            pluginName2 = (String)i.next();
            housing3 = this.loadHousing(pluginName2, manager, pluginDirs, "dynatag dep");
            if (housing3 != null) continue;
            this.clearCache();
            return false;
        }
        i = this.pluginCache.keySet().iterator();
        while (i.hasNext()) {
            String goalName2 = (String)i.next();
            String pluginName3 = this.pluginCache.getProperty(goalName2);
            JellyScriptHousing housing4 = this.loadHousing(pluginName3, manager, pluginDirs, "goal");
            if (housing4 != null) continue;
            this.clearCache();
            return false;
        }
        i = this.artifactIdCache.keySet().iterator();
        while (i.hasNext()) {
            pluginName2 = (String)i.next();
            housing3 = this.loadHousing(pluginName2, manager, pluginDirs, "artifactId");
            if (housing3 != null) continue;
            this.clearCache();
            return false;
        }
        HashMap preGoals = new HashMap();
        HashMap postGoals = new HashMap();
        Iterator<Object> i2 = this.callbackCache.keySet().iterator();
        while (i2.hasNext()) {
            String callbackName = (String)i2.next();
            boolean isPreGoal = callbackName.endsWith(".pre");
            String goalName3 = isPreGoal ? callbackName.substring(0, callbackName.length() - 4) : callbackName.substring(0, callbackName.length() - 5);
            String pluginNames = this.callbackCache.getProperty(callbackName);
            StringTokenizer tok = new StringTokenizer(pluginNames, ",");
            ArrayList<JellyScriptHousing> housings = new ArrayList<JellyScriptHousing>();
            if (isPreGoal) {
                preGoals.put(goalName3, housings);
            } else {
                postGoals.put(goalName3, housings);
            }
            while (tok.hasMoreTokens()) {
                String pluginName4 = tok.nextToken();
                JellyScriptHousing housing5 = this.loadHousing(pluginName4, manager, pluginDirs, "callbacks");
                if (housing5 != null) {
                    housings.add(housing5);
                    continue;
                }
                this.clearCache();
                return false;
            }
        }
        i2 = this.dynaTagLibCache.keySet().iterator();
        while (i2.hasNext()) {
            uri = (String)i2.next();
            String pluginName5 = this.dynaTagLibCache.getProperty(uri);
            housing2 = this.loadHousing(pluginName5, manager, pluginDirs, "dynataglib");
            if (housing2 != null) continue;
            this.clearCache();
            return false;
        }
        i2 = preGoals.keySet().iterator();
        while (i2.hasNext()) {
            goalName = (String)i2.next();
            List housings = (List)preGoals.get(goalName);
            j = housings.iterator();
            while (j.hasNext()) {
                housing = (JellyScriptHousing)j.next();
                mapper.addPreGoal(goalName, housing);
            }
        }
        i2 = postGoals.keySet().iterator();
        while (i2.hasNext()) {
            goalName = (String)i2.next();
            List housings = (List)postGoals.get(goalName);
            j = housings.iterator();
            while (j.hasNext()) {
                housing = (JellyScriptHousing)j.next();
                mapper.addPostGoal(goalName, housing);
            }
        }
        i2 = this.pluginDynaTagDepsCache.keySet().iterator();
        while (i2.hasNext()) {
            pluginName = (String)i2.next();
            JellyScriptHousing housing6 = manager.loadPluginHousing(pluginName, (File)pluginDirs.get(pluginName));
            String csv = this.pluginDynaTagDepsCache.getProperty(pluginName);
            StringTokenizer tok = new StringTokenizer(csv, ",");
            while (tok.hasMoreTokens()) {
                String uri2 = tok.nextToken();
                mapper.addPluginDynaTagDep(housing6, uri2);
            }
        }
        i2 = this.pluginCache.keySet().iterator();
        while (i2.hasNext()) {
            goalName = (String)i2.next();
            String pluginName6 = this.pluginCache.getProperty(goalName);
            housing2 = manager.loadPluginHousing(pluginName6, (File)pluginDirs.get(pluginName6));
            String goal = this.goalCache.getProperty(goalName);
            int index = goal.indexOf(">");
            String description = null;
            if (index > 0) {
                description = goal.substring(0, index);
            }
            String prereqs = goal.substring(index + 1);
            mapper.addGoal(goalName, prereqs, description, housing2);
        }
        i2 = this.dynaTagLibCache.keySet().iterator();
        while (i2.hasNext()) {
            uri = (String)i2.next();
            String pluginName7 = this.dynaTagLibCache.getProperty(uri);
            housing2 = manager.loadPluginHousing(pluginName7, (File)pluginDirs.get(pluginName7));
            mapper.addDynaTagLib(uri, housing2);
        }
        i2 = this.artifactIdCache.keySet().iterator();
        while (i2.hasNext()) {
            pluginName = (String)i2.next();
            JellyScriptHousing housing7 = manager.loadPluginHousing(pluginName, (File)pluginDirs.get(pluginName));
            manager.mapArtifactIdToPluginHousing(this.artifactIdCache.getProperty(pluginName), housing7);
        }
        return true;
    }

    public void setDefaultGoalName(String defaultGoalName) {
    }

    Properties getPluginCache() {
        return this.pluginCache;
    }

    public Properties getGoalCache() {
        return this.goalCache;
    }

    Properties getCallbackCache() {
        return this.callbackCache;
    }

    Properties getDynaTagLibCache() {
        return this.dynaTagLibCache;
    }

    Properties getPluginDynaTagDepsCache() {
        return this.pluginDynaTagDepsCache;
    }
}

