/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.jelly.Script;
import org.apache.maven.MavenException;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.apache.maven.plugin.PluginScriptParser;
import org.apache.maven.project.Project;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JellyScriptHousing {
    private static final String PLUGIN_PROPERTIES_NAME = "plugin.properties";
    private Map pluginProperties = new HashMap();
    private Project project;
    private Script script;
    private File source;
    private final String name;
    private final File pluginDirectory;
    private final MavenJellyContext parentContext;

    public JellyScriptHousing() {
        this.name = null;
        this.pluginDirectory = null;
        this.parentContext = null;
    }

    public JellyScriptHousing(File pluginDir, MavenJellyContext parentContext) throws IOException {
        this.pluginDirectory = pluginDir;
        this.name = pluginDir.getName();
        this.source = new File(pluginDir, "plugin.jelly");
        this.parentContext = parentContext;
        this.pluginProperties = this.loadPluginProperties();
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public Project getProject() throws MavenException {
        if (this.project == null) {
            this.project = MavenUtils.getProject(new File(this.pluginDirectory, "project.xml"), this.parentContext, false);
        }
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    Script getScript() {
        return this.script;
    }

    public String toString() {
        return "\n source = " + this.getSource() + "\n project = " + this.project + "\n script = " + this.script;
    }

    public String getName() {
        return this.name;
    }

    void parse(PluginDefinitionHandler handler, String systemId, InputStream inStream) throws MavenException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            InputSource is = new InputSource(inStream);
            is.setSystemId(systemId);
            parser.parse(is, (DefaultHandler)new PluginScriptParser(handler, this));
        }
        catch (ParserConfigurationException e) {
            throw new MavenException(systemId + " : Error parsing plugin script", e);
        }
        catch (SAXException e) {
            throw new MavenException(systemId + " : Error parsing plugin script", e);
        }
        catch (IOException e) {
            throw new MavenException(systemId + " : Error reading plugin script", e);
        }
    }

    void parse(PluginDefinitionHandler handler) throws MavenException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.source);
            this.parse(handler, this.source.getAbsolutePath(), fis);
        }
        catch (FileNotFoundException e) {
            throw new MavenException(this.source + " : Error reading plugin script", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
                fis = null;
            }
        }
    }

    public Map getPluginProperties() {
        return this.pluginProperties;
    }

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadPluginProperties() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        File propsFile = new File(this.pluginDirectory, PLUGIN_PROPERTIES_NAME);
        if (propsFile.exists()) {
            Properties props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(propsFile);
                props.load(in);
                map.putAll(props);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                    in = null;
                }
            }
        }
        return map;
    }
}

