/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.apache.maven.util.InsertionOrderedSet;
import org.apache.maven.werkz.CyclicGoalChainException;
import org.apache.maven.werkz.Goal;
import org.apache.maven.werkz.NoSuchGoalException;
import org.apache.maven.werkz.WerkzProject;
import org.codehaus.plexus.util.StringUtils;

public class GoalToJellyScriptHousingMapper
implements PluginDefinitionHandler {
    private static final Log LOGGER = LogFactory.getLog((Class)GoalToJellyScriptHousingMapper.class);
    private HashMap dynaTagPluginMap = new HashMap();
    private HashMap pluginDynaTagDepsMap = new HashMap();
    private HashMap goalPluginMap = new HashMap();
    private HashMap preGoalDecoratorsMap = new HashMap();
    private HashMap postGoalDecoratorsMap = new HashMap();
    private final WerkzProject goalProject = new WerkzProject();
    private String defaultGoalName;
    private final HashSet resolvedPlugins = new HashSet();

    void merge(GoalToJellyScriptHousingMapper mapper) throws CyclicGoalChainException {
        Set sExist;
        Set s;
        String goalName;
        GoalToJellyScriptHousingMapper.mergeMap(this.dynaTagPluginMap, mapper.dynaTagPluginMap);
        GoalToJellyScriptHousingMapper.mergeMap(this.pluginDynaTagDepsMap, mapper.pluginDynaTagDepsMap);
        GoalToJellyScriptHousingMapper.mergeMap(this.goalPluginMap, mapper.goalPluginMap);
        Iterator<Object> i = mapper.preGoalDecoratorsMap.keySet().iterator();
        while (i.hasNext()) {
            goalName = (String)i.next();
            s = (Set)mapper.preGoalDecoratorsMap.get(goalName);
            sExist = (Set)this.preGoalDecoratorsMap.get(goalName);
            if (sExist == null) {
                this.preGoalDecoratorsMap.put(goalName, s);
                continue;
            }
            sExist.addAll(s);
        }
        i = mapper.postGoalDecoratorsMap.keySet().iterator();
        while (i.hasNext()) {
            goalName = (String)i.next();
            s = (Set)mapper.postGoalDecoratorsMap.get(goalName);
            sExist = (Set)this.postGoalDecoratorsMap.get(goalName);
            if (sExist == null) {
                this.postGoalDecoratorsMap.put(goalName, s);
                continue;
            }
            sExist.addAll(s);
        }
        if (this.defaultGoalName == null) {
            this.defaultGoalName = mapper.defaultGoalName;
        }
        i = mapper.goalProject.getGoals().iterator();
        while (i.hasNext()) {
            Goal goal = (Goal)i.next();
            Goal existingGoal = this.goalProject.getGoal(goal.getName());
            if (existingGoal == null) {
                this.goalProject.addGoal(goal);
                continue;
            }
            Iterator j = goal.getPrecursors().iterator();
            while (j.hasNext()) {
                existingGoal.addPrecursor((Goal)j.next());
            }
            j = goal.getPostcursors().iterator();
            while (j.hasNext()) {
                existingGoal.addPostcursor((Goal)j.next());
            }
        }
        this.resolvedPlugins.addAll(mapper.resolvedPlugins);
    }

    private static void mergeMap(Map target, Map source) {
        HashMap map = new HashMap(target);
        target.putAll(source);
        target.putAll(map);
    }

    public String getDefaultGoalName() {
        return this.defaultGoalName;
    }

    public void setDefaultGoalName(String defaultGoalName) {
        if (this.defaultGoalName == null) {
            this.defaultGoalName = defaultGoalName;
        }
    }

    public JellyScriptHousing getPluginHousing(String goal) {
        return (JellyScriptHousing)this.goalPluginMap.get(goal);
    }

    private HashSet getPluginDynaTagDeps(Object pluginHousing) {
        HashSet pluginDynaTagDeps = (HashSet)this.pluginDynaTagDepsMap.get(pluginHousing);
        if (pluginDynaTagDeps == null) {
            pluginDynaTagDeps = new HashSet();
            this.pluginDynaTagDepsMap.put(pluginHousing, pluginDynaTagDeps);
        }
        return pluginDynaTagDeps;
    }

    HashSet getPostGoalDecorators(String goalName) {
        HashSet decorators = (HashSet)this.postGoalDecoratorsMap.get(goalName);
        if (decorators == null) {
            decorators = new HashSet();
            this.postGoalDecoratorsMap.put(goalName, decorators);
        }
        return decorators;
    }

    HashSet getPreGoalDecorators(String goalName) {
        HashSet decorators = (HashSet)this.preGoalDecoratorsMap.get(goalName);
        if (decorators == null) {
            decorators = new HashSet();
            this.preGoalDecoratorsMap.put(goalName, decorators);
        }
        return decorators;
    }

    Set resolveJellyScriptHousings(String goal) throws NoSuchGoalException {
        LOGGER.debug((Object)("preparing goal: " + goal));
        InsertionOrderedSet pluginSet = new InsertionOrderedSet();
        Goal[] chain = this.getExecutionChain(goal, this.goalProject);
        LOGGER.debug((Object)("execution chain: " + Arrays.asList(chain).toString()));
        for (int i = 0; i < chain.length; ++i) {
            Goal g = chain[i];
            Object plugin = this.goalPluginMap.get(g.getName());
            if (plugin == null) {
                throw new NoSuchGoalException(g.getName());
            }
            pluginSet.add(plugin);
            HashSet decorators = this.getPostGoalDecorators(g.getName());
            if (LOGGER.isDebugEnabled() && !decorators.isEmpty()) {
                LOGGER.debug((Object)("goal " + g.getName() + " has postGoal decorators " + decorators));
            }
            pluginSet.addAll(decorators);
            decorators = this.getPreGoalDecorators(g.getName());
            if (LOGGER.isDebugEnabled() && !decorators.isEmpty()) {
                LOGGER.debug((Object)("goal " + g.getName() + " has preGoal decorators " + decorators));
            }
            pluginSet.addAll(decorators);
        }
        InsertionOrderedSet newPluginSet = this.resolveDynaTagPlugins(pluginSet);
        if (LOGGER.isDebugEnabled() && !newPluginSet.isEmpty()) {
            LOGGER.debug((Object)("dynatag dependencies: " + newPluginSet));
        }
        newPluginSet.addAll((Collection)pluginSet);
        pluginSet = newPluginSet;
        pluginSet.removeAll(this.resolvedPlugins);
        this.resolvedPlugins.addAll(pluginSet);
        LOGGER.debug((Object)("final list of plugins to prepare: " + pluginSet));
        return pluginSet;
    }

    public Goal[] getExecutionChain(String name, WerkzProject project) throws NoSuchGoalException {
        Goal goal = project.getGoal(name);
        LinkedList<Goal> chain = new LinkedList<Goal>();
        LinkedList<Goal> stack = new LinkedList<Goal>();
        stack.addLast(goal);
        while (!stack.isEmpty()) {
            goal = (Goal)stack.removeFirst();
            if (goal == null || chain.contains(goal)) continue;
            chain.addFirst(goal);
            List precursors = goal.getPrecursors();
            Iterator i = precursors.iterator();
            while (i.hasNext()) {
                Goal eachPrecursor = (Goal)i.next();
                if (chain.contains(eachPrecursor)) continue;
                stack.addLast(eachPrecursor);
            }
        }
        return chain.toArray(Goal.EMPTY_ARRAY);
    }

    private InsertionOrderedSet resolveDynaTagPlugins(Set plugins) {
        InsertionOrderedSet resolvedDynaTagPlugins = new InsertionOrderedSet();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            JellyScriptHousing plugin = (JellyScriptHousing)i.next();
            HashSet dynaTagDeps = this.getPluginDynaTagDeps(plugin);
            Iterator j = dynaTagDeps.iterator();
            while (j.hasNext()) {
                LinkedList dynaTagUris = new LinkedList();
                HashSet<String> seen = new HashSet<String>();
                Object next = j.next();
                dynaTagUris.add(next);
                while (!dynaTagUris.isEmpty()) {
                    String dynaTagUri = (String)dynaTagUris.removeFirst();
                    if (seen.contains(dynaTagUri)) continue;
                    seen.add(dynaTagUri);
                    Object dynaTagPluginHome = this.dynaTagPluginMap.get(dynaTagUri);
                    if (dynaTagPluginHome == null) {
                        LOGGER.warn((Object)("Tag library requested that is not present: '" + dynaTagUri + "' in plugin: '" + plugin.getName() + "'"));
                        continue;
                    }
                    HashSet set = this.getPluginDynaTagDeps(dynaTagPluginHome);
                    dynaTagUris.addAll(set);
                    resolvedDynaTagPlugins.add(dynaTagPluginHome);
                }
            }
        }
        return resolvedDynaTagPlugins;
    }

    public void addPluginDynaTagDep(JellyScriptHousing housing, String uri) {
        this.getPluginDynaTagDeps(housing).add(uri);
    }

    public void removePluginDynaTagDep(JellyScriptHousing housing, String uri) {
        this.getPluginDynaTagDeps(housing).remove(uri);
    }

    public void addDynaTagLib(String tagLibUri, JellyScriptHousing jellyScriptHousing) {
        this.dynaTagPluginMap.put(tagLibUri, jellyScriptHousing);
    }

    public void addPostGoal(String name, JellyScriptHousing jellyScriptHousing) {
        this.getPostGoalDecorators(name).add(jellyScriptHousing);
    }

    public void addPreGoal(String name, JellyScriptHousing jellyScriptHousing) {
        this.getPreGoalDecorators(name).add(jellyScriptHousing);
    }

    public void addGoal(String name, String prereqs, String description, JellyScriptHousing jellyScriptHousing) {
        if (!this.goalPluginMap.containsKey(name)) {
            Goal goal = this.goalProject.getGoal(name, true);
            goal.setDescription(description);
            this.goalProject.addGoal(goal);
            this.goalPluginMap.put(name, jellyScriptHousing);
            if (prereqs != null) {
                String[] s = StringUtils.split((String)prereqs, (String)",");
                for (int i = 0; i < s.length; ++i) {
                    try {
                        Goal prereq = this.goalProject.getGoal(s[i].trim(), true);
                        goal.addPrecursor(prereq);
                        continue;
                    }
                    catch (CyclicGoalChainException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    Set getGoalNames() {
        return this.goalPluginMap.keySet();
    }

    String getGoalDescription(String goalName) {
        String goalDescription;
        Goal goal = this.goalProject.getGoal(goalName);
        String string = goalDescription = goal != null ? goal.getDescription() : null;
        if (goalDescription != null) {
            if ("null".equals(goalDescription = goalDescription.trim())) {
                goalDescription = null;
            } else if (goalDescription.length() == 0) {
                goalDescription = null;
            }
        }
        return goalDescription;
    }

    void addResolvedPlugins(List projectHousings) {
        this.resolvedPlugins.addAll(projectHousings);
    }

    void clearResolvedPlugins() {
        this.resolvedPlugins.clear();
    }

    void invalidatePlugin(JellyScriptHousing housing) {
        Set decorators;
        this.resolvedPlugins.remove(housing);
        Iterator i = this.dynaTagPluginMap.keySet().iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            if (!this.dynaTagPluginMap.get(uri).equals(housing)) continue;
            i.remove();
        }
        this.pluginDynaTagDepsMap.remove(housing);
        i = this.goalPluginMap.keySet().iterator();
        while (i.hasNext()) {
            String goal = (String)i.next();
            if (!this.goalPluginMap.get(goal).equals(housing)) continue;
            i.remove();
            this.goalProject.removeGoal(goal);
        }
        i = this.preGoalDecoratorsMap.keySet().iterator();
        while (i.hasNext()) {
            String preGoal = (String)i.next();
            decorators = (Set)this.preGoalDecoratorsMap.get(preGoal);
            decorators.remove(housing);
        }
        i = this.postGoalDecoratorsMap.keySet().iterator();
        while (i.hasNext()) {
            String postGoal = (String)i.next();
            decorators = (Set)this.postGoalDecoratorsMap.get(postGoal);
            decorators.remove(housing);
        }
    }
}

