/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.jelly.tags.BaseTagSupport;
import org.apache.maven.plugin.UnknownPluginException;
import org.apache.maven.project.Project;

public class SetTag
extends BaseTagSupport {
    private static final Log LOGGER = LogFactory.getLog((Class)SetTag.class);
    private Object value;
    private String plugin;
    private String property;

    public void doTag(XMLOutput output) throws JellyTagException {
        this.checkAttribute(this.value, "value");
        this.checkAttribute(this.plugin, "plugin");
        this.checkAttribute(this.property, "property");
        Project project = this.getMavenContext().getProject();
        try {
            MavenJellyContext context = project.getPluginContext(this.plugin);
            if (context != null) {
                context.setVariable(this.property, this.value);
            } else {
                LOGGER.error((Object)("context for plugin '" + this.plugin + "' in project '" + project + "' is null"));
            }
        }
        catch (UnknownPluginException e) {
            LOGGER.error((Object)("Plugin '" + this.plugin + "' in project '" + project + "' is not available"));
        }
        catch (Exception e) {
            throw new JellyTagException("Error loading plugin", (Throwable)e);
        }
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public void setPlugin(String pluginId) {
        this.plugin = pluginId;
    }

    public void setProperty(String propertyName) {
        this.property = propertyName;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

