/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.tags.BaseTagSupport;
import org.apache.maven.project.Project;

public class MavenTag
extends BaseTagSupport {
    private File descriptor;
    private String goals;
    private boolean ignoreFailures;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.getDescriptor(), "descriptor");
        Project project = null;
        try {
            project = MavenUtils.getProject(this.getDescriptor(), this.getMavenContext().getMavenSession().getRootContext());
            project.verifyDependencies();
            this.getMavenContext().getMavenSession().getPluginManager().processDependencies(project);
            ArrayList goalList = new ArrayList();
            if (this.getGoals() != null) {
                goalList.addAll(MavenUtils.getGoalListFromCsv(this.getGoals()));
            }
            this.getMavenContext().getMavenSession().attainGoals(project, goalList);
        }
        catch (Exception e) {
            if (this.isIgnoreFailures()) {
                this.getMavenContext().setVariable("maven.build.failure", "true");
                if (project != null) {
                    ArrayList<Project> c = (ArrayList<Project>)this.getContext().getVariable("failedProjects");
                    if (c == null) {
                        c = new ArrayList<Project>();
                    }
                    c.add(project);
                    this.getContext().setVariable("failedProjects", c);
                }
                return;
            }
            throw new JellyTagException((Throwable)e);
        }
    }

    public void setDescriptor(File descriptor) {
        this.descriptor = descriptor;
    }

    public File getDescriptor() {
        return this.descriptor;
    }

    public void setBasedir(File basedir) {
        System.out.println("\nDEPRECATION WARNING: you no longer need to specify the basedir attribute.\n");
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public String getGoals() {
        return this.goals;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }
}

