/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenSession;
import org.apache.maven.jelly.tags.jeez.MavenJeezTagLibrary;
import org.apache.maven.werkz.WerkzProject;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.util.StringUtils;

public class MavenJellyContext
extends JellyContext {
    private static final Log LOGGER = LogFactory.getLog((Class)MavenJellyContext.class);

    public MavenJellyContext() {
        this.initializeContext();
    }

    public MavenJellyContext(URL rootContext) {
        super(rootContext);
        this.initializeContext();
    }

    public MavenJellyContext(MavenJellyContext parent) {
        super((JellyContext)parent);
        this.initializeContext();
    }

    protected JellyContext createChildContext() {
        return new MavenJellyContext(this);
    }

    private void initializeContext() {
        MavenJeezTagLibrary jeezTagLib = new MavenJeezTagLibrary();
        this.registerTagLibrary("jelly:mavenant", (TagLibrary)jeezTagLib);
        this.registerTagLibrary("", (TagLibrary)jeezTagLib);
        if (!this.isTagLibraryRegistered("jelly:maven")) {
            this.registerTagLibrary("jelly:maven", "org.apache.maven.jelly.tags.maven.MavenTagLibrary");
        }
    }

    public void registerTagLibrary(String uri, TagLibrary taglib) {
        if (!this.isTagLibraryRegistered(uri)) {
            super.registerTagLibrary(uri, taglib);
        }
    }

    public void registerTagLibrary(String namespaceURI, String className) {
        if (!this.isTagLibraryRegistered(namespaceURI)) {
            super.registerTagLibrary(namespaceURI, className);
        }
    }

    public TagLibrary getTagLibrary(String uri) {
        return super.getTagLibrary(uri);
    }

    public Object getVariable(String name) {
        Object value = this.isInherit() ? super.findVariable(name) : super.getVariable(name);
        if (value instanceof Expression) {
            Expression expression = (Expression)value;
            value = expression.evaluate((JellyContext)this);
        }
        return value;
    }

    public Boolean getBoolean(String key) {
        Object value = this.getVariable(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String stringValue = (String)value;
        if ("true".equalsIgnoreCase(stringValue) || "on".equalsIgnoreCase(stringValue) || "1".equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.setVariable("maven.session", mavenSession);
    }

    public MavenSession getMavenSession() {
        return (MavenSession)this.getVariable("maven.session");
    }

    public void setMavenRepoRemotes(List mavenRepoRemote) {
        this.setVariable("maven.repo.remote", this.convertListToCsvString(mavenRepoRemote));
    }

    public List getMavenRepoRemote() {
        return this.convertCsvStringToList((String)this.getVariable("maven.repo.remote"));
    }

    private List convertCsvStringToList(String csvString) {
        ArrayList<String> list = new ArrayList<String>();
        String[] s = StringUtils.split((String)csvString, (String)",");
        for (int i = 0; i < s.length; ++i) {
            list.add(s[i]);
        }
        return list;
    }

    private String convertListToCsvString(List list) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(list.get(i));
        }
        return buf.toString();
    }

    public void setMavenRepoLocal(String mavenRepoLocal) {
        this.setVariable("maven.repo.local", mavenRepoLocal);
    }

    public String getMavenRepoLocal() {
        return (String)this.getVariable("maven.repo.local");
    }

    public void setXMLOutput(XMLOutput xmlOutput) {
        this.setVariable("maven.xmlOutput", xmlOutput);
    }

    public XMLOutput getXMLOutput() {
        return (XMLOutput)this.getVariable("maven.xmlOutput");
    }

    public void setOnline(Boolean online) {
        this.setVariable("maven.mode.online", online);
    }

    public Boolean getOnline() {
        return this.getBoolean("maven.mode.online");
    }

    public void setProject(org.apache.maven.project.Project project) {
        this.setVariable("pom", project);
    }

    public org.apache.maven.project.Project getProject() {
        return (org.apache.maven.project.Project)this.getVariable("pom");
    }

    public void setProxyHost(String proxyHost) {
        this.setVariable("maven.proxy.host", proxyHost);
    }

    public String getProxyHost() {
        return (String)this.getVariable("maven.proxy.host");
    }

    public void setProxyPort(String proxyPort) {
        this.setVariable("maven.proxy.port", proxyPort);
    }

    public String getProxyPort() {
        return (String)this.getVariable("maven.proxy.port");
    }

    public void setProxyUserName(String proxyUserName) {
        this.setVariable("maven.proxy.username", proxyUserName);
    }

    public String getProxyUserName() {
        return (String)this.getVariable("maven.proxy.username");
    }

    public void setProxyPassword(String proxyPassword) {
        this.setVariable("maven.proxy.password", proxyPassword);
    }

    public String getProxyPassword() {
        return (String)this.getVariable("maven.proxy.password");
    }

    public void setDebugOn(Boolean debug) {
        this.setVariable("maven.debugOn", debug);
    }

    public Boolean getDebugOn() {
        Boolean b = (Boolean)this.getVariable("maven.debugOn");
        if (b == null) {
            return Boolean.FALSE;
        }
        return b;
    }

    public void setEmacsModeOn(Boolean emacsModeOn) {
        this.setVariable("maven.emacsModeOn", emacsModeOn);
    }

    public Boolean getEmacsModeOn() {
        Boolean b = (Boolean)this.getVariable("maven.emacsModeOn");
        if (b == null) {
            return Boolean.FALSE;
        }
        return b;
    }

    public void setRemoteRepositoryEnabled(Boolean remoteRepositoryEnabled) {
        this.setVariable("maven.repo.remote.enabled", remoteRepositoryEnabled);
    }

    public Boolean getRemoteRepositoryEnabled() {
        return this.getBoolean("maven.repo.remote.enabled");
    }

    public void setMavenJarOverride(Boolean mavenJarOverride) {
        this.setVariable("maven.jar.override", mavenJarOverride);
    }

    public Boolean getMavenJarOverride() {
        return this.getBoolean("maven.jar.override");
    }

    public String getMavenJarOverride(String id) {
        return (String)this.getVariable("maven.jar." + id);
    }

    public String getMavenHome() {
        return (String)this.getVariable("maven.home");
    }

    public void setWerkzProject(WerkzProject werkzProject) {
        this.setVariable("org.apache.commons.jelly.werkz.Project", werkzProject);
    }

    public WerkzProject getWerkzProject() {
        return (WerkzProject)this.getVariable("org.apache.commons.jelly.werkz.Project");
    }

    public void setAntProject(Project antProject) {
        this.setVariable("maven.ant.project", antProject);
    }

    public Project getAntProject() {
        return (Project)this.getVariable("maven.ant.project");
    }

    public void display() {
        Iterator i = this.getVariableNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith("maven")) continue;
            LOGGER.info((Object)(key + ": " + this.getVariable(key)));
        }
    }

    public String getMavenHomeLocal() {
        return (String)this.getVariable("maven.home.local");
    }

    public String getPluginsDir() {
        return (String)this.getVariable("maven.plugin.dir");
    }

    public String getUserPluginsDir() {
        return (String)this.getVariable("maven.plugin.user.dir");
    }

    public String getUnpackedPluginsDir() {
        return (String)this.getVariable("maven.plugin.unpacked.dir");
    }

    public void setParent(JellyContext context) {
        super.setParent(context);
    }

    public void resolveRelativePaths(File basedir) {
        this.resolveRelativePath(basedir, "maven.repo.local");
        this.resolveRelativePath(basedir, "maven.plugin.user.dir");
        this.resolveRelativePath(basedir, "maven.plugin.unpacked.dir");
        this.resolveRelativePath(basedir, "maven.plugin.dir");
        this.resolveRelativePath(basedir, "maven.home.local");
        this.resolveRelativePath(basedir, "maven.home");
    }

    private void resolveRelativePath(File basedir, String var) {
        String value = (String)this.getVariable(var);
        File f = new File(value);
        if (f.getParentFile() != null && !f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!(f.isAbsolute() || value.startsWith("/") || value.startsWith("\\"))) {
            f = new File(basedir, f.getPath());
            LOGGER.debug((Object)("Resolving " + var + " to " + f));
            this.setVariable(var, f.getAbsolutePath());
        }
    }
}

