/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.apache.commons.jelly.expression.jexl.JexlExpression;
import org.apache.maven.jelly.JellyUtils;

public class MavenExpressionFactory
implements ExpressionFactory {
    private boolean supportAntVariables = true;

    public Expression createExpression(String text) throws JellyException {
        JexlExpression expression = null;
        try {
            expression = new JexlExpression(org.apache.commons.jexl.ExpressionFactory.createExpression((String)text));
        }
        catch (Exception anException) {
            throw new JellyException("error evaluating expression", (Throwable)anException);
        }
        JexlExpression jexlExpression = expression;
        if (this.isSupportAntVariables() && this.isValidAntVariableName(text)) {
            ExpressionSupport expr = new ExpressionSupport((Expression)jexlExpression, text){
                private final /* synthetic */ Expression val$jexlExpression;
                private final /* synthetic */ String val$text;
                {
                    this.val$jexlExpression = expression;
                    this.val$text = string;
                }

                public Object evaluate(JellyContext context) {
                    Object answer = this.val$jexlExpression.evaluate(context);
                    if (answer == null && (answer = context.getVariable(this.val$text)) instanceof String) {
                        return JellyUtils.decomposeExpression((String)answer, context);
                    }
                    return answer;
                }

                public String getExpressionText() {
                    return this.val$text;
                }

                public String toString() {
                    return super.toString() + "[expression:" + this.val$text + "]";
                }
            };
            return expr;
        }
        return jexlExpression;
    }

    public boolean isSupportAntVariables() {
        return this.supportAntVariables;
    }

    public void setSupportAntVariables(boolean supportAntVariables) {
        this.supportAntVariables = supportAntVariables;
    }

    protected boolean isValidAntVariableName(String text) {
        char[] chars = text.toCharArray();
        int size = chars.length;
        for (int i = 0; i < size; ++i) {
            char ch = chars[i];
            if (!Character.isWhitespace(ch) && ch != '[') continue;
            return false;
        }
        return true;
    }
}

