/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.MavenExpressionFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JellyUtils {
    private static final Log LOGGER = LogFactory.getLog((Class)JellyUtils.class);
    private static MavenExpressionFactory mavenExpressionFactory = new MavenExpressionFactory();

    public static void runScript(InputStream scriptInputStream, URL rootUrl, JellyContext context, XMLOutput output) throws Exception {
        JellyUtils.runScript(scriptInputStream, null, rootUrl, context, output);
    }

    public static void runScript(InputStream scriptInputStream, String systemId, URL rootUrl, JellyContext context, XMLOutput output) throws Exception {
        URL oldRoot = context.getRootURL();
        URL oldCurrent = context.getCurrentURL();
        if (rootUrl != null) {
            context.setRootURL(rootUrl);
            context.setCurrentURL(rootUrl);
        }
        Script script = JellyUtils.compileScript(scriptInputStream, systemId, context);
        script.run(context, output);
        context.setRootURL(oldRoot);
        context.setCurrentURL(oldCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(File scriptFile, URL rootUrl, JellyContext context, XMLOutput output) throws Exception {
        if (!scriptFile.canRead() || scriptFile.length() < 1L) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(scriptFile);
            JellyUtils.runScript(fis, scriptFile.toURL().toString(), rootUrl, context, output);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                }
                fis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script compileScript(File scriptFile, JellyContext context) throws Exception {
        FileInputStream fis = null;
        Script result = null;
        try {
            fis = new FileInputStream(scriptFile);
            result = JellyUtils.compileScript(fis, scriptFile.toURL().toString(), context);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                }
                fis = null;
            }
        }
        return result;
    }

    public static Script compileScript(InputStream scriptInputStream, JellyContext context) throws Exception {
        return JellyUtils.compileScript(scriptInputStream, null, context, null);
    }

    public static Script compileScript(InputStream scriptInputStream, String systemId, JellyContext context) throws Exception {
        return JellyUtils.compileScript(scriptInputStream, systemId, context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script compileScript(InputStream scriptInputStream, String systemId, JellyContext context, String encoding) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        XMLParser parser = new XMLParser(reader);
        parser.setContext(context);
        parser.setClassLoader(context.getClassLoader());
        Script script = null;
        InputSource source = null;
        if (encoding != null) {
            InputStreamReader isr = null;
            try {
                isr = new InputStreamReader(scriptInputStream, encoding);
                source = new InputSource(isr);
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                    }
                    isr = null;
                }
            }
        }
        source = new InputSource(scriptInputStream);
        if (systemId != null) {
            source.setSystemId(systemId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("the system identifier to help resolve relative URLs : " + systemId));
        }
        script = parser.parse(source);
        script = script.compile();
        return script;
    }

    public static Expression decomposeExpression(String text, JellyContext context) {
        Expression expression = null;
        try {
            expression = CompositeExpression.parse((String)text, (ExpressionFactory)mavenExpressionFactory);
            String expressionText = expression.evaluateAsString(context);
            if (CompositeExpression.parse((String)expressionText, (ExpressionFactory)mavenExpressionFactory) instanceof CompositeExpression) {
                expression = JellyUtils.decomposeExpression(expressionText, context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expression;
    }

    public static void compareContexts(MavenJellyContext ctx1, MavenJellyContext ctx2) {
        System.out.println("======== compare contexts ========");
        Iterator i = ctx1.getVariableNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (ctx2.getVariable(name) == null) {
                System.out.println(name + " not in ctx2");
                continue;
            }
            if (ctx2.getVariable(name).equals(ctx1.getVariable(name))) continue;
            System.out.println(name + " doesn't match: '" + ctx1.getVariable(name) + "' vs '" + ctx2.getVariable(name) + "'");
        }
        System.out.println("======== comparison  done ========");
    }

    public static void populateVariables(JellyContext destContext, JellyContext sourceContext) {
        if (sourceContext != null) {
            if (!"false".equals(sourceContext.getVariable("maven.property.inheritance")) && !"false".equals(destContext.getVariable("maven.property.inheritance"))) {
                JellyUtils.populateVariables(destContext, sourceContext.isInherit() ? sourceContext.getParent() : null);
            }
            destContext.getVariables().putAll(sourceContext.getVariables());
        }
        destContext.setVariable("context", (Object)destContext);
    }
}

