/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import com.werken.forehead.ForeheadClassLoader;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenException;
import org.apache.maven.jelly.JellyUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.project.Project;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.plexus.util.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.SAXException;

public class MavenUtils {
    private static final Log LOGGER = LogFactory.getLog((Class)MavenUtils.class);
    private static HashMap parentPoms = new HashMap();
    public static final String MAVEN_UNKNOWN_ERROR = "Unknown error reading project";
    private static ResourceBundle messages;

    public static Project getProject(File projectDescriptor) throws MavenException {
        return MavenUtils.getProject(projectDescriptor, null);
    }

    public static Project getProject(File projectDescriptor, MavenJellyContext parentContext) throws MavenException {
        return MavenUtils.getProject(projectDescriptor, parentContext, true);
    }

    public static Project getProject(File projectDescriptor, MavenJellyContext parentContext, boolean useParentPom) throws MavenException {
        Project project = null;
        try {
            project = MavenUtils.getNonJellyProject(projectDescriptor, parentContext, useParentPom);
            project = MavenUtils.getJellyProject(project);
            project.setFile(projectDescriptor);
            project.initialize();
        }
        catch (IntrospectionException e) {
            throw new MavenException("Error creating a string from the project", e);
        }
        catch (IOException e) {
            throw new MavenException("Error reading XML or initializing", e);
        }
        catch (ParserConfigurationException e) {
            throw new MavenException("Error creating a JAXP Parser", e);
        }
        catch (SAXException e) {
            throw new MavenException("Error parsing XML", e);
        }
        catch (MavenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MavenException(MAVEN_UNKNOWN_ERROR, e);
        }
        return project;
    }

    public static Project getNonJellyProject(File projectDescriptor, MavenJellyContext parentContext, boolean useParentPom) throws MavenException, IOException {
        Project project = null;
        try {
            project = new Project(projectDescriptor.toURL());
        }
        catch (Exception e) {
            throw new MavenException("Error parsing project.xml '" + projectDescriptor.getAbsolutePath() + "'", e);
        }
        MavenJellyContext context = MavenUtils.createContextNoDefaults(projectDescriptor.getParentFile(), parentContext);
        String pomToExtend = project.getExtend();
        if (pomToExtend != null && useParentPom) {
            Expression e = JellyUtils.decomposeExpression(pomToExtend, context);
            pomToExtend = e.evaluateAsString((JellyContext)context);
            pomToExtend = MavenUtils.makeAbsolutePath(projectDescriptor.getParentFile(), pomToExtend);
            project.setExtend(pomToExtend);
            File parentPom = new File(pomToExtend);
            parentPom = parentPom.getCanonicalFile();
            if (!parentPom.exists()) {
                throw new FileNotFoundException("Parent POM not found: " + parentPom);
            }
            String parentPomPath = parentPom.getPath();
            if (parentPomPath.equals(projectDescriptor.getCanonicalPath())) {
                throw new MavenException("Parent POM is equal to the current POM");
            }
            Project parent = (Project)parentPoms.get(parentPomPath);
            if (parent == null) {
                parent = MavenUtils.getNonJellyProject(parentPom, parentContext, true);
                parent.setFile(parentPom);
                parentPoms.put(parentPom.getCanonicalPath(), parent);
                context.setParent(parent.getContext());
            }
            MavenUtils.integrateMapInContext(parent.getContext().getVariables(), context);
            project.mergeParent(parent);
        }
        project.resolveIds();
        MavenUtils.applyDefaults(context);
        project.setContext(context);
        context.setProject(project);
        return project;
    }

    public static List getProjects(File directory, String includes, String excludes) throws MavenException {
        return MavenUtils.getProjects(directory, includes, excludes, null);
    }

    public static List getProjects(File directory, String includes, String excludes, MavenJellyContext context) throws MavenException {
        String[] files = MavenUtils.getFiles(directory, includes, excludes);
        ArrayList<Project> projects = new ArrayList<Project>();
        for (int i = 0; i < files.length; ++i) {
            Project p = MavenUtils.getProject(new File(files[i]), context);
            projects.add(p);
        }
        return projects;
    }

    public static Project getJellyProject(Project project) throws Exception {
        MavenJellyContext originalContext = project.getContext();
        JellyContext context = new JellyContext();
        JellyUtils.populateVariables(context, originalContext);
        project.setContext(null);
        Project parent = project.getParent();
        project.setParent(null);
        project = MavenUtils.getInterpolatedPOM(project, context);
        project.setParent(parent);
        project.setContext(originalContext);
        project.getContext().setProject(project);
        return project;
    }

    private static Project getInterpolatedPOM(Project project, JellyContext context) throws Exception {
        String projectString = project.getProjectAsString();
        Expression e = JellyUtils.decomposeExpression(projectString, context);
        String newProjectString = e.evaluateAsString(context);
        project = new Project(new StringReader(newProjectString));
        return project;
    }

    public static String[] getFiles(File directory, String includes) {
        return MavenUtils.getFiles(directory, includes, null);
    }

    public static String[] getFiles(File directory, String includes, String excludes) {
        String[] includePatterns = null;
        if (includes != null) {
            includePatterns = StringUtils.split((String)includes, (String)",");
        }
        String[] excludePatterns = null;
        if (excludes != null) {
            excludePatterns = StringUtils.split((String)excludes, (String)",");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setIncludes(includePatterns);
        directoryScanner.setExcludes(excludePatterns);
        directoryScanner.scan();
        String[] files = directoryScanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(directory, files[i]).getAbsolutePath();
        }
        return files;
    }

    public static Map mergeMaps(Map dominantMap, Map recessiveMap) {
        HashMap result = new HashMap();
        if (dominantMap == null && recessiveMap == null) {
            return null;
        }
        if (dominantMap != null && recessiveMap == null) {
            return dominantMap;
        }
        if (dominantMap == null) {
            return recessiveMap;
        }
        Set dominantMapKeys = dominantMap.keySet();
        Set recessiveMapKeys = recessiveMap.keySet();
        Collection contributingRecessiveKeys = CollectionUtils.subtract(recessiveMapKeys, (Collection)CollectionUtils.intersection(dominantMapKeys, recessiveMapKeys));
        result.putAll(dominantMap);
        Iterator i = contributingRecessiveKeys.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            result.put(key, recessiveMap.get(key));
        }
        return result;
    }

    public static Map mergeMaps(Map[] maps) {
        Map result;
        if (maps.length == 0) {
            result = null;
        } else if (maps.length == 1) {
            result = maps[0];
        } else {
            result = MavenUtils.mergeMaps(maps[0], maps[1]);
            for (int i = 2; i < maps.length; ++i) {
                result = MavenUtils.mergeMaps(result, maps[i]);
            }
        }
        return result;
    }

    private static Properties loadProjectBuildProperties(File directory) {
        File projectBuildPropertiesFile = new File(directory, "build.properties");
        LOGGER.debug((Object)("Using projectBuildPropertiesFile: " + projectBuildPropertiesFile.getAbsolutePath()));
        return MavenUtils.loadProperties(projectBuildPropertiesFile);
    }

    private static Properties loadProjectProperties(File directory) {
        File projectPropertiesFile = new File(directory, "project.properties");
        LOGGER.debug((Object)("Using projectPropertiesFile: " + projectPropertiesFile.getAbsolutePath()));
        return MavenUtils.loadProperties(projectPropertiesFile);
    }

    public static MavenJellyContext createContext(File descriptorDirectory) {
        return MavenUtils.createContext(descriptorDirectory, null);
    }

    public static MavenJellyContext createContext(File descriptorDirectory, MavenJellyContext parentContext) {
        MavenJellyContext context = MavenUtils.createContextNoDefaults(descriptorDirectory, parentContext);
        MavenUtils.applyDefaults(context);
        return context;
    }

    private static MavenJellyContext createContextNoDefaults(File descriptorDirectory, MavenJellyContext parentContext) {
        Properties systemProperties = System.getProperties();
        File userBuildPropertiesFile = new File(System.getProperty("user.home"), "build.properties");
        LOGGER.debug((Object)("Using userBuildPropertiesFile: " + userBuildPropertiesFile.getAbsolutePath()));
        Properties userBuildProperties = MavenUtils.loadProperties(userBuildPropertiesFile);
        Properties projectProperties = MavenUtils.loadProjectProperties(descriptorDirectory);
        Properties projectBuildProperties = MavenUtils.loadProjectBuildProperties(descriptorDirectory);
        Properties driverProperties = MavenUtils.loadProperties(MavenUtils.class.getResourceAsStream("/driver.properties"));
        Map result = MavenUtils.mergeMaps(new Map[]{systemProperties, userBuildProperties, projectBuildProperties, projectProperties, driverProperties});
        MavenJellyContext context = parentContext != null ? new MavenJellyContext(parentContext) : new MavenJellyContext();
        context.setInherit(false);
        MavenUtils.integrateMapInContext(result, context);
        context.setInherit(true);
        context.setVariable("basedir", descriptorDirectory.getAbsolutePath());
        return context;
    }

    private static void applyDefaults(MavenJellyContext context) {
        Properties defaultProperties = MavenUtils.loadProperties(MavenUtils.class.getResourceAsStream("/defaults.properties"));
        MavenUtils.integrateMapInContext(defaultProperties, context);
        context.resolveRelativePaths(new File(System.getProperty("user.dir")));
    }

    public static void integrateMapInContext(Map map, MavenJellyContext context) {
        if (map == null) {
            return;
        }
        JexlExpressionFactory factory = new JexlExpressionFactory();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (context.getVariables().get(key) != null) continue;
            Object value = map.get(key);
            if (value instanceof String) {
                try {
                    String literalValue = (String)value;
                    Expression expr = CompositeExpression.parse((String)literalValue, (ExpressionFactory)factory);
                    value = expr != null ? expr : literalValue;
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Unexpected error evaluating expression", (Throwable)e);
                }
            }
            context.setVariable(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) {
        FileInputStream fis = null;
        try {
            if (file.exists()) {
                fis = new FileInputStream(file);
                Properties properties = MavenUtils.loadProperties(fis);
                return properties;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Unexpected error loading properties", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                }
                fis = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(InputStream is) {
        try {
            Properties properties = new Properties();
            properties.load(is);
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                String property = (String)i.next();
                properties.setProperty(property, properties.getProperty(property).trim());
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Unexpected exception loading properties", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Unexpected exception loading properties", (Throwable)e);
            }
        }
        return null;
    }

    private static void loadMessages() {
        try {
            messages = ResourceBundle.getBundle("org/apache/maven/messages/messages");
        }
        catch (MissingResourceException e) {
            messages = ResourceBundle.getBundle("org/apache/maven/messages/messages", Locale.ENGLISH);
        }
    }

    public static String getMessage(String messageId) {
        return MavenUtils.getMessage(messageId, null);
    }

    public static String getMessage(String messageId, Object variable) {
        if (messages == null) {
            try {
                MavenUtils.loadMessages();
            }
            catch (MissingResourceException mre) {
                LOGGER.error((Object)mre);
                return messageId + (variable == null ? "" : " " + variable);
            }
        }
        if (variable == null) {
            return messages.getString(messageId);
        }
        return StringUtils.replace((String)messages.getString(messageId), (String)"${1}", (String)variable.toString());
    }

    public static String makeAbsolutePath(File basedir, String dir) throws IOException {
        File f = new File(dir);
        if (f.isAbsolute()) {
            return f.getCanonicalPath();
        }
        return new File(basedir, dir).getCanonicalPath();
    }

    public static String makeRelativePath(File basedir, String path) throws IOException {
        String canonicalBasedir = basedir.getCanonicalPath();
        File pathFile = new File(path);
        if (!pathFile.isAbsolute()) {
            LOGGER.warn((Object)"WARNING: path is not an absolute pathname! Returning path.");
            return path;
        }
        String canonicalPath = pathFile.getCanonicalPath();
        if (canonicalPath.equals(canonicalBasedir)) {
            return ".";
        }
        if (canonicalPath.startsWith(canonicalBasedir)) {
            canonicalPath = canonicalPath.charAt(canonicalBasedir.length()) == File.separatorChar ? canonicalPath.substring(canonicalBasedir.length() + 1) : canonicalPath.substring(canonicalBasedir.length());
        } else {
            LOGGER.warn((Object)"WARNING: path does not start with basedir! Returning path.");
            return path;
        }
        return canonicalPath;
    }

    public static List getGoalListFromCsv(String goalCsv) {
        StringTokenizer tok = new StringTokenizer(goalCsv, ",");
        ArrayList<String> goals = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            goals.add(tok.nextToken().trim());
        }
        return goals;
    }

    public static void displayClassLoaderContents(ForeheadClassLoader classLoader) {
        LOGGER.info((Object)("ClassLoader name: " + classLoader.getName()));
        URL[] urls = classLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            LOGGER.info((Object)("urls[" + i + "] = " + urls[i]));
        }
        ClassLoader parent = classLoader.getParent();
        if (parent != null && parent instanceof ForeheadClassLoader) {
            LOGGER.info((Object)"Displaying Parent classloader: ");
            MavenUtils.displayClassLoaderContents((ForeheadClassLoader)classLoader.getParent());
        }
    }
}

