/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.xdoc.util;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.provider.clearcase.ClearCaseScmProvider;
import org.apache.maven.scm.provider.clearcase.repository.ClearCaseScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.CvsScmProvider;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.provider.starteam.StarteamScmProvider;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnScmProvider;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.util.EnhancedStringTokenizer;

public final class ScmUtil {
    public String getScmType(String scmConnection) {
        if (this.isValid(scmConnection)) {
            return this.splitSCMConnection(scmConnection)[1];
        }
        return null;
    }

    public String getCvsConnection(String conn, String username) {
        String[] tokens = this.splitSCMConnection(conn);
        if (!tokens[1].equals("cvs")) {
            return "";
        }
        String separator = this.getSCMConnectionSeparator(conn);
        if (tokens[3].indexOf(64) >= 0) {
            if (username.length() == 0) {
                username = tokens[3].substring(0, tokens[3].indexOf(64)) + separator;
            }
            tokens[3] = username + "@" + tokens[3].substring(tokens[3].indexOf(64) + 1);
        }
        String result = tokens[0] + ":" + tokens[1] + separator + tokens[2] + separator + tokens[3] + separator + tokens[4] + separator + tokens[5];
        return result;
    }

    public String getCvsModule(String conn) {
        if (this.isValid(conn)) {
            String[] tokens = this.splitSCMConnection(conn);
            if (!tokens[1].equals("cvs")) {
                return "";
            }
            return tokens[5];
        }
        return null;
    }

    public String getSvnConnection(String conn) {
        if (conn != null && conn.length() > 8 && "svn".equals(conn.substring(4, 7))) {
            return conn.substring(8);
        }
        System.err.println("Your subversion connection does not seem to be valid: " + conn);
        return "";
    }

    public String anonymousAccessCVS(String connection) {
        CvsScmProviderRepository cvsRepo;
        char delim = this.getSCMConnectionSeparator(connection).charAt(0);
        CvsScmProvider cvsProvider = new CvsScmProvider();
        String scmSpecificUrl = connection.substring(8);
        try {
            cvsRepo = (CvsScmProviderRepository)cvsProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        StringBuffer command = new StringBuffer();
        command.append("cvs -d ").append(cvsRepo.getCvsRoot()).append(" login");
        command.append("\n");
        command.append("cvs -z3 -d ").append(cvsRepo.getCvsRoot());
        command.append(" co ").append(cvsRepo.getModule());
        return command.toString();
    }

    public String developerAccessCVS(String devConnection) {
        CvsScmProviderRepository cvsRepo;
        char delim = this.getSCMConnectionSeparator(devConnection).charAt(0);
        CvsScmProvider cvsProvider = new CvsScmProvider();
        String scmSpecificUrl = devConnection.substring(8);
        try {
            cvsRepo = (CvsScmProviderRepository)cvsProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        String cvsRoot = StringUtils.replace((String)cvsRepo.getCvsRoot(), (String)cvsRepo.getUser(), (String)"username");
        StringBuffer command = new StringBuffer();
        command.append("export CVS_RSH=ssh");
        command.append("\n");
        command.append("cvs -z3 -d ").append(cvsRoot).append(" co ").append(cvsRepo.getModule());
        return command.toString();
    }

    public String anonymousAccessSVN(String connection, String checkoutDirectoryName) {
        SvnScmProviderRepository svnRepo;
        char delim = this.getSCMConnectionSeparator(connection).charAt(0);
        SvnScmProvider svnProvider = new SvnScmProvider();
        String scmSpecificUrl = connection.substring(8);
        try {
            svnRepo = (SvnScmProviderRepository)svnProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        StringBuffer command = new StringBuffer();
        command.append("svn checkout ").append(svnRepo.getUrl()).append(" ").append(checkoutDirectoryName);
        return command.toString();
    }

    public String developerAccessSVN(String devConnection, String checkoutDirectoryName) {
        SvnScmProviderRepository svnRepo;
        char delim = this.getSCMConnectionSeparator(devConnection).charAt(0);
        SvnScmProvider svnProvider = new SvnScmProvider();
        String scmSpecificUrl = devConnection.substring(8);
        try {
            svnRepo = (SvnScmProviderRepository)svnProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        StringBuffer command = new StringBuffer();
        command.append("svn checkout ").append(svnRepo.getUrl()).append(" ").append(checkoutDirectoryName);
        return command.toString();
    }

    public String developerAccessPerforce(String devConnection) {
        PerforceScmProviderRepository perforceRepo;
        StringBuffer command = new StringBuffer();
        char delim = this.getSCMConnectionSeparator(devConnection).charAt(0);
        PerforceScmProvider perforceProvider = new PerforceScmProvider();
        String scmSpecificUrl = devConnection.substring(13);
        try {
            perforceRepo = (PerforceScmProviderRepository)perforceProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        command.append("p4");
        if (!StringUtils.isEmpty((String)perforceRepo.getHost())) {
            command.append(" -H ").append(perforceRepo.getHost());
        }
        if (perforceRepo.getPort() > 0) {
            command.append(" -p " + perforceRepo.getPort());
        }
        command.append(" -u username");
        command.append(" -P password");
        command.append(" ");
        command.append(perforceRepo.getPath());
        command.append("\n");
        command.append("p4 submit -c \"A comment\"");
        return command.toString();
    }

    public String developerAccessStarteam(String devConnection) {
        StarteamScmProviderRepository starteamRepo;
        StringBuffer command = new StringBuffer();
        char delim = this.getSCMConnectionSeparator(devConnection).charAt(0);
        StarteamScmProvider starteamProvider = new StarteamScmProvider();
        String scmSpecificUrl = devConnection.substring(13);
        try {
            starteamRepo = (StarteamScmProviderRepository)starteamProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        String fullUrl = StringUtils.replace((String)starteamRepo.getFullUrl(), (String)starteamRepo.getUser(), (String)"username");
        fullUrl = StringUtils.replace((String)fullUrl, (String)starteamRepo.getPassword(), (String)"password");
        command.append("stcmd co -x -nologo -stop -p ");
        command.append(fullUrl);
        command.append(" -is");
        command.append("\n");
        command.append("stcmd ci -x -nologo -stop -p ");
        command.append(fullUrl);
        command.append(" -f NCI -is");
        return command.toString();
    }

    public String developerAccessClearCase(String devConnection) {
        ClearCaseScmProviderRepository clearCaseRepo;
        StringBuffer command = new StringBuffer();
        char delim = this.getSCMConnectionSeparator(devConnection).charAt(0);
        ClearCaseScmProvider clearCaseProvider = new ClearCaseScmProvider();
        String scmSpecificUrl = devConnection.substring(14);
        try {
            clearCaseRepo = (ClearCaseScmProviderRepository)clearCaseProvider.makeProviderScmRepository(scmSpecificUrl, delim);
        }
        catch (ScmRepositoryException e) {
            System.err.println("Your developerConnection does not seem to be valid: " + e.getMessage());
            return "";
        }
        command.append("cleartool checkout ").append(clearCaseRepo.getViewName("id"));
        return command.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] splitSCMConnection(String connection) {
        if (connection == null) {
            throw new NullPointerException("repository connection is null");
        }
        if (connection.length() < 5) {
            throw new IllegalArgumentException("repository connection is too short");
        }
        if (!connection.startsWith("scm:")) {
            throw new IllegalArgumentException("repository connection must start with scm:");
        }
        String delimiter = this.getSCMConnectionSeparator(connection);
        String modifiedConnection = "scm" + delimiter + connection.substring(4);
        EnhancedStringTokenizer tok = new EnhancedStringTokenizer(modifiedConnection, delimiter);
        String[] tokens = this.tokenizerToArray(tok);
        if (tokens.length < 1) return tokens;
        if (!tokens[1].equals("cvs")) return tokens;
        if (tokens.length >= 2 && tokens[2].equals("local")) {
            if (tokens.length == 6) {
                if (tokens[3].length() <= 0) return tokens;
                if (tokens[3].equals("local")) return tokens;
                throw new IllegalArgumentException("cvs local repository connection string must specify 5 tokens, or an empty 3rd token if 6");
            }
            if (tokens.length != 5) throw new IllegalArgumentException("cvs local repository connection string doesn't contain five tokens");
            String[] newTokens = new String[]{tokens[0], tokens[1], tokens[2], "", tokens[3], tokens[4]};
            return newTokens;
        }
        if (tokens.length == 7 && tokens[2].equals("pserver") && tokens[4].startsWith("@")) {
            String[] newTokens = new String[]{tokens[0], tokens[1], tokens[2], tokens[3] + tokens[4], tokens[5], tokens[6]};
            return newTokens;
        }
        if (tokens.length == 6) return tokens;
        throw new IllegalArgumentException("cvs repository connection string doesn't contain six tokens");
    }

    public String getSCMConnectionSeparator(String connection) {
        if (connection == null) {
            throw new NullPointerException("repository connection is null");
        }
        if (connection.indexOf("|") != -1) {
            return "|";
        }
        return ":";
    }

    public String[] tokenizerToArray(EnhancedStringTokenizer tok) {
        ArrayList<String> l = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            l.add(tok.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    protected boolean isValid(String value) {
        return value != null && !value.trim().equals("");
    }
}

