/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.xdoc;

import com.werken.forehead.ForeheadClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class GrabClassLoaderTag
extends TagSupport {
    private String resource;

    public void doTag(XMLOutput arg0) throws MissingAttributeException, JellyTagException {
        if (this.getContext() == null) {
            throw new JellyTagException("The current MavenContext is null!");
        }
        ForeheadClassLoader currentClassLoader = null;
        try {
            currentClassLoader = (ForeheadClassLoader)this.getContext().getClassLoader();
        }
        catch (ClassCastException e) {
            throw new JellyTagException("The current classloader in the MavenContext is not an instance of ForeheadClassLoader");
        }
        if (currentClassLoader == null) {
            throw new JellyTagException("No classloader found in the current MavenContext");
        }
        try {
            File f = new File(this.resource);
            currentClassLoader.addURL(f.toURL());
        }
        catch (MalformedURLException e) {
            throw new JellyTagException("The directory to include specified by " + this.getResource() + " is malformed");
        }
        ForeheadClassLoader newClassLoader = new ForeheadClassLoader((ClassLoader)currentClassLoader, currentClassLoader.getName() + "_TEMP");
        this.getContext().setClassLoader((ClassLoader)newClassLoader);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String includeDir) {
        this.resource = includeDir;
    }
}

