/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scm.release;

import org.apache.maven.plugins.scm.release.AbstractPomTransformer;
import org.dom4j.Element;
import org.dom4j.Node;

public class VersionTransformer
extends AbstractPomTransformer {
    private String version;
    private String tag;

    public VersionTransformer(String version, String tag) {
        this.version = version;
        this.tag = tag;
    }

    public String selectNodesXPathExpression() {
        return "/project";
    }

    public void transformNode(Node node) throws Exception {
        Element project = (Element)node;
        Node currentVersion = node.selectSingleNode("currentVersion");
        if (currentVersion != null) {
            currentVersion.setText(this.version);
        } else {
            project.addElement("currentVersion").addText(this.version);
        }
        Element version = (Element)node.selectSingleNode("versions/version[tag='" + this.tag + "']");
        if (version != null) {
            Node id = version.selectSingleNode("id");
            if (id != null) {
                id.setText(this.version);
            } else {
                version.addElement("id").addText(this.version);
            }
            Node name = version.selectSingleNode("name");
            if (name != null) {
                name.setText(this.version);
            } else {
                version.addElement("name").addText(this.version);
            }
        } else {
            Element versions = (Element)project.selectSingleNode("versions");
            if (versions == null) {
                versions = project.addElement("versions");
            }
            Element v = versions.addElement("version");
            v.addElement("id").addText(this.version);
            v.addElement("name").addText(this.version);
            v.addElement("tag").addText(this.tag);
        }
    }

    public Node getTransformedNode(Node node) throws Exception {
        throw new UnsupportedOperationException("getTransformedNode not implemented");
    }

    public boolean transformRequired() {
        Node node = (Node)this.getSelectedNodes().get(0);
        if (node == null) {
            return true;
        }
        Node currentVersion = node.selectSingleNode("currentVersion");
        if (currentVersion == null || !currentVersion.getText().equals(this.version)) {
            return true;
        }
        Node v = node.selectSingleNode("versions/version[tag='" + this.tag + "' and id='" + this.version + "' and name='" + this.version + "']");
        return v == null;
    }
}

