/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class FindOneAndDeleteOptions {
    private Bson projection;
    private Bson sort;
    private long maxTimeMS;
    private Collation collation;

    public Bson getProjection() {
        return this.projection;
    }

    public FindOneAndDeleteOptions projection(Bson projection) {
        this.projection = projection;
        return this;
    }

    public Bson getSort() {
        return this.sort;
    }

    public FindOneAndDeleteOptions sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    public FindOneAndDeleteOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOneAndDeleteOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }
}

