/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.InputStream;
import java.sql.SQLException;
import org.postgresql.core.ParameterList;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.V3ParameterList;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

class CompositeParameterList
implements V3ParameterList {
    private final int total;
    private final SimpleParameterList[] subparams;
    private final int[] offsets;

    CompositeParameterList(SimpleParameterList[] subparams, int[] offsets) {
        this.subparams = subparams;
        this.offsets = offsets;
        this.total = offsets[offsets.length - 1] + subparams[offsets.length - 1].getInParameterCount();
    }

    private final int findSubParam(int index) throws SQLException {
        if (index < 1 || index > this.total) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{index, this.total}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i2 = this.offsets.length - 1; i2 >= 0; --i2) {
            if (this.offsets[i2] >= index) continue;
            return i2;
        }
        throw new IllegalArgumentException("I am confused; can't find a subparam for index " + index);
    }

    public void registerOutParameter(int index, int sqlType) {
    }

    public int getDirection(int i2) {
        return 0;
    }

    public int getParameterCount() {
        return this.total;
    }

    public int getInParameterCount() {
        return this.total;
    }

    public int getOutParameterCount() {
        return 0;
    }

    public int[] getTypeOIDs() {
        int[] oids = new int[this.total];
        for (int i2 = 0; i2 < this.offsets.length; ++i2) {
            int[] subOids = this.subparams[i2].getTypeOIDs();
            System.arraycopy(subOids, 0, oids, this.offsets[i2], subOids.length);
        }
        return oids;
    }

    public void setIntParameter(int index, int value) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setIntParameter(index - this.offsets[sub], value);
    }

    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setStringParameter(index - this.offsets[sub], value, oid);
    }

    public void setStringParameter(int index, String value, int oid) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setStringParameter(index - this.offsets[sub], value, oid);
    }

    public void setBinaryParameter(int index, byte[] value, int oid) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setBinaryParameter(index - this.offsets[sub], value, oid);
    }

    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setBytea(index - this.offsets[sub], data, offset, length);
    }

    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setBytea(index - this.offsets[sub], stream, length);
    }

    public void setBytea(int index, InputStream stream) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setBytea(index - this.offsets[sub], stream);
    }

    public void setNull(int index, int oid) throws SQLException {
        int sub = this.findSubParam(index);
        this.subparams[sub].setNull(index - this.offsets[sub], oid);
    }

    public String toString(int index) {
        try {
            int sub = this.findSubParam(index);
            return this.subparams[sub].toString(index - this.offsets[sub]);
        }
        catch (SQLException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public ParameterList copy() {
        SimpleParameterList[] copySub = new SimpleParameterList[this.subparams.length];
        for (int sub = 0; sub < this.subparams.length; ++sub) {
            copySub[sub] = (SimpleParameterList)this.subparams[sub].copy();
        }
        return new CompositeParameterList(copySub, this.offsets);
    }

    public void clear() {
        for (SimpleParameterList subparam : this.subparams) {
            subparam.clear();
        }
    }

    public SimpleParameterList[] getSubparams() {
        return this.subparams;
    }

    public void checkAllParametersSet() throws SQLException {
        for (SimpleParameterList subparam : this.subparams) {
            subparam.checkAllParametersSet();
        }
    }

    public void convertFunctionOutParameters() {
        for (SimpleParameterList subparam : this.subparams) {
            subparam.convertFunctionOutParameters();
        }
    }
}

