/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;

public class PGbytea {
    private static final int MAX_3_BUFF_SIZE = 0x200000;

    public static byte[] toBytes(byte[] s2) throws SQLException {
        if (s2 == null) {
            return null;
        }
        if (s2.length < 2 || s2[0] != 92 || s2[1] != 120) {
            return PGbytea.toBytesOctalEscaped(s2);
        }
        return PGbytea.toBytesHexEscaped(s2);
    }

    private static byte[] toBytesHexEscaped(byte[] s2) {
        byte[] output = new byte[(s2.length - 2) / 2];
        for (int i2 = 0; i2 < output.length; ++i2) {
            byte b1 = PGbytea.gethex(s2[2 + i2 * 2]);
            byte b2 = PGbytea.gethex(s2[2 + i2 * 2 + 1]);
            output[i2] = (byte)(b1 << 4 | b2);
        }
        return output;
    }

    private static byte gethex(byte b2) {
        if (b2 <= 57) {
            return (byte)(b2 - 48);
        }
        if (b2 >= 97) {
            return (byte)(b2 - 97 + 10);
        }
        return (byte)(b2 - 65 + 10);
    }

    private static byte[] toBytesOctalEscaped(byte[] s2) {
        int slength = s2.length;
        byte[] buf = null;
        int correctSize = slength;
        if (slength > 0x200000) {
            for (int i2 = 0; i2 < slength; ++i2) {
                byte next;
                byte current = s2[i2];
                if (current != 92) continue;
                if ((next = s2[++i2]) == 92) {
                    --correctSize;
                    continue;
                }
                correctSize -= 3;
            }
            buf = new byte[correctSize];
        } else {
            buf = new byte[slength];
        }
        int bufpos = 0;
        for (int i3 = 0; i3 < slength; ++i3) {
            byte nextbyte = s2[i3];
            if (nextbyte == 92) {
                int thebyte;
                byte secondbyte;
                if ((secondbyte = s2[++i3]) == 92) {
                    buf[bufpos++] = 92;
                    continue;
                }
                if ((thebyte = (secondbyte - 48) * 64 + (s2[++i3] - 48) * 8 + (s2[++i3] - 48)) > 127) {
                    thebyte -= 256;
                }
                buf[bufpos++] = (byte)thebyte;
                continue;
            }
            buf[bufpos++] = nextbyte;
        }
        if (bufpos == correctSize) {
            return buf;
        }
        byte[] l_return = new byte[bufpos];
        System.arraycopy(buf, 0, l_return, 0, bufpos);
        return l_return;
    }

    public static String toPGString(byte[] p_buf) throws SQLException {
        if (p_buf == null) {
            return null;
        }
        StringBuilder l_strbuf = new StringBuilder(2 * p_buf.length);
        for (int n2 : p_buf) {
            int l_int = n2;
            if (l_int < 0) {
                l_int = 256 + l_int;
            }
            if (l_int < 32 || l_int > 126) {
                l_strbuf.append("\\");
                l_strbuf.append((char)((l_int >> 6 & 3) + 48));
                l_strbuf.append((char)((l_int >> 3 & 7) + 48));
                l_strbuf.append((char)((l_int & 7) + 48));
                continue;
            }
            if (n2 == 92) {
                l_strbuf.append("\\\\");
                continue;
            }
            l_strbuf.append((char)n2);
        }
        return l_strbuf.toString();
    }
}

