/* Copyright (C) 2003 Univ. of Massachusetts Amherst, Computer Science Dept.
   This file is part of "MALLET" (MAchine Learning for LanguagE Toolkit).
   http://www.cs.umass.edu/~mccallum/mallet
   This software is provided under the terms of the Common Public License,
   version 1.0, as published by http://www.opensource.org.  For further
   information, see the file `LICENSE' included with this distribution. */

package cc.mallet.pipe.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.io.*;

import cc.mallet.fst.tests.TestCRF;
import cc.mallet.pipe.*;
import cc.mallet.pipe.iterator.*;
import cc.mallet.pipe.tsf.*;
import cc.mallet.types.InstanceList;

/**
 *  Unit Test for class TestSpacePipe.java
 *
 *
 * Created: Thu Feb 26 14:56:55 2004
 *
 * @author <a href="mailto:casutton@cs.umass.edu">Charles Sutton</a>
 * @version $Id: TestSpacePipe.java,v 1.1 2007/10/22 21:37:40 mccallum Exp $
 */
public class TestSpacePipe extends TestCase {

	public TestSpacePipe (String name){
		super(name);
	}

	public static String spacePipeOutput =
		"name: array:0\ninput: TokenSequence edu.umass.cs.mallet.base.types.TokenSequence@1f6226\nToken#0:f feature(r@1_&_e@2_&_e@3)=1.0 feature(<START2>@-3_&_<START1>@-2_&_<START0>@-1)=1.0 feature(f_&_r@1_&_e@2)=1.0 feature(<START1>@-2_&_<START0>@-1_&_f)=1.0 feature(f_&_r@1)=1.0 feature(<START0>@-1_&_f)=1.0 feature(r@1)=1.0 feature(f)=1.0\nToken#1:r feature(e@1_&_e@2_&_s@3)=1.0 feature(<START1>@-3_&_<START0>@-2_&_f@-1)=1.0 feature(r_&_e@1_&_e@2)=1.0 feature(<START0>@-2_&_f@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(f@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#2:e feature(e@1_&_s@2_&_o@3)=1.0 feature(<START0>@-3_&_f@-2_&_r@-1)=1.0 feature(e_&_e@1_&_s@2)=1.0 feature(f@-2_&_r@-1_&_e)=1.0 feature(e_&_e@1)=1.0 feature(r@-1_&_e)=1.0 feature(e@1)=1.0 feature(e)=1.0\nToken#3:e feature(s@1_&_o@2_&_f@3)=1.0 feature(f@-3_&_r@-2_&_e@-1)=1.0 feature(e_&_s@1_&_o@2)=1.0 feature(r@-2_&_e@-1_&_e)=1.0 feature(e_&_s@1)=1.0 feature(e@-1_&_e)=1.0 feature(s@1)=1.0 feature(e)=1.0\nToken#4:s feature(o@1_&_f@2_&_t@3)=1.0 feature(r@-3_&_e@-2_&_e@-1)=1.0 feature(s_&_o@1_&_f@2)=1.0 feature(e@-2_&_e@-1_&_s)=1.0 feature(s_&_o@1)=1.0 feature(e@-1_&_s)=1.0 feature(o@1)=1.0 feature(s)=1.0\nToken#5:o feature(f@1_&_t@2_&_w@3)=1.0 feature(e@-3_&_e@-2_&_s@-1)=1.0 feature(o_&_f@1_&_t@2)=1.0 feature(e@-2_&_s@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(s@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#6:f feature(t@1_&_w@2_&_a@3)=1.0 feature(e@-3_&_s@-2_&_o@-1)=1.0 feature(f_&_t@1_&_w@2)=1.0 feature(s@-2_&_o@-1_&_f)=1.0 feature(f_&_t@1)=1.0 feature(o@-1_&_f)=1.0 feature(t@1)=1.0 feature(f)=1.0\nToken#7:t feature(w@1_&_a@2_&_r@3)=1.0 feature(s@-3_&_o@-2_&_f@-1)=1.0 feature(t_&_w@1_&_a@2)=1.0 feature(o@-2_&_f@-1_&_t)=1.0 feature(t_&_w@1)=1.0 feature(f@-1_&_t)=1.0 feature(w@1)=1.0 feature(t)=1.0\nToken#8:w feature(a@1_&_r@2_&_e@3)=1.0 feature(o@-3_&_f@-2_&_t@-1)=1.0 feature(w_&_a@1_&_r@2)=1.0 feature(f@-2_&_t@-1_&_w)=1.0 feature(w_&_a@1)=1.0 feature(t@-1_&_w)=1.0 feature(a@1)=1.0 feature(w)=1.0\nToken#9:a feature(r@1_&_e@2_&_i@3)=1.0 feature(f@-3_&_t@-2_&_w@-1)=1.0 feature(a_&_r@1_&_e@2)=1.0 feature(t@-2_&_w@-1_&_a)=1.0 feature(a_&_r@1)=1.0 feature(w@-1_&_a)=1.0 feature(r@1)=1.0 feature(a)=1.0\nToken#10:r feature(e@1_&_i@2_&_s@3)=1.0 feature(t@-3_&_w@-2_&_a@-1)=1.0 feature(r_&_e@1_&_i@2)=1.0 feature(w@-2_&_a@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(a@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#11:e feature(i@1_&_s@2_&_a@3)=1.0 feature(w@-3_&_a@-2_&_r@-1)=1.0 feature(e_&_i@1_&_s@2)=1.0 feature(a@-2_&_r@-1_&_e)=1.0 feature(e_&_i@1)=1.0 feature(r@-1_&_e)=1.0 feature(i@1)=1.0 feature(e)=1.0\nToken#12:i feature(s@1_&_a@2_&_m@3)=1.0 feature(a@-3_&_r@-2_&_e@-1)=1.0 feature(i_&_s@1_&_a@2)=1.0 feature(r@-2_&_e@-1_&_i)=1.0 feature(i_&_s@1)=1.0 feature(e@-1_&_i)=1.0 feature(s@1)=1.0 feature(i)=1.0\nToken#13:s feature(a@1_&_m@2_&_a@3)=1.0 feature(r@-3_&_e@-2_&_i@-1)=1.0 feature(s_&_a@1_&_m@2)=1.0 feature(e@-2_&_i@-1_&_s)=1.0 feature(s_&_a@1)=1.0 feature(i@-1_&_s)=1.0 feature(a@1)=1.0 feature(s)=1.0\nToken#14:a feature(m@1_&_a@2_&_t@3)=1.0 feature(e@-3_&_i@-2_&_s@-1)=1.0 feature(a_&_m@1_&_a@2)=1.0 feature(i@-2_&_s@-1_&_a)=1.0 feature(a_&_m@1)=1.0 feature(s@-1_&_a)=1.0 feature(m@1)=1.0 feature(a)=1.0\nToken#15:m feature(a@1_&_t@2_&_t@3)=1.0 feature(i@-3_&_s@-2_&_a@-1)=1.0 feature(m_&_a@1_&_t@2)=1.0 feature(s@-2_&_a@-1_&_m)=1.0 feature(m_&_a@1)=1.0 feature(a@-1_&_m)=1.0 feature(a@1)=1.0 feature(m)=1.0\nToken#16:a feature(t@1_&_t@2_&_e@3)=1.0 feature(s@-3_&_a@-2_&_m@-1)=1.0 feature(a_&_t@1_&_t@2)=1.0 feature(a@-2_&_m@-1_&_a)=1.0 feature(a_&_t@1)=1.0 feature(m@-1_&_a)=1.0 feature(t@1)=1.0 feature(a)=1.0\nToken#17:t feature(t@1_&_e@2_&_r@3)=1.0 feature(a@-3_&_m@-2_&_a@-1)=1.0 feature(t_&_t@1_&_e@2)=1.0 feature(m@-2_&_a@-1_&_t)=1.0 feature(t_&_t@1)=1.0 feature(a@-1_&_t)=1.0 feature(t@1)=1.0 feature(t)=1.0\nToken#18:t feature(e@1_&_r@2_&_o@3)=1.0 feature(m@-3_&_a@-2_&_t@-1)=1.0 feature(t_&_e@1_&_r@2)=1.0 feature(a@-2_&_t@-1_&_t)=1.0 feature(t_&_e@1)=1.0 feature(t@-1_&_t)=1.0 feature(e@1)=1.0 feature(t)=1.0\nToken#19:e feature(r@1_&_o@2_&_f@3)=1.0 feature(a@-3_&_t@-2_&_t@-1)=1.0 feature(e_&_r@1_&_o@2)=1.0 feature(t@-2_&_t@-1_&_e)=1.0 feature(e_&_r@1)=1.0 feature(t@-1_&_e)=1.0 feature(r@1)=1.0 feature(e)=1.0\nToken#20:r feature(o@1_&_f@2_&_t@3)=1.0 feature(t@-3_&_t@-2_&_e@-1)=1.0 feature(r_&_o@1_&_f@2)=1.0 feature(t@-2_&_e@-1_&_r)=1.0 feature(r_&_o@1)=1.0 feature(e@-1_&_r)=1.0 feature(o@1)=1.0 feature(r)=1.0\nToken#21:o feature(f@1_&_t@2_&_h@3)=1.0 feature(t@-3_&_e@-2_&_r@-1)=1.0 feature(o_&_f@1_&_t@2)=1.0 feature(e@-2_&_r@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(r@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#22:f feature(t@1_&_h@2_&_e@3)=1.0 feature(e@-3_&_r@-2_&_o@-1)=1.0 feature(f_&_t@1_&_h@2)=1.0 feature(r@-2_&_o@-1_&_f)=1.0 feature(f_&_t@1)=1.0 feature(o@-1_&_f)=1.0 feature(t@1)=1.0 feature(f)=1.0\nToken#23:t feature(h@1_&_e@2_&_u@3)=1.0 feature(r@-3_&_o@-2_&_f@-1)=1.0 feature(t_&_h@1_&_e@2)=1.0 feature(o@-2_&_f@-1_&_t)=1.0 feature(t_&_h@1)=1.0 feature(f@-1_&_t)=1.0 feature(h@1)=1.0 feature(t)=1.0\nToken#24:h feature(e@1_&_u@2_&_s@3)=1.0 feature(o@-3_&_f@-2_&_t@-1)=1.0 feature(h_&_e@1_&_u@2)=1.0 feature(f@-2_&_t@-1_&_h)=1.0 feature(h_&_e@1)=1.0 feature(t@-1_&_h)=1.0 feature(e@1)=1.0 feature(h)=1.0\nToken#25:e feature(u@1_&_s@2_&_e@3)=1.0 feature(f@-3_&_t@-2_&_h@-1)=1.0 feature(e_&_u@1_&_s@2)=1.0 feature(t@-2_&_h@-1_&_e)=1.0 feature(e_&_u@1)=1.0 feature(h@-1_&_e)=1.0 feature(u@1)=1.0 feature(e)=1.0\nToken#26:u feature(s@1_&_e@2_&_r@3)=1.0 feature(t@-3_&_h@-2_&_e@-1)=1.0 feature(u_&_s@1_&_e@2)=1.0 feature(h@-2_&_e@-1_&_u)=1.0 feature(u_&_s@1)=1.0 feature(e@-1_&_u)=1.0 feature(s@1)=1.0 feature(u)=1.0\nToken#27:s feature(e@1_&_r@2_&_s@3)=1.0 feature(h@-3_&_e@-2_&_u@-1)=1.0 feature(s_&_e@1_&_r@2)=1.0 feature(e@-2_&_u@-1_&_s)=1.0 feature(s_&_e@1)=1.0 feature(u@-1_&_s)=1.0 feature(e@1)=1.0 feature(s)=1.0\nToken#28:e feature(r@1_&_s@2_&_'@3)=1.0 feature(e@-3_&_u@-2_&_s@-1)=1.0 feature(e_&_r@1_&_s@2)=1.0 feature(u@-2_&_s@-1_&_e)=1.0 feature(e_&_r@1)=1.0 feature(s@-1_&_e)=1.0 feature(r@1)=1.0 feature(e)=1.0\nToken#29:r feature(s@1_&_'@2_&_f@3)=1.0 feature(u@-3_&_s@-2_&_e@-1)=1.0 feature(r_&_s@1_&_'@2)=1.0 feature(s@-2_&_e@-1_&_r)=1.0 feature(r_&_s@1)=1.0 feature(e@-1_&_r)=1.0 feature(s@1)=1.0 feature(r)=1.0\nToken#30:s feature('@1_&_f@2_&_r@3)=1.0 feature(s@-3_&_e@-2_&_r@-1)=1.0 feature(s_&_'@1_&_f@2)=1.0 feature(e@-2_&_r@-1_&_s)=1.0 feature(s_&_'@1)=1.0 feature(r@-1_&_s)=1.0 feature('@1)=1.0 feature(s)=1.0\nToken#31:' feature(f@1_&_r@2_&_e@3)=1.0 feature(e@-3_&_r@-2_&_s@-1)=1.0 feature('_&_f@1_&_r@2)=1.0 feature(r@-2_&_s@-1_&_')=1.0 feature('_&_f@1)=1.0 feature(s@-1_&_')=1.0 feature(f@1)=1.0 feature(')=1.0\nToken#32:f feature(r@1_&_e@2_&_e@3)=1.0 feature(r@-3_&_s@-2_&_'@-1)=1.0 feature(f_&_r@1_&_e@2)=1.0 feature(s@-2_&_'@-1_&_f)=1.0 feature(f_&_r@1)=1.0 feature('@-1_&_f)=1.0 feature(r@1)=1.0 feature(f)=1.0\nToken#33:r feature(e@1_&_e@2_&_d@3)=1.0 feature(s@-3_&_'@-2_&_f@-1)=1.0 feature(r_&_e@1_&_e@2)=1.0 feature('@-2_&_f@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(f@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#34:e feature(e@1_&_d@2_&_o@3)=1.0 feature('@-3_&_f@-2_&_r@-1)=1.0 feature(e_&_e@1_&_d@2)=1.0 feature(f@-2_&_r@-1_&_e)=1.0 feature(e_&_e@1)=1.0 feature(r@-1_&_e)=1.0 feature(e@1)=1.0 feature(e)=1.0\nToken#35:e feature(d@1_&_o@2_&_m@3)=1.0 feature(f@-3_&_r@-2_&_e@-1)=1.0 feature(e_&_d@1_&_o@2)=1.0 feature(r@-2_&_e@-1_&_e)=1.0 feature(e_&_d@1)=1.0 feature(e@-1_&_e)=1.0 feature(d@1)=1.0 feature(e)=1.0\nToken#36:d feature(o@1_&_m@2_&_t@3)=1.0 feature(r@-3_&_e@-2_&_e@-1)=1.0 feature(d_&_o@1_&_m@2)=1.0 feature(e@-2_&_e@-1_&_d)=1.0 feature(d_&_o@1)=1.0 feature(e@-1_&_d)=1.0 feature(o@1)=1.0 feature(d)=1.0\nToken#37:o feature(m@1_&_t@2_&_o@3)=1.0 feature(e@-3_&_e@-2_&_d@-1)=1.0 feature(o_&_m@1_&_t@2)=1.0 feature(e@-2_&_d@-1_&_o)=1.0 feature(o_&_m@1)=1.0 feature(d@-1_&_o)=1.0 feature(m@1)=1.0 feature(o)=1.0\nToken#38:m feature(t@1_&_o@2_&_r@3)=1.0 feature(e@-3_&_d@-2_&_o@-1)=1.0 feature(m_&_t@1_&_o@2)=1.0 feature(d@-2_&_o@-1_&_m)=1.0 feature(m_&_t@1)=1.0 feature(o@-1_&_m)=1.0 feature(t@1)=1.0 feature(m)=1.0\nToken#39:t feature(o@1_&_r@2_&_u@3)=1.0 feature(d@-3_&_o@-2_&_m@-1)=1.0 feature(t_&_o@1_&_r@2)=1.0 feature(o@-2_&_m@-1_&_t)=1.0 feature(t_&_o@1)=1.0 feature(m@-1_&_t)=1.0 feature(o@1)=1.0 feature(t)=1.0\nToken#40:o feature(r@1_&_u@2_&_n@3)=1.0 feature(o@-3_&_m@-2_&_t@-1)=1.0 feature(o_&_r@1_&_u@2)=1.0 feature(m@-2_&_t@-1_&_o)=1.0 feature(o_&_r@1)=1.0 feature(t@-1_&_o)=1.0 feature(r@1)=1.0 feature(o)=1.0\nToken#41:r feature(u@1_&_n@2_&_,@3)=1.0 feature(m@-3_&_t@-2_&_o@-1)=1.0 feature(r_&_u@1_&_n@2)=1.0 feature(t@-2_&_o@-1_&_r)=1.0 feature(r_&_u@1)=1.0 feature(o@-1_&_r)=1.0 feature(u@1)=1.0 feature(r)=1.0\nToken#42:u feature(n@1_&_,@2_&_c@3)=1.0 feature(t@-3_&_o@-2_&_r@-1)=1.0 feature(u_&_n@1_&_,@2)=1.0 feature(o@-2_&_r@-1_&_u)=1.0 feature(u_&_n@1)=1.0 feature(r@-1_&_u)=1.0 feature(n@1)=1.0 feature(u)=1.0\nToken#43:n feature(,@1_&_c@2_&_o@3)=1.0 feature(o@-3_&_r@-2_&_u@-1)=1.0 feature(n_&_,@1_&_c@2)=1.0 feature(r@-2_&_u@-1_&_n)=1.0 feature(n_&_,@1)=1.0 feature(u@-1_&_n)=1.0 feature(,@1)=1.0 feature(n)=1.0\nToken#44:, feature(c@1_&_o@2_&_p@3)=1.0 feature(r@-3_&_u@-2_&_n@-1)=1.0 feature(,_&_c@1_&_o@2)=1.0 feature(u@-2_&_n@-1_&_,)=1.0 feature(,_&_c@1)=1.0 feature(n@-1_&_,)=1.0 feature(c@1)=1.0 feature(,)=1.0\nToken#45:c feature(o@1_&_p@2_&_y@3)=1.0 feature(u@-3_&_n@-2_&_,@-1)=1.0 feature(c_&_o@1_&_p@2)=1.0 feature(n@-2_&_,@-1_&_c)=1.0 feature(c_&_o@1)=1.0 feature(,@-1_&_c)=1.0 feature(o@1)=1.0 feature(c)=1.0\nToken#46:o feature(p@1_&_y@2_&_,@3)=1.0 feature(n@-3_&_,@-2_&_c@-1)=1.0 feature(o_&_p@1_&_y@2)=1.0 feature(,@-2_&_c@-1_&_o)=1.0 feature(o_&_p@1)=1.0 feature(c@-1_&_o)=1.0 feature(p@1)=1.0 feature(o)=1.0\nToken#47:p feature(y@1_&_,@2_&_d@3)=1.0 feature(,@-3_&_c@-2_&_o@-1)=1.0 feature(p_&_y@1_&_,@2)=1.0 feature(c@-2_&_o@-1_&_p)=1.0 feature(p_&_y@1)=1.0 feature(o@-1_&_p)=1.0 feature(y@1)=1.0 feature(p)=1.0\nToken#48:y feature(,@1_&_d@2_&_i@3)=1.0 feature(c@-3_&_o@-2_&_p@-1)=1.0 feature(y_&_,@1_&_d@2)=1.0 feature(o@-2_&_p@-1_&_y)=1.0 feature(y_&_,@1)=1.0 feature(p@-1_&_y)=1.0 feature(,@1)=1.0 feature(y)=1.0\nToken#49:, feature(d@1_&_i@2_&_s@3)=1.0 feature(o@-3_&_p@-2_&_y@-1)=1.0 feature(,_&_d@1_&_i@2)=1.0 feature(p@-2_&_y@-1_&_,)=1.0 feature(,_&_d@1)=1.0 feature(y@-1_&_,)=1.0 feature(d@1)=1.0 feature(,)=1.0\nToken#50:d feature(i@1_&_s@2_&_t@3)=1.0 feature(p@-3_&_y@-2_&_,@-1)=1.0 feature(d_&_i@1_&_s@2)=1.0 feature(y@-2_&_,@-1_&_d)=1.0 feature(d_&_i@1)=1.0 feature(,@-1_&_d)=1.0 feature(i@1)=1.0 feature(d)=1.0\nToken#51:i feature(s@1_&_t@2_&_r@3)=1.0 feature(y@-3_&_,@-2_&_d@-1)=1.0 feature(i_&_s@1_&_t@2)=1.0 feature(,@-2_&_d@-1_&_i)=1.0 feature(i_&_s@1)=1.0 feature(d@-1_&_i)=1.0 feature(s@1)=1.0 feature(i)=1.0\nToken#52:s feature(t@1_&_r@2_&_i@3)=1.0 feature(,@-3_&_d@-2_&_i@-1)=1.0 feature(s_&_t@1_&_r@2)=1.0 feature(d@-2_&_i@-1_&_s)=1.0 feature(s_&_t@1)=1.0 feature(i@-1_&_s)=1.0 feature(t@1)=1.0 feature(s)=1.0\nToken#53:t feature(r@1_&_i@2_&_b@3)=1.0 feature(d@-3_&_i@-2_&_s@-1)=1.0 feature(t_&_r@1_&_i@2)=1.0 feature(i@-2_&_s@-1_&_t)=1.0 feature(t_&_r@1)=1.0 feature(s@-1_&_t)=1.0 feature(r@1)=1.0 feature(t)=1.0\nToken#54:r feature(i@1_&_b@2_&_u@3)=1.0 feature(i@-3_&_s@-2_&_t@-1)=1.0 feature(r_&_i@1_&_b@2)=1.0 feature(s@-2_&_t@-1_&_r)=1.0 feature(r_&_i@1)=1.0 feature(t@-1_&_r)=1.0 feature(i@1)=1.0 feature(r)=1.0\nToken#55:i feature(b@1_&_u@2_&_t@3)=1.0 feature(s@-3_&_t@-2_&_r@-1)=1.0 feature(i_&_b@1_&_u@2)=1.0 feature(t@-2_&_r@-1_&_i)=1.0 feature(i_&_b@1)=1.0 feature(r@-1_&_i)=1.0 feature(b@1)=1.0 feature(i)=1.0\nToken#56:b feature(u@1_&_t@2_&_e@3)=1.0 feature(t@-3_&_r@-2_&_i@-1)=1.0 feature(b_&_u@1_&_t@2)=1.0 feature(r@-2_&_i@-1_&_b)=1.0 feature(b_&_u@1)=1.0 feature(i@-1_&_b)=1.0 feature(u@1)=1.0 feature(b)=1.0\nToken#57:u feature(t@1_&_e@2_&_,@3)=1.0 feature(r@-3_&_i@-2_&_b@-1)=1.0 feature(u_&_t@1_&_e@2)=1.0 feature(i@-2_&_b@-1_&_u)=1.0 feature(u_&_t@1)=1.0 feature(b@-1_&_u)=1.0 feature(t@1)=1.0 feature(u)=1.0\nToken#58:t feature(e@1_&_,@2_&_s@3)=1.0 feature(i@-3_&_b@-2_&_u@-1)=1.0 feature(t_&_e@1_&_,@2)=1.0 feature(b@-2_&_u@-1_&_t)=1.0 feature(t_&_e@1)=1.0 feature(u@-1_&_t)=1.0 feature(e@1)=1.0 feature(t)=1.0\nToken#59:e feature(,@1_&_s@2_&_t@3)=1.0 feature(b@-3_&_u@-2_&_t@-1)=1.0 feature(e_&_,@1_&_s@2)=1.0 feature(u@-2_&_t@-1_&_e)=1.0 feature(e_&_,@1)=1.0 feature(t@-1_&_e)=1.0 feature(,@1)=1.0 feature(e)=1.0\nToken#60:, feature(s@1_&_t@2_&_u@3)=1.0 feature(u@-3_&_t@-2_&_e@-1)=1.0 feature(,_&_s@1_&_t@2)=1.0 feature(t@-2_&_e@-1_&_,)=1.0 feature(,_&_s@1)=1.0 feature(e@-1_&_,)=1.0 feature(s@1)=1.0 feature(,)=1.0\nToken#61:s feature(t@1_&_u@2_&_d@3)=1.0 feature(t@-3_&_e@-2_&_,@-1)=1.0 feature(s_&_t@1_&_u@2)=1.0 feature(e@-2_&_,@-1_&_s)=1.0 feature(s_&_t@1)=1.0 feature(,@-1_&_s)=1.0 feature(t@1)=1.0 feature(s)=1.0\nToken#62:t feature(u@1_&_d@2_&_y@3)=1.0 feature(e@-3_&_,@-2_&_s@-1)=1.0 feature(t_&_u@1_&_d@2)=1.0 feature(,@-2_&_s@-1_&_t)=1.0 feature(t_&_u@1)=1.0 feature(s@-1_&_t)=1.0 feature(u@1)=1.0 feature(t)=1.0\nToken#63:u feature(d@1_&_y@2_&_,@3)=1.0 feature(,@-3_&_s@-2_&_t@-1)=1.0 feature(u_&_d@1_&_y@2)=1.0 feature(s@-2_&_t@-1_&_u)=1.0 feature(u_&_d@1)=1.0 feature(t@-1_&_u)=1.0 feature(d@1)=1.0 feature(u)=1.0\nToken#64:d feature(y@1_&_,@2_&_c@3)=1.0 feature(s@-3_&_t@-2_&_u@-1)=1.0 feature(d_&_y@1_&_,@2)=1.0 feature(t@-2_&_u@-1_&_d)=1.0 feature(d_&_y@1)=1.0 feature(u@-1_&_d)=1.0 feature(y@1)=1.0 feature(d)=1.0\nToken#65:y feature(,@1_&_c@2_&_h@3)=1.0 feature(t@-3_&_u@-2_&_d@-1)=1.0 feature(y_&_,@1_&_c@2)=1.0 feature(u@-2_&_d@-1_&_y)=1.0 feature(y_&_,@1)=1.0 feature(d@-1_&_y)=1.0 feature(,@1)=1.0 feature(y)=1.0\nToken#66:, feature(c@1_&_h@2_&_a@3)=1.0 feature(u@-3_&_d@-2_&_y@-1)=1.0 feature(,_&_c@1_&_h@2)=1.0 feature(d@-2_&_y@-1_&_,)=1.0 feature(,_&_c@1)=1.0 feature(y@-1_&_,)=1.0 feature(c@1)=1.0 feature(,)=1.0\nToken#67:c feature(h@1_&_a@2_&_n@3)=1.0 feature(d@-3_&_y@-2_&_,@-1)=1.0 feature(c_&_h@1_&_a@2)=1.0 feature(y@-2_&_,@-1_&_c)=1.0 feature(c_&_h@1)=1.0 feature(,@-1_&_c)=1.0 feature(h@1)=1.0 feature(c)=1.0\nToken#68:h feature(a@1_&_n@2_&_g@3)=1.0 feature(y@-3_&_,@-2_&_c@-1)=1.0 feature(h_&_a@1_&_n@2)=1.0 feature(,@-2_&_c@-1_&_h)=1.0 feature(h_&_a@1)=1.0 feature(c@-1_&_h)=1.0 feature(a@1)=1.0 feature(h)=1.0\nToken#69:a feature(n@1_&_g@2_&_e@3)=1.0 feature(,@-3_&_c@-2_&_h@-1)=1.0 feature(a_&_n@1_&_g@2)=1.0 feature(c@-2_&_h@-1_&_a)=1.0 feature(a_&_n@1)=1.0 feature(h@-1_&_a)=1.0 feature(n@1)=1.0 feature(a)=1.0\nToken#70:n feature(g@1_&_e@2_&_a@3)=1.0 feature(c@-3_&_h@-2_&_a@-1)=1.0 feature(n_&_g@1_&_e@2)=1.0 feature(h@-2_&_a@-1_&_n)=1.0 feature(n_&_g@1)=1.0 feature(a@-1_&_n)=1.0 feature(g@1)=1.0 feature(n)=1.0\nToken#71:g feature(e@1_&_a@2_&_n@3)=1.0 feature(h@-3_&_a@-2_&_n@-1)=1.0 feature(g_&_e@1_&_a@2)=1.0 feature(a@-2_&_n@-1_&_g)=1.0 feature(g_&_e@1)=1.0 feature(n@-1_&_g)=1.0 feature(e@1)=1.0 feature(g)=1.0\nToken#72:e feature(a@1_&_n@2_&_d@3)=1.0 feature(a@-3_&_n@-2_&_g@-1)=1.0 feature(e_&_a@1_&_n@2)=1.0 feature(n@-2_&_g@-1_&_e)=1.0 feature(e_&_a@1)=1.0 feature(g@-1_&_e)=1.0 feature(a@1)=1.0 feature(e)=1.0\nToken#73:a feature(n@1_&_d@2_&_i@3)=1.0 feature(n@-3_&_g@-2_&_e@-1)=1.0 feature(a_&_n@1_&_d@2)=1.0 feature(g@-2_&_e@-1_&_a)=1.0 feature(a_&_n@1)=1.0 feature(e@-1_&_a)=1.0 feature(n@1)=1.0 feature(a)=1.0\nToken#74:n feature(d@1_&_i@2_&_m@3)=1.0 feature(g@-3_&_e@-2_&_a@-1)=1.0 feature(n_&_d@1_&_i@2)=1.0 feature(e@-2_&_a@-1_&_n)=1.0 feature(n_&_d@1)=1.0 feature(a@-1_&_n)=1.0 feature(d@1)=1.0 feature(n)=1.0\nToken#75:d feature(i@1_&_m@2_&_p@3)=1.0 feature(e@-3_&_a@-2_&_n@-1)=1.0 feature(d_&_i@1_&_m@2)=1.0 feature(a@-2_&_n@-1_&_d)=1.0 feature(d_&_i@1)=1.0 feature(n@-1_&_d)=1.0 feature(i@1)=1.0 feature(d)=1.0\nToken#76:i feature(m@1_&_p@2_&_r@3)=1.0 feature(a@-3_&_n@-2_&_d@-1)=1.0 feature(i_&_m@1_&_p@2)=1.0 feature(n@-2_&_d@-1_&_i)=1.0 feature(i_&_m@1)=1.0 feature(d@-1_&_i)=1.0 feature(m@1)=1.0 feature(i)=1.0\nToken#77:m feature(p@1_&_r@2_&_o@3)=1.0 feature(n@-3_&_d@-2_&_i@-1)=1.0 feature(m_&_p@1_&_r@2)=1.0 feature(d@-2_&_i@-1_&_m)=1.0 feature(m_&_p@1)=1.0 feature(i@-1_&_m)=1.0 feature(p@1)=1.0 feature(m)=1.0\nToken#78:p feature(r@1_&_o@2_&_v@3)=1.0 feature(d@-3_&_i@-2_&_m@-1)=1.0 feature(p_&_r@1_&_o@2)=1.0 feature(i@-2_&_m@-1_&_p)=1.0 feature(p_&_r@1)=1.0 feature(m@-1_&_p)=1.0 feature(r@1)=1.0 feature(p)=1.0\nToken#79:r feature(o@1_&_v@2_&_e@3)=1.0 feature(i@-3_&_m@-2_&_p@-1)=1.0 feature(r_&_o@1_&_v@2)=1.0 feature(m@-2_&_p@-1_&_r)=1.0 feature(r_&_o@1)=1.0 feature(p@-1_&_r)=1.0 feature(o@1)=1.0 feature(r)=1.0\nToken#80:o feature(v@1_&_e@2_&_t@3)=1.0 feature(m@-3_&_p@-2_&_r@-1)=1.0 feature(o_&_v@1_&_e@2)=1.0 feature(p@-2_&_r@-1_&_o)=1.0 feature(o_&_v@1)=1.0 feature(r@-1_&_o)=1.0 feature(v@1)=1.0 feature(o)=1.0\nToken#81:v feature(e@1_&_t@2_&_h@3)=1.0 feature(p@-3_&_r@-2_&_o@-1)=1.0 feature(v_&_e@1_&_t@2)=1.0 feature(r@-2_&_o@-1_&_v)=1.0 feature(v_&_e@1)=1.0 feature(o@-1_&_v)=1.0 feature(e@1)=1.0 feature(v)=1.0\nToken#82:e feature(t@1_&_h@2_&_e@3)=1.0 feature(r@-3_&_o@-2_&_v@-1)=1.0 feature(e_&_t@1_&_h@2)=1.0 feature(o@-2_&_v@-1_&_e)=1.0 feature(e_&_t@1)=1.0 feature(v@-1_&_e)=1.0 feature(t@1)=1.0 feature(e)=1.0\nToken#83:t feature(h@1_&_e@2_&_s@3)=1.0 feature(o@-3_&_v@-2_&_e@-1)=1.0 feature(t_&_h@1_&_e@2)=1.0 feature(v@-2_&_e@-1_&_t)=1.0 feature(t_&_h@1)=1.0 feature(e@-1_&_t)=1.0 feature(h@1)=1.0 feature(t)=1.0\nToken#84:h feature(e@1_&_s@2_&_o@3)=1.0 feature(v@-3_&_e@-2_&_t@-1)=1.0 feature(h_&_e@1_&_s@2)=1.0 feature(e@-2_&_t@-1_&_h)=1.0 feature(h_&_e@1)=1.0 feature(t@-1_&_h)=1.0 feature(e@1)=1.0 feature(h)=1.0\nToken#85:e feature(s@1_&_o@2_&_f@3)=1.0 feature(e@-3_&_t@-2_&_h@-1)=1.0 feature(e_&_s@1_&_o@2)=1.0 feature(t@-2_&_h@-1_&_e)=1.0 feature(e_&_s@1)=1.0 feature(h@-1_&_e)=1.0 feature(s@1)=1.0 feature(e)=1.0\nToken#86:s feature(o@1_&_f@2_&_t@3)=1.0 feature(t@-3_&_h@-2_&_e@-1)=1.0 feature(s_&_o@1_&_f@2)=1.0 feature(h@-2_&_e@-1_&_s)=1.0 feature(s_&_o@1)=1.0 feature(e@-1_&_s)=1.0 feature(o@1)=1.0 feature(s)=1.0\nToken#87:o feature(f@1_&_t@2_&_w@3)=1.0 feature(h@-3_&_e@-2_&_s@-1)=1.0 feature(o_&_f@1_&_t@2)=1.0 feature(e@-2_&_s@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(s@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#88:f feature(t@1_&_w@2_&_a@3)=1.0 feature(e@-3_&_s@-2_&_o@-1)=1.0 feature(f_&_t@1_&_w@2)=1.0 feature(s@-2_&_o@-1_&_f)=1.0 feature(f_&_t@1)=1.0 feature(o@-1_&_f)=1.0 feature(t@1)=1.0 feature(f)=1.0\nToken#89:t feature(w@1_&_a@2_&_r@3)=1.0 feature(s@-3_&_o@-2_&_f@-1)=1.0 feature(t_&_w@1_&_a@2)=1.0 feature(o@-2_&_f@-1_&_t)=1.0 feature(t_&_w@1)=1.0 feature(f@-1_&_t)=1.0 feature(w@1)=1.0 feature(t)=1.0\nToken#90:w feature(a@1_&_r@2_&_e@3)=1.0 feature(o@-3_&_f@-2_&_t@-1)=1.0 feature(w_&_a@1_&_r@2)=1.0 feature(f@-2_&_t@-1_&_w)=1.0 feature(w_&_a@1)=1.0 feature(t@-1_&_w)=1.0 feature(a@1)=1.0 feature(w)=1.0\nToken#91:a feature(r@1_&_e@2_&_.@3)=1.0 feature(f@-3_&_t@-2_&_w@-1)=1.0 feature(a_&_r@1_&_e@2)=1.0 feature(t@-2_&_w@-1_&_a)=1.0 feature(a_&_r@1)=1.0 feature(w@-1_&_a)=1.0 feature(r@1)=1.0 feature(a)=1.0\nToken#92:r feature(e@1_&_.@2_&_m@3)=1.0 feature(t@-3_&_w@-2_&_a@-1)=1.0 feature(r_&_e@1_&_.@2)=1.0 feature(w@-2_&_a@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(a@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#93:e feature(.@1_&_m@2_&_o@3)=1.0 feature(w@-3_&_a@-2_&_r@-1)=1.0 feature(e_&_.@1_&_m@2)=1.0 feature(a@-2_&_r@-1_&_e)=1.0 feature(e_&_.@1)=1.0 feature(r@-1_&_e)=1.0 feature(.@1)=1.0 feature(e)=1.0\nToken#94:. feature(m@1_&_o@2_&_r@3)=1.0 feature(a@-3_&_r@-2_&_e@-1)=1.0 feature(._&_m@1_&_o@2)=1.0 feature(r@-2_&_e@-1_&_.)=1.0 feature(._&_m@1)=1.0 feature(e@-1_&_.)=1.0 feature(m@1)=1.0 feature(.)=1.0\nToken#95:m feature(o@1_&_r@2_&_e@3)=1.0 feature(r@-3_&_e@-2_&_.@-1)=1.0 feature(m_&_o@1_&_r@2)=1.0 feature(e@-2_&_.@-1_&_m)=1.0 feature(m_&_o@1)=1.0 feature(.@-1_&_m)=1.0 feature(o@1)=1.0 feature(m)=1.0\nToken#96:o feature(r@1_&_e@2_&_p@3)=1.0 feature(e@-3_&_.@-2_&_m@-1)=1.0 feature(o_&_r@1_&_e@2)=1.0 feature(.@-2_&_m@-1_&_o)=1.0 feature(o_&_r@1)=1.0 feature(m@-1_&_o)=1.0 feature(r@1)=1.0 feature(o)=1.0\nToken#97:r feature(e@1_&_p@2_&_r@3)=1.0 feature(.@-3_&_m@-2_&_o@-1)=1.0 feature(r_&_e@1_&_p@2)=1.0 feature(m@-2_&_o@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(o@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#98:e feature(p@1_&_r@2_&_e@3)=1.0 feature(m@-3_&_o@-2_&_r@-1)=1.0 feature(e_&_p@1_&_r@2)=1.0 feature(o@-2_&_r@-1_&_e)=1.0 feature(e_&_p@1)=1.0 feature(r@-1_&_e)=1.0 feature(p@1)=1.0 feature(e)=1.0\nToken#99:p feature(r@1_&_e@2_&_c@3)=1.0 feature(o@-3_&_r@-2_&_e@-1)=1.0 feature(p_&_r@1_&_e@2)=1.0 feature(r@-2_&_e@-1_&_p)=1.0 feature(p_&_r@1)=1.0 feature(e@-1_&_p)=1.0 feature(r@1)=1.0 feature(p)=1.0\nToken#100:r feature(e@1_&_c@2_&_i@3)=1.0 feature(r@-3_&_e@-2_&_p@-1)=1.0 feature(r_&_e@1_&_c@2)=1.0 feature(e@-2_&_p@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(p@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#101:e feature(c@1_&_i@2_&_s@3)=1.0 feature(e@-3_&_p@-2_&_r@-1)=1.0 feature(e_&_c@1_&_i@2)=1.0 feature(p@-2_&_r@-1_&_e)=1.0 feature(e_&_c@1)=1.0 feature(r@-1_&_e)=1.0 feature(c@1)=1.0 feature(e)=1.0\nToken#102:c feature(i@1_&_s@2_&_e@3)=1.0 feature(p@-3_&_r@-2_&_e@-1)=1.0 feature(c_&_i@1_&_s@2)=1.0 feature(r@-2_&_e@-1_&_c)=1.0 feature(c_&_i@1)=1.0 feature(e@-1_&_c)=1.0 feature(i@1)=1.0 feature(c)=1.0\nToken#103:i feature(s@1_&_e@2_&_l@3)=1.0 feature(r@-3_&_e@-2_&_c@-1)=1.0 feature(i_&_s@1_&_e@2)=1.0 feature(e@-2_&_c@-1_&_i)=1.0 feature(i_&_s@1)=1.0 feature(c@-1_&_i)=1.0 feature(s@1)=1.0 feature(i)=1.0\nToken#104:s feature(e@1_&_l@2_&_y@3)=1.0 feature(e@-3_&_c@-2_&_i@-1)=1.0 feature(s_&_e@1_&_l@2)=1.0 feature(c@-2_&_i@-1_&_s)=1.0 feature(s_&_e@1)=1.0 feature(i@-1_&_s)=1.0 feature(e@1)=1.0 feature(s)=1.0\nToken#105:e feature(l@1_&_y@2_&_,@3)=1.0 feature(c@-3_&_i@-2_&_s@-1)=1.0 feature(e_&_l@1_&_y@2)=1.0 feature(i@-2_&_s@-1_&_e)=1.0 feature(e_&_l@1)=1.0 feature(s@-1_&_e)=1.0 feature(l@1)=1.0 feature(e)=1.0\nToken#106:l feature(y@1_&_,@2_&_i@3)=1.0 feature(i@-3_&_s@-2_&_e@-1)=1.0 feature(l_&_y@1_&_,@2)=1.0 feature(s@-2_&_e@-1_&_l)=1.0 feature(l_&_y@1)=1.0 feature(e@-1_&_l)=1.0 feature(y@1)=1.0 feature(l)=1.0\nToken#107:y feature(,@1_&_i@2_&_t@3)=1.0 feature(s@-3_&_e@-2_&_l@-1)=1.0 feature(y_&_,@1_&_i@2)=1.0 feature(e@-2_&_l@-1_&_y)=1.0 feature(y_&_,@1)=1.0 feature(l@-1_&_y)=1.0 feature(,@1)=1.0 feature(y)=1.0\nToken#108:, feature(i@1_&_t@2_&_r@3)=1.0 feature(e@-3_&_l@-2_&_y@-1)=1.0 feature(,_&_i@1_&_t@2)=1.0 feature(l@-2_&_y@-1_&_,)=1.0 feature(,_&_i@1)=1.0 feature(y@-1_&_,)=1.0 feature(i@1)=1.0 feature(,)=1.0\nToken#109:i feature(t@1_&_r@2_&_e@3)=1.0 feature(l@-3_&_y@-2_&_,@-1)=1.0 feature(i_&_t@1_&_r@2)=1.0 feature(y@-2_&_,@-1_&_i)=1.0 feature(i_&_t@1)=1.0 feature(,@-1_&_i)=1.0 feature(t@1)=1.0 feature(i)=1.0\nToken#110:t feature(r@1_&_e@2_&_f@3)=1.0 feature(y@-3_&_,@-2_&_i@-1)=1.0 feature(t_&_r@1_&_e@2)=1.0 feature(,@-2_&_i@-1_&_t)=1.0 feature(t_&_r@1)=1.0 feature(i@-1_&_t)=1.0 feature(r@1)=1.0 feature(t)=1.0\nToken#111:r feature(e@1_&_f@2_&_e@3)=1.0 feature(,@-3_&_i@-2_&_t@-1)=1.0 feature(r_&_e@1_&_f@2)=1.0 feature(i@-2_&_t@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(t@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#112:e feature(f@1_&_e@2_&_r@3)=1.0 feature(i@-3_&_t@-2_&_r@-1)=1.0 feature(e_&_f@1_&_e@2)=1.0 feature(t@-2_&_r@-1_&_e)=1.0 feature(e_&_f@1)=1.0 feature(r@-1_&_e)=1.0 feature(f@1)=1.0 feature(e)=1.0\nToken#113:f feature(e@1_&_r@2_&_s@3)=1.0 feature(t@-3_&_r@-2_&_e@-1)=1.0 feature(f_&_e@1_&_r@2)=1.0 feature(r@-2_&_e@-1_&_f)=1.0 feature(f_&_e@1)=1.0 feature(e@-1_&_f)=1.0 feature(e@1)=1.0 feature(f)=1.0\nToken#114:e feature(r@1_&_s@2_&_t@3)=1.0 feature(r@-3_&_e@-2_&_f@-1)=1.0 feature(e_&_r@1_&_s@2)=1.0 feature(e@-2_&_f@-1_&_e)=1.0 feature(e_&_r@1)=1.0 feature(f@-1_&_e)=1.0 feature(r@1)=1.0 feature(e)=1.0\nToken#115:r feature(s@1_&_t@2_&_o@3)=1.0 feature(e@-3_&_f@-2_&_e@-1)=1.0 feature(r_&_s@1_&_t@2)=1.0 feature(f@-2_&_e@-1_&_r)=1.0 feature(r_&_s@1)=1.0 feature(e@-1_&_r)=1.0 feature(s@1)=1.0 feature(r)=1.0\nToken#116:s feature(t@1_&_o@2_&_f@3)=1.0 feature(f@-3_&_e@-2_&_r@-1)=1.0 feature(s_&_t@1_&_o@2)=1.0 feature(e@-2_&_r@-1_&_s)=1.0 feature(s_&_t@1)=1.0 feature(r@-1_&_s)=1.0 feature(t@1)=1.0 feature(s)=1.0\nToken#117:t feature(o@1_&_f@2_&_o@3)=1.0 feature(e@-3_&_r@-2_&_s@-1)=1.0 feature(t_&_o@1_&_f@2)=1.0 feature(r@-2_&_s@-1_&_t)=1.0 feature(t_&_o@1)=1.0 feature(s@-1_&_t)=1.0 feature(o@1)=1.0 feature(t)=1.0\nToken#118:o feature(f@1_&_o@2_&_u@3)=1.0 feature(r@-3_&_s@-2_&_t@-1)=1.0 feature(o_&_f@1_&_o@2)=1.0 feature(s@-2_&_t@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(t@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#119:f feature(o@1_&_u@2_&_r@3)=1.0 feature(s@-3_&_t@-2_&_o@-1)=1.0 feature(f_&_o@1_&_u@2)=1.0 feature(t@-2_&_o@-1_&_f)=1.0 feature(f_&_o@1)=1.0 feature(o@-1_&_f)=1.0 feature(o@1)=1.0 feature(f)=1.0\nToken#120:o feature(u@1_&_r@2_&_k@3)=1.0 feature(t@-3_&_o@-2_&_f@-1)=1.0 feature(o_&_u@1_&_r@2)=1.0 feature(o@-2_&_f@-1_&_o)=1.0 feature(o_&_u@1)=1.0 feature(f@-1_&_o)=1.0 feature(u@1)=1.0 feature(o)=1.0\nToken#121:u feature(r@1_&_k@2_&_i@3)=1.0 feature(o@-3_&_f@-2_&_o@-1)=1.0 feature(u_&_r@1_&_k@2)=1.0 feature(f@-2_&_o@-1_&_u)=1.0 feature(u_&_r@1)=1.0 feature(o@-1_&_u)=1.0 feature(r@1)=1.0 feature(u)=1.0\nToken#122:r feature(k@1_&_i@2_&_n@3)=1.0 feature(f@-3_&_o@-2_&_u@-1)=1.0 feature(r_&_k@1_&_i@2)=1.0 feature(o@-2_&_u@-1_&_r)=1.0 feature(r_&_k@1)=1.0 feature(u@-1_&_r)=1.0 feature(k@1)=1.0 feature(r)=1.0\nToken#123:k feature(i@1_&_n@2_&_d@3)=1.0 feature(o@-3_&_u@-2_&_r@-1)=1.0 feature(k_&_i@1_&_n@2)=1.0 feature(u@-2_&_r@-1_&_k)=1.0 feature(k_&_i@1)=1.0 feature(r@-1_&_k)=1.0 feature(i@1)=1.0 feature(k)=1.0\nToken#124:i feature(n@1_&_d@2_&_s@3)=1.0 feature(u@-3_&_r@-2_&_k@-1)=1.0 feature(i_&_n@1_&_d@2)=1.0 feature(r@-2_&_k@-1_&_i)=1.0 feature(i_&_n@1)=1.0 feature(k@-1_&_i)=1.0 feature(n@1)=1.0 feature(i)=1.0\nToken#125:n feature(d@1_&_s@2_&_o@3)=1.0 feature(r@-3_&_k@-2_&_i@-1)=1.0 feature(n_&_d@1_&_s@2)=1.0 feature(k@-2_&_i@-1_&_n)=1.0 feature(n_&_d@1)=1.0 feature(i@-1_&_n)=1.0 feature(d@1)=1.0 feature(n)=1.0\nToken#126:d feature(s@1_&_o@2_&_f@3)=1.0 feature(k@-3_&_i@-2_&_n@-1)=1.0 feature(d_&_s@1_&_o@2)=1.0 feature(i@-2_&_n@-1_&_d)=1.0 feature(d_&_s@1)=1.0 feature(n@-1_&_d)=1.0 feature(s@1)=1.0 feature(d)=1.0\nToken#127:s feature(o@1_&_f@2_&_f@3)=1.0 feature(i@-3_&_n@-2_&_d@-1)=1.0 feature(s_&_o@1_&_f@2)=1.0 feature(n@-2_&_d@-1_&_s)=1.0 feature(s_&_o@1)=1.0 feature(d@-1_&_s)=1.0 feature(o@1)=1.0 feature(s)=1.0\nToken#128:o feature(f@1_&_f@2_&_r@3)=1.0 feature(n@-3_&_d@-2_&_s@-1)=1.0 feature(o_&_f@1_&_f@2)=1.0 feature(d@-2_&_s@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(s@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#129:f feature(f@1_&_r@2_&_e@3)=1.0 feature(d@-3_&_s@-2_&_o@-1)=1.0 feature(f_&_f@1_&_r@2)=1.0 feature(s@-2_&_o@-1_&_f)=1.0 feature(f_&_f@1)=1.0 feature(o@-1_&_f)=1.0 feature(f@1)=1.0 feature(f)=1.0\nToken#130:f feature(r@1_&_e@2_&_e@3)=1.0 feature(s@-3_&_o@-2_&_f@-1)=1.0 feature(f_&_r@1_&_e@2)=1.0 feature(o@-2_&_f@-1_&_f)=1.0 feature(f_&_r@1)=1.0 feature(f@-1_&_f)=1.0 feature(r@1)=1.0 feature(f)=1.0\nToken#131:r feature(e@1_&_e@2_&_d@3)=1.0 feature(o@-3_&_f@-2_&_f@-1)=1.0 feature(r_&_e@1_&_e@2)=1.0 feature(f@-2_&_f@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(f@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#132:e feature(e@1_&_d@2_&_o@3)=1.0 feature(f@-3_&_f@-2_&_r@-1)=1.0 feature(e_&_e@1_&_d@2)=1.0 feature(f@-2_&_r@-1_&_e)=1.0 feature(e_&_e@1)=1.0 feature(r@-1_&_e)=1.0 feature(e@1)=1.0 feature(e)=1.0\nToken#133:e feature(d@1_&_o@2_&_m@3)=1.0 feature(f@-3_&_r@-2_&_e@-1)=1.0 feature(e_&_d@1_&_o@2)=1.0 feature(r@-2_&_e@-1_&_e)=1.0 feature(e_&_d@1)=1.0 feature(e@-1_&_e)=1.0 feature(d@1)=1.0 feature(e)=1.0\nToken#134:d feature(o@1_&_m@2_&_,@3)=1.0 feature(r@-3_&_e@-2_&_e@-1)=1.0 feature(d_&_o@1_&_m@2)=1.0 feature(e@-2_&_e@-1_&_d)=1.0 feature(d_&_o@1)=1.0 feature(e@-1_&_d)=1.0 feature(o@1)=1.0 feature(d)=1.0\nToken#135:o feature(m@1_&_,@2_&_f@3)=1.0 feature(e@-3_&_e@-2_&_d@-1)=1.0 feature(o_&_m@1_&_,@2)=1.0 feature(e@-2_&_d@-1_&_o)=1.0 feature(o_&_m@1)=1.0 feature(d@-1_&_o)=1.0 feature(m@1)=1.0 feature(o)=1.0\nToken#136:m feature(,@1_&_f@2_&_o@3)=1.0 feature(e@-3_&_d@-2_&_o@-1)=1.0 feature(m_&_,@1_&_f@2)=1.0 feature(d@-2_&_o@-1_&_m)=1.0 feature(m_&_,@1)=1.0 feature(o@-1_&_m)=1.0 feature(,@1)=1.0 feature(m)=1.0\nToken#137:, feature(f@1_&_o@2_&_r@3)=1.0 feature(d@-3_&_o@-2_&_m@-1)=1.0 feature(,_&_f@1_&_o@2)=1.0 feature(o@-2_&_m@-1_&_,)=1.0 feature(,_&_f@1)=1.0 feature(m@-1_&_,)=1.0 feature(f@1)=1.0 feature(,)=1.0\nToken#138:f feature(o@1_&_r@2_&_t@3)=1.0 feature(o@-3_&_m@-2_&_,@-1)=1.0 feature(f_&_o@1_&_r@2)=1.0 feature(m@-2_&_,@-1_&_f)=1.0 feature(f_&_o@1)=1.0 feature(,@-1_&_f)=1.0 feature(o@1)=1.0 feature(f)=1.0\nToken#139:o feature(r@1_&_t@2_&_h@3)=1.0 feature(m@-3_&_,@-2_&_f@-1)=1.0 feature(o_&_r@1_&_t@2)=1.0 feature(,@-2_&_f@-1_&_o)=1.0 feature(o_&_r@1)=1.0 feature(f@-1_&_o)=1.0 feature(r@1)=1.0 feature(o)=1.0\nToken#140:r feature(t@1_&_h@2_&_e@3)=1.0 feature(,@-3_&_f@-2_&_o@-1)=1.0 feature(r_&_t@1_&_h@2)=1.0 feature(f@-2_&_o@-1_&_r)=1.0 feature(r_&_t@1)=1.0 feature(o@-1_&_r)=1.0 feature(t@1)=1.0 feature(r)=1.0\nToken#141:t feature(h@1_&_e@2_&_u@3)=1.0 feature(f@-3_&_o@-2_&_r@-1)=1.0 feature(t_&_h@1_&_e@2)=1.0 feature(o@-2_&_r@-1_&_t)=1.0 feature(t_&_h@1)=1.0 feature(r@-1_&_t)=1.0 feature(h@1)=1.0 feature(t)=1.0\nToken#142:h feature(e@1_&_u@2_&_s@3)=1.0 feature(o@-3_&_r@-2_&_t@-1)=1.0 feature(h_&_e@1_&_u@2)=1.0 feature(r@-2_&_t@-1_&_h)=1.0 feature(h_&_e@1)=1.0 feature(t@-1_&_h)=1.0 feature(e@1)=1.0 feature(h)=1.0\nToken#143:e feature(u@1_&_s@2_&_e@3)=1.0 feature(r@-3_&_t@-2_&_h@-1)=1.0 feature(e_&_u@1_&_s@2)=1.0 feature(t@-2_&_h@-1_&_e)=1.0 feature(e_&_u@1)=1.0 feature(h@-1_&_e)=1.0 feature(u@1)=1.0 feature(e)=1.0\nToken#144:u feature(s@1_&_e@2_&_r@3)=1.0 feature(t@-3_&_h@-2_&_e@-1)=1.0 feature(u_&_s@1_&_e@2)=1.0 feature(h@-2_&_e@-1_&_u)=1.0 feature(u_&_s@1)=1.0 feature(e@-1_&_u)=1.0 feature(s@1)=1.0 feature(u)=1.0\nToken#145:s feature(e@1_&_r@2_&_s@3)=1.0 feature(h@-3_&_e@-2_&_u@-1)=1.0 feature(s_&_e@1_&_r@2)=1.0 feature(e@-2_&_u@-1_&_s)=1.0 feature(s_&_e@1)=1.0 feature(u@-1_&_s)=1.0 feature(e@1)=1.0 feature(s)=1.0\nToken#146:e feature(r@1_&_s@2_&_o@3)=1.0 feature(e@-3_&_u@-2_&_s@-1)=1.0 feature(e_&_r@1_&_s@2)=1.0 feature(u@-2_&_s@-1_&_e)=1.0 feature(e_&_r@1)=1.0 feature(s@-1_&_e)=1.0 feature(r@1)=1.0 feature(e)=1.0\nToken#147:r feature(s@1_&_o@2_&_f@3)=1.0 feature(u@-3_&_s@-2_&_e@-1)=1.0 feature(r_&_s@1_&_o@2)=1.0 feature(s@-2_&_e@-1_&_r)=1.0 feature(r_&_s@1)=1.0 feature(e@-1_&_r)=1.0 feature(s@1)=1.0 feature(r)=1.0\nToken#148:s feature(o@1_&_f@2_&_t@3)=1.0 feature(s@-3_&_e@-2_&_r@-1)=1.0 feature(s_&_o@1_&_f@2)=1.0 feature(e@-2_&_r@-1_&_s)=1.0 feature(s_&_o@1)=1.0 feature(r@-1_&_s)=1.0 feature(o@1)=1.0 feature(s)=1.0\nToken#149:o feature(f@1_&_t@2_&_h@3)=1.0 feature(e@-3_&_r@-2_&_s@-1)=1.0 feature(o_&_f@1_&_t@2)=1.0 feature(r@-2_&_s@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(s@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#150:f feature(t@1_&_h@2_&_e@3)=1.0 feature(r@-3_&_s@-2_&_o@-1)=1.0 feature(f_&_t@1_&_h@2)=1.0 feature(s@-2_&_o@-1_&_f)=1.0 feature(f_&_t@1)=1.0 feature(o@-1_&_f)=1.0 feature(t@1)=1.0 feature(f)=1.0\nToken#151:t feature(h@1_&_e@2_&_s@3)=1.0 feature(s@-3_&_o@-2_&_f@-1)=1.0 feature(t_&_h@1_&_e@2)=1.0 feature(o@-2_&_f@-1_&_t)=1.0 feature(t_&_h@1)=1.0 feature(f@-1_&_t)=1.0 feature(h@1)=1.0 feature(t)=1.0\nToken#152:h feature(e@1_&_s@2_&_o@3)=1.0 feature(o@-3_&_f@-2_&_t@-1)=1.0 feature(h_&_e@1_&_s@2)=1.0 feature(f@-2_&_t@-1_&_h)=1.0 feature(h_&_e@1)=1.0 feature(t@-1_&_h)=1.0 feature(e@1)=1.0 feature(h)=1.0\nToken#153:e feature(s@1_&_o@2_&_f@3)=1.0 feature(f@-3_&_t@-2_&_h@-1)=1.0 feature(e_&_s@1_&_o@2)=1.0 feature(t@-2_&_h@-1_&_e)=1.0 feature(e_&_s@1)=1.0 feature(h@-1_&_e)=1.0 feature(s@1)=1.0 feature(e)=1.0\nToken#154:s feature(o@1_&_f@2_&_t@3)=1.0 feature(t@-3_&_h@-2_&_e@-1)=1.0 feature(s_&_o@1_&_f@2)=1.0 feature(h@-2_&_e@-1_&_s)=1.0 feature(s_&_o@1)=1.0 feature(e@-1_&_s)=1.0 feature(o@1)=1.0 feature(s)=1.0\nToken#155:o feature(f@1_&_t@2_&_w@3)=1.0 feature(h@-3_&_e@-2_&_s@-1)=1.0 feature(o_&_f@1_&_t@2)=1.0 feature(e@-2_&_s@-1_&_o)=1.0 feature(o_&_f@1)=1.0 feature(s@-1_&_o)=1.0 feature(f@1)=1.0 feature(o)=1.0\nToken#156:f feature(t@1_&_w@2_&_a@3)=1.0 feature(e@-3_&_s@-2_&_o@-1)=1.0 feature(f_&_t@1_&_w@2)=1.0 feature(s@-2_&_o@-1_&_f)=1.0 feature(f_&_t@1)=1.0 feature(o@-1_&_f)=1.0 feature(t@1)=1.0 feature(f)=1.0\nToken#157:t feature(w@1_&_a@2_&_r@3)=1.0 feature(s@-3_&_o@-2_&_f@-1)=1.0 feature(t_&_w@1_&_a@2)=1.0 feature(o@-2_&_f@-1_&_t)=1.0 feature(t_&_w@1)=1.0 feature(f@-1_&_t)=1.0 feature(w@1)=1.0 feature(t)=1.0\nToken#158:w feature(a@1_&_r@2_&_e@3)=1.0 feature(o@-3_&_f@-2_&_t@-1)=1.0 feature(w_&_a@1_&_r@2)=1.0 feature(f@-2_&_t@-1_&_w)=1.0 feature(w_&_a@1)=1.0 feature(t@-1_&_w)=1.0 feature(a@1)=1.0 feature(w)=1.0\nToken#159:a feature(r@1_&_e@2_&_.@3)=1.0 feature(f@-3_&_t@-2_&_w@-1)=1.0 feature(a_&_r@1_&_e@2)=1.0 feature(t@-2_&_w@-1_&_a)=1.0 feature(a_&_r@1)=1.0 feature(w@-1_&_a)=1.0 feature(r@1)=1.0 feature(a)=1.0\nToken#160:r feature(e@1_&_.@2_&_<END0>@3)=1.0 feature(t@-3_&_w@-2_&_a@-1)=1.0 feature(r_&_e@1_&_.@2)=1.0 feature(w@-2_&_a@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(a@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#161:e feature(.@1_&_<END0>@2_&_<END1>@3)=1.0 feature(w@-3_&_a@-2_&_r@-1)=1.0 feature(e_&_.@1_&_<END0>@2)=1.0 feature(a@-2_&_r@-1_&_e)=1.0 feature(e_&_.@1)=1.0 feature(r@-1_&_e)=1.0 feature(.@1)=1.0 feature(e)=1.0\nToken#162:. feature(<END0>@1_&_<END1>@2_&_<END2>@3)=1.0 feature(a@-3_&_r@-2_&_e@-1)=1.0 feature(._&_<END0>@1_&_<END1>@2)=1.0 feature(r@-2_&_e@-1_&_.)=1.0 feature(._&_<END0>@1)=1.0 feature(e@-1_&_.)=1.0 feature(<END0>@1)=1.0 feature(.)=1.0\n\ntarget: start (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\n\nname: array:1\ninput: TokenSequence edu.umass.cs.mallet.base.types.TokenSequence@58f9d3\nToken#0:t feature(h@1_&_e@2_&_f@3)=1.0 feature(<START2>@-3_&_<START1>@-2_&_<START0>@-1)=1.0 feature(t_&_h@1_&_e@2)=1.0 feature(<START1>@-2_&_<START0>@-1_&_t)=1.0 feature(t_&_h@1)=1.0 feature(<START0>@-1_&_t)=1.0 feature(h@1)=1.0 feature(t)=1.0\nToken#1:h feature(e@1_&_f@2_&_r@3)=1.0 feature(<START1>@-3_&_<START0>@-2_&_t@-1)=1.0 feature(h_&_e@1_&_f@2)=1.0 feature(<START0>@-2_&_t@-1_&_h)=1.0 feature(h_&_e@1)=1.0 feature(t@-1_&_h)=1.0 feature(e@1)=1.0 feature(h)=1.0\nToken#2:e feature(f@1_&_r@2_&_e@3)=1.0 feature(<START0>@-3_&_t@-2_&_h@-1)=1.0 feature(e_&_f@1_&_r@2)=1.0 feature(t@-2_&_h@-1_&_e)=1.0 feature(e_&_f@1)=1.0 feature(h@-1_&_e)=1.0 feature(f@1)=1.0 feature(e)=1.0\nToken#3:f feature(r@1_&_e@2_&_e@3)=1.0 feature(t@-3_&_h@-2_&_e@-1)=1.0 feature(f_&_r@1_&_e@2)=1.0 feature(h@-2_&_e@-1_&_f)=1.0 feature(f_&_r@1)=1.0 feature(e@-1_&_f)=1.0 feature(r@1)=1.0 feature(f)=1.0\nToken#4:r feature(e@1_&_e@2_&_d@3)=1.0 feature(h@-3_&_e@-2_&_f@-1)=1.0 feature(r_&_e@1_&_e@2)=1.0 feature(e@-2_&_f@-1_&_r)=1.0 feature(r_&_e@1)=1.0 feature(f@-1_&_r)=1.0 feature(e@1)=1.0 feature(r)=1.0\nToken#5:e feature(e@1_&_d@2_&_o@3)=1.0 feature(e@-3_&_f@-2_&_r@-1)=1.0 feature(e_&_e@1_&_d@2)=1.0 feature(f@-2_&_r@-1_&_e)=1.0 feature(e_&_e@1)=1.0 feature(r@-1_&_e)=1.0 feature(e@1)=1.0 feature(e)=1.0\nToken#6:e feature(d@1_&_o@2_&_m@3)=1.0 feature(f@-3_&_r@-2_&_e@-1)=1.0 feature(e_&_d@1_&_o@2)=1.0 feature(r@-2_&_e@-1_&_e)=1.0 feature(e_&_d@1)=1.0 feature(e@-1_&_e)=1.0 feature(d@1)=1.0 feature(e)=1.0\nToken#7:d feature(o@1_&_m@2_&_t@3)=1.0 feature(r@-3_&_e@-2_&_e@-1)=1.0 feature(d_&_o@1_&_m@2)=1.0 feature(e@-2_&_e@-1_&_d)=1.0 feature(d_&_o@1)=1.0 feature(e@-1_&_d)=1.0 feature(o@1)=1.0 feature(d)=1.0\nToken#8:o feature(m@1_&_t@2_&_o@3)=1.0 feature(e@-3_&_e@-2_&_d@-1)=1.0 feature(o_&_m@1_&_t@2)=1.0 feature(e@-2_&_d@-1_&_o)=1.0 feature(o_&_m@1)=1.0 feature(d@-1_&_o)=1.0 feature(m@1)=1.0 feature(o)=1.0\nToken#9:m feature(t@1_&_o@2_&_r@3)=1.0 feature(e@-3_&_d@-2_&_o@-1)=1.0 feature(m_&_t@1_&_o@2)=1.0 feature(d@-2_&_o@-1_&_m)=1.0 feature(m_&_t@1)=1.0 feature(o@-1_&_m)=1.0 feature(t@1)=1.0 feature(m)=1.0\nToken#10:t feature(o@1_&_r@2_&_u@3)=1.0 feature(d@-3_&_o@-2_&_m@-1)=1.0 feature(t_&_o@1_&_r@2)=1.0 feature(o@-2_&_m@-1_&_t)=1.0 feature(t_&_o@1)=1.0 feature(m@-1_&_t)=1.0 feature(o@1)=1.0 feature(t)=1.0\nToken#11:o feature(r@1_&_u@2_&_n@3)=1.0 feature(o@-3_&_m@-2_&_t@-1)=1.0 feature(o_&_r@1_&_u@2)=1.0 feature(m@-2_&_t@-1_&_o)=1.0 feature(o_&_r@1)=1.0 feature(t@-1_&_o)=1.0 feature(r@1)=1.0 feature(o)=1.0\nToken#12:r feature(u@1_&_n@2_&_t@3)=1.0 feature(m@-3_&_t@-2_&_o@-1)=1.0 feature(r_&_u@1_&_n@2)=1.0 feature(t@-2_&_o@-1_&_r)=1.0 feature(r_&_u@1)=1.0 feature(o@-1_&_r)=1.0 feature(u@1)=1.0 feature(r)=1.0\nToken#13:u feature(n@1_&_t@2_&_h@3)=1.0 feature(t@-3_&_o@-2_&_r@-1)=1.0 feature(u_&_n@1_&_t@2)=1.0 feature(o@-2_&_r@-1_&_u)=1.0 feature(u_&_n@1)=1.0 feature(r@-1_&_u)=1.0 feature(n@1)=1.0 feature(u)=1.0\nToken#14:n feature(t@1_&_h@2_&_e@3)=1.0 feature(o@-3_&_r@-2_&_u@-1)=1.0 feature(n_&_t@1_&_h@2)=1.0 feature(r@-2_&_u@-1_&_n)=1.0 feature(n_&_t@1)=1.0 feature(u@-1_&_n)=1.0 feature(t@1)=1.0 feature(n)=1.0\nToken#15:t feature(h@1_&_e@2_&_p@3)=1.0 feature(r@-3_&_u@-2_&_n@-1)=1.0 feature(t_&_h@1_&_e@2)=1.0 feature(u@-2_&_n@-1_&_t)=1.0 feature(t_&_h@1)=1.0 feature(n@-1_&_t)=1.0 feature(h@1)=1.0 feature(t)=1.0\nToken#16:h feature(e@1_&_p@2_&_r@3)=1.0 feature(u@-3_&_n@-2_&_t@-1)=1.0 feature(h_&_e@1_&_p@2)=1.0 feature(n@-2_&_t@-1_&_h)=1.0 feature(h_&_e@1)=1.0 feature(t@-1_&_h)=1.0 feature(e@1)=1.0 feature(h)=1.0\nToken#17:e feature(p@1_&_r@2_&_o@3)=1.0 feature(n@-3_&_t@-2_&_h@-1)=1.0 feature(e_&_p@1_&_r@2)=1.0 feature(t@-2_&_h@-1_&_e)=1.0 feature(e_&_p@1)=1.0 feature(h@-1_&_e)=1.0 feature(p@1)=1.0 feature(e)=1.0\nToken#18:p feature(r@1_&_o@2_&_g@3)=1.0 feature(t@-3_&_h@-2_&_e@-1)=1.0 feature(p_&_r@1_&_o@2)=1.0 feature(h@-2_&_e@-1_&_p)=1.0 feature(p_&_r@1)=1.0 feature(e@-1_&_p)=1.0 feature(r@1)=1.0 feature(p)=1.0\nToken#19:r feature(o@1_&_g@2_&_r@3)=1.0 feature(h@-3_&_e@-2_&_p@-1)=1.0 feature(r_&_o@1_&_g@2)=1.0 feature(e@-2_&_p@-1_&_r)=1.0 feature(r_&_o@1)=1.0 feature(p@-1_&_r)=1.0 feature(o@1)=1.0 feature(r)=1.0\nToken#20:o feature(g@1_&_r@2_&_a@3)=1.0 feature(e@-3_&_p@-2_&_r@-1)=1.0 feature(o_&_g@1_&_r@2)=1.0 feature(p@-2_&_r@-1_&_o)=1.0 feature(o_&_g@1)=1.0 feature(r@-1_&_o)=1.0 feature(g@1)=1.0 feature(o)=1.0\nToken#21:g feature(r@1_&_a@2_&_m@3)=1.0 feature(p@-3_&_r@-2_&_o@-1)=1.0 feature(g_&_r@1_&_a@2)=1.0 feature(r@-2_&_o@-1_&_g)=1.0 feature(g_&_r@1)=1.0 feature(o@-1_&_g)=1.0 feature(r@1)=1.0 feature(g)=1.0\nToken#22:r feature(a@1_&_m@2_&_,@3)=1.0 feature(r@-3_&_o@-2_&_g@-1)=1.0 feature(r_&_a@1_&_m@2)=1.0 feature(o@-2_&_g@-1_&_r)=1.0 feature(r_&_a@1)=1.0 feature(g@-1_&_r)=1.0 feature(a@1)=1.0 feature(r)=1.0\nToken#23:a feature(m@1_&_,@2_&_f@3)=1.0 feature(o@-3_&_g@-2_&_r@-1)=1.0 feature(a_&_m@1_&_,@2)=1.0 feature(g@-2_&_r@-1_&_a)=1.0 feature(a_&_m@1)=1.0 feature(r@-1_&_a)=1.0 feature(m@1)=1.0 feature(a)=1.0\nToken#24:m feature(,@1_&_f@2_&_o@3)=1.0 feature(g@-3_&_r@-2_&_a@-1)=1.0 feature(m_&_,@1_&_f@2)=1.0 feature(r@-2_&_a@-1_&_m)=1.0 feature(m_&_,@1)=1.0 feature(a@-1_&_m)=1.0 feature(,@1)=1.0 feature(m)=1.0\nToken#25:, feature(f@1_&_o@2_&_r@3)=1.0 feature(r@-3_&_a@-2_&_m@-1)=1.0 feature(,_&_f@1_&_o@2)=1.0 feature(a@-2_&_m@-1_&_,)=1.0 feature(,_&_f@1)=1.0 feature(m@-1_&_,)=1.0 feature(f@1)=1.0 feature(,)=1.0\nToken#26:f feature(o@1_&_r@2_&_a@3)=1.0 feature(a@-3_&_m@-2_&_,@-1)=1.0 feature(f_&_o@1_&_r@2)=1.0 feature(m@-2_&_,@-1_&_f)=1.0 feature(f_&_o@1)=1.0 feature(,@-1_&_f)=1.0 feature(o@1)=1.0 feature(f)=1.0\nToken#27:o feature(r@1_&_a@2_&_n@3)=1.0 feature(m@-3_&_,@-2_&_f@-1)=1.0 feature(o_&_r@1_&_a@2)=1.0 feature(,@-2_&_f@-1_&_o)=1.0 feature(o_&_r@1)=1.0 feature(f@-1_&_o)=1.0 feature(r@1)=1.0 feature(o)=1.0\nToken#28:r feature(a@1_&_n@2_&_y@3)=1.0 feature(,@-3_&_f@-2_&_o@-1)=1.0 feature(r_&_a@1_&_n@2)=1.0 feature(f@-2_&_o@-1_&_r)=1.0 feature(r_&_a@1)=1.0 feature(o@-1_&_r)=1.0 feature(a@1)=1.0 feature(r)=1.0\nToken#29:a feature(n@1_&_y@2_&_p@3)=1.0 feature(f@-3_&_o@-2_&_r@-1)=1.0 feature(a_&_n@1_&_y@2)=1.0 feature(o@-2_&_r@-1_&_a)=1.0 feature(a_&_n@1)=1.0 feature(r@-1_&_a)=1.0 feature(n@1)=1.0 feature(a)=1.0\nToken#30:n feature(y@1_&_p@2_&_u@3)=1.0 feature(o@-3_&_r@-2_&_a@-1)=1.0 feature(n_&_y@1_&_p@2)=1.0 feature(r@-2_&_a@-1_&_n)=1.0 feature(n_&_y@1)=1.0 feature(a@-1_&_n)=1.0 feature(y@1)=1.0 feature(n)=1.0\nToken#31:y feature(p@1_&_u@2_&_r@3)=1.0 feature(r@-3_&_a@-2_&_n@-1)=1.0 feature(y_&_p@1_&_u@2)=1.0 feature(a@-2_&_n@-1_&_y)=1.0 feature(y_&_p@1)=1.0 feature(n@-1_&_y)=1.0 feature(p@1)=1.0 feature(y)=1.0\nToken#32:p feature(u@1_&_r@2_&_p@3)=1.0 feature(a@-3_&_n@-2_&_y@-1)=1.0 feature(p_&_u@1_&_r@2)=1.0 feature(n@-2_&_y@-1_&_p)=1.0 feature(p_&_u@1)=1.0 feature(y@-1_&_p)=1.0 feature(u@1)=1.0 feature(p)=1.0\nToken#33:u feature(r@1_&_p@2_&_o@3)=1.0 feature(n@-3_&_y@-2_&_p@-1)=1.0 feature(u_&_r@1_&_p@2)=1.0 feature(y@-2_&_p@-1_&_u)=1.0 feature(u_&_r@1)=1.0 feature(p@-1_&_u)=1.0 feature(r@1)=1.0 feature(u)=1.0\nToken#34:r feature(p@1_&_o@2_&_s@3)=1.0 feature(y@-3_&_p@-2_&_u@-1)=1.0 feature(r_&_p@1_&_o@2)=1.0 feature(p@-2_&_u@-1_&_r)=1.0 feature(r_&_p@1)=1.0 feature(u@-1_&_r)=1.0 feature(p@1)=1.0 feature(r)=1.0\nToken#35:p feature(o@1_&_s@2_&_e@3)=1.0 feature(p@-3_&_u@-2_&_r@-1)=1.0 feature(p_&_o@1_&_s@2)=1.0 feature(u@-2_&_r@-1_&_p)=1.0 feature(p_&_o@1)=1.0 feature(r@-1_&_p)=1.0 feature(o@1)=1.0 feature(p)=1.0\nToken#36:o feature(s@1_&_e@2_&_.@3)=1.0 feature(u@-3_&_r@-2_&_p@-1)=1.0 feature(o_&_s@1_&_e@2)=1.0 feature(r@-2_&_p@-1_&_o)=1.0 feature(o_&_s@1)=1.0 feature(p@-1_&_o)=1.0 feature(s@1)=1.0 feature(o)=1.0\nToken#37:s feature(e@1_&_.@2_&_<END0>@3)=1.0 feature(r@-3_&_p@-2_&_o@-1)=1.0 feature(s_&_e@1_&_.@2)=1.0 feature(p@-2_&_o@-1_&_s)=1.0 feature(s_&_e@1)=1.0 feature(o@-1_&_s)=1.0 feature(e@1)=1.0 feature(s)=1.0\nToken#38:e feature(.@1_&_<END0>@2_&_<END1>@3)=1.0 feature(p@-3_&_o@-2_&_s@-1)=1.0 feature(e_&_.@1_&_<END0>@2)=1.0 feature(o@-2_&_s@-1_&_e)=1.0 feature(e_&_.@1)=1.0 feature(s@-1_&_e)=1.0 feature(.@1)=1.0 feature(e)=1.0\nToken#39:. feature(<END0>@1_&_<END1>@2_&_<END2>@3)=1.0 feature(o@-3_&_s@-2_&_e@-1)=1.0 feature(._&_<END0>@1_&_<END1>@2)=1.0 feature(s@-2_&_e@-1_&_.)=1.0 feature(._&_<END0>@1)=1.0 feature(e@-1_&_.)=1.0 feature(<END0>@1)=1.0 feature(.)=1.0\n\ntarget: start (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nstart (0)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\nnotstart (1)\n\n";

	public void testSpacePipe () {
		Pipe p = new SerialPipes (new Pipe[] {
			new CharSequence2TokenSequence ("."),
			new TokenSequenceLowercase (),
			new TestCRF.TestCRFTokenSequenceRemoveSpaces (),
			new TokenText (),
			new OffsetConjunctions (false,
															new int[][] {{0},
																					 {1},{-1,0},{0,1},
																					 {-2,-1,0}, {0,1,2}, {-3,-2,-1}, {1,2,3},
															}),
			new PrintInputAndTarget(),
		});

		// Print to a string
		ByteArrayOutputStream out = new ByteArrayOutputStream ();
		PrintStream oldOut = System.out;
		System.setOut (new PrintStream (out));

		InstanceList lst = new InstanceList (p);
		lst.addThruPipe (new ArrayIterator (new String[] { TestCRF.data[0], 
																							 TestCRF.data[1], }));

		System.setOut (oldOut);
		
		assertEquals (spacePipeOutput, out.toString());
	}

/**
 * @return a <code>TestSuite</code>
 */
	public static TestSuite suite() {
		return new TestSuite (TestSpacePipe.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}// TestSpacePipe
