/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.princeton.file.AbstractPrincetonRandomAccessDictionaryFile;

public class PrincetonRandomAccessDictionaryFile
extends AbstractPrincetonRandomAccessDictionaryFile {
    public static final String READ_ONLY = "r";
    public static final String READ_WRITE = "rw";
    private RandomAccessFile _file = null;
    protected String _permissions;

    public DictionaryFile newInstance(String path, POS pos, DictionaryFileType fileType) {
        return new PrincetonRandomAccessDictionaryFile(path, pos, fileType);
    }

    public PrincetonRandomAccessDictionaryFile() {
    }

    public PrincetonRandomAccessDictionaryFile(String path, POS pos, DictionaryFileType fileType) {
        this(path, pos, fileType, READ_ONLY);
    }

    public PrincetonRandomAccessDictionaryFile(String path, POS pos, DictionaryFileType fileType, String permissions) {
        super(path, pos, fileType);
        this._permissions = permissions;
    }

    public String readLine() throws IOException {
        if (this.isOpen()) {
            return this._file.readLine();
        }
        throw new JWNLRuntimeException("PRINCETON_EXCEPTION_001");
    }

    public void seek(long pos) throws IOException {
        this._file.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this._file.getFilePointer();
    }

    public boolean isOpen() {
        return this._file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this._file.close();
        }
        catch (Exception exception) {
        }
        finally {
            this._file = null;
        }
    }

    protected void openFile(File path) throws IOException {
        this._file = new RandomAccessFile(path, this._permissions);
    }

    public long length() throws IOException {
        return this._file.length();
    }

    public int read() throws IOException {
        return this._file.read();
    }
}

