/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmDenseMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UpperSymmDenseMatrix
extends AbstractSymmDenseMatrix {
    public UpperSymmDenseMatrix(int n) {
        super(n, BLASkernel.UpLo.Upper);
    }

    public UpperSymmDenseMatrix(Matrix A) {
        this(A, true);
    }

    public UpperSymmDenseMatrix(Matrix A, boolean deep) {
        super(A, deep, BLASkernel.UpLo.Upper);
    }

    public void add(int row, int column, double value) {
        if (row <= column) {
            super.add(row, column, value);
        }
    }

    public double get(int row, int column) {
        if (row > column) {
            return super.get(column, row);
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (row <= column) {
            super.set(row, column, value);
        }
    }

    public UpperSymmDenseMatrix copy() {
        return new UpperSymmDenseMatrix(this);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }
}

