/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;
import java.util.Collection;

public class CPT
implements DiscreteFactor {
    private DiscreteFactor subFactor;
    private VarSet parents;
    private Variable child;

    public CPT(DiscreteFactor subFactor, Variable child) {
        this.subFactor = subFactor;
        this.child = child;
        if (!subFactor.containsVar(child)) {
            throw new IllegalArgumentException("Invalid child var for CPT\n  Child: " + child + "\n  Factor: " + subFactor);
        }
        this.parents = new HashVarSet(subFactor.varSet());
        this.parents.remove(child);
    }

    public VarSet getParents() {
        return this.parents;
    }

    public Variable getChild() {
        return this.child;
    }

    public void setSubFactor(DiscreteFactor subFactor) {
        this.subFactor = subFactor;
    }

    public String toString() {
        return "CPT: Child [" + this.child + "]\n  Factor: " + this.subFactor.toString();
    }

    @Override
    public String prettyOutputString() {
        return this.toString();
    }

    @Override
    public double value(Assignment assn) {
        return this.subFactor.value(assn);
    }

    @Override
    public double value(AssignmentIterator it) {
        return this.subFactor.value(it);
    }

    @Override
    public Factor normalize() {
        return this.subFactor.normalize();
    }

    @Override
    public Factor marginalize(Variable[] vars) {
        return this.subFactor.marginalize(vars);
    }

    @Override
    public Factor marginalize(Collection vars) {
        return this.subFactor.marginalize(vars);
    }

    @Override
    public Factor marginalize(Variable var) {
        return this.subFactor.marginalize(var);
    }

    @Override
    public Factor marginalizeOut(Variable var) {
        return this.subFactor.marginalizeOut(var);
    }

    @Override
    public Factor extractMax(Collection vars) {
        return this.subFactor.extractMax(vars);
    }

    @Override
    public Factor extractMax(Variable var) {
        return this.subFactor.extractMax(var);
    }

    @Override
    public Factor extractMax(Variable[] vars) {
        return this.subFactor.extractMax(vars);
    }

    @Override
    public int argmax() {
        return this.subFactor.argmax();
    }

    @Override
    public Assignment sample(Randoms r) {
        return this.subFactor.sample(r);
    }

    @Override
    public double sum() {
        return this.subFactor.sum();
    }

    @Override
    public double entropy() {
        return this.subFactor.entropy();
    }

    @Override
    public Factor multiply(Factor dist) {
        return this.subFactor.multiply(dist);
    }

    @Override
    public void multiplyBy(Factor pot) {
        this.subFactor.multiplyBy(pot);
    }

    @Override
    public void exponentiate(double power) {
        this.subFactor.exponentiate(power);
    }

    @Override
    public void divideBy(Factor pot) {
        this.subFactor.divideBy(pot);
    }

    @Override
    public boolean containsVar(Variable var) {
        return this.subFactor.containsVar(var);
    }

    @Override
    public VarSet varSet() {
        return this.subFactor.varSet();
    }

    @Override
    public AssignmentIterator assignmentIterator() {
        return this.subFactor.assignmentIterator();
    }

    @Override
    public boolean almostEquals(Factor p) {
        return this.subFactor.almostEquals(p);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.subFactor.almostEquals(p, epsilon);
    }

    @Override
    public Factor duplicate() {
        return this.subFactor.duplicate();
    }

    @Override
    public boolean isNaN() {
        return this.subFactor.isNaN();
    }

    @Override
    public double logValue(AssignmentIterator it) {
        return this.subFactor.logValue(it);
    }

    @Override
    public double logValue(Assignment assn) {
        return this.subFactor.logValue(assn);
    }

    @Override
    public double logValue(int loc) {
        return this.subFactor.logValue(loc);
    }

    @Override
    public Variable getVariable(int i) {
        return this.subFactor.getVariable(i);
    }

    @Override
    public int sampleLocation(Randoms r) {
        return this.subFactor.sampleLocation(r);
    }

    @Override
    public double value(int index) {
        return this.subFactor.value(index);
    }

    @Override
    public int numLocations() {
        return this.subFactor.numLocations();
    }

    @Override
    public double valueAtLocation(int loc) {
        return this.subFactor.valueAtLocation(loc);
    }

    @Override
    public int indexAtLocation(int loc) {
        return this.subFactor.indexAtLocation(loc);
    }

    @Override
    public double[] toValueArray() {
        return this.subFactor.toValueArray();
    }

    @Override
    public int singleIndex(int[] smallDims) {
        return this.subFactor.singleIndex(smallDims);
    }

    @Override
    public String dumpToString() {
        return this.subFactor.dumpToString();
    }

    @Override
    public Factor slice(Assignment assn) {
        return this.subFactor.slice(assn);
    }

    @Override
    public AbstractTableFactor asTable() {
        return this.subFactor.asTable();
    }

    @Override
    public Factor marginalizeOut(VarSet varset) {
        return this.subFactor.marginalizeOut(varset);
    }
}

