/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.base.Preconditions;
import org.apache.mahout.common.RandomUtils;

public final class WeightedThing<T>
implements Comparable<WeightedThing<T>> {
    private double weight;
    private final T value;

    public WeightedThing(T thing, double weight) {
        this.value = Preconditions.checkNotNull(thing);
        this.weight = weight;
    }

    public WeightedThing(double weight) {
        this.value = null;
        this.weight = weight;
    }

    public T getValue() {
        return this.value;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public int compareTo(WeightedThing<T> other) {
        return Double.compare(this.weight, other.weight);
    }

    public boolean equals(Object o) {
        if (o instanceof WeightedThing) {
            WeightedThing other = (WeightedThing)o;
            return this.weight == other.weight && this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return 31 * RandomUtils.hashDouble(this.weight) + this.value.hashCode();
    }
}

