/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;

public class PermutedVectorView
extends AbstractVector {
    private final Vector vector;
    private final int[] pivot;
    private final int[] unpivot;

    public PermutedVectorView(Vector vector, int[] pivot, int[] unpivot) {
        super(vector.size());
        this.vector = vector;
        this.pivot = pivot;
        this.unpivot = unpivot;
    }

    public PermutedVectorView(Vector vector, int[] pivot) {
        this(vector, pivot, PermutedVectorView.reversePivotPermutation(pivot));
    }

    private static int[] reversePivotPermutation(int[] pivot) {
        int[] unpivot1 = new int[pivot.length];
        for (int i = 0; i < pivot.length; ++i) {
            unpivot1[pivot[i]] = i;
        }
        return unpivot1;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        if (this.vector.isDense()) {
            return new DenseMatrix(rows, columns);
        }
        return new SparseRowMatrix(rows, columns);
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        for (int i = 0; i < updates.getNumMappings(); ++i) {
            updates.setIndexAt(i, this.pivot[updates.indexAt(i)]);
        }
        this.vector.mergeUpdates(updates);
    }

    @Override
    public boolean isDense() {
        return this.vector.isDense();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AbstractIterator<Vector.Element>(){
            private final Iterator<Vector.Element> i;
            {
                this.i = PermutedVectorView.this.vector.all().iterator();
            }

            protected Vector.Element computeNext() {
                if (this.i.hasNext()) {
                    final Vector.Element x = this.i.next();
                    return new Vector.Element(){
                        private final int index;
                        {
                            this.index = PermutedVectorView.this.unpivot[x.index()];
                        }

                        @Override
                        public double get() {
                            return x.get();
                        }

                        @Override
                        public int index() {
                            return this.index;
                        }

                        @Override
                        public void set(double value) {
                            x.set(value);
                        }
                    };
                }
                return (Vector.Element)this.endOfData();
            }
        };
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new AbstractIterator<Vector.Element>(){
            private final Iterator<Vector.Element> i;
            {
                this.i = PermutedVectorView.this.vector.nonZeroes().iterator();
            }

            protected Vector.Element computeNext() {
                if (this.i.hasNext()) {
                    final Vector.Element x = this.i.next();
                    return new Vector.Element(){
                        private final int index;
                        {
                            this.index = PermutedVectorView.this.unpivot[x.index()];
                        }

                        @Override
                        public double get() {
                            return x.get();
                        }

                        @Override
                        public int index() {
                            return this.index;
                        }

                        @Override
                        public void set(double value) {
                            x.set(value);
                        }
                    };
                }
                return (Vector.Element)this.endOfData();
            }
        };
    }

    @Override
    public double getQuick(int index) {
        return this.vector.getQuick(this.pivot[index]);
    }

    @Override
    public Vector like() {
        return this.vector.like();
    }

    @Override
    public void setQuick(int index, double value) {
        this.vector.setQuick(this.pivot[index], value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.vector.getNumNondefaultElements();
    }

    @Override
    public double getLookupCost() {
        return this.vector.getLookupCost();
    }

    @Override
    public double getIteratorAdvanceCost() {
        return this.vector.getIteratorAdvanceCost();
    }

    @Override
    public boolean isAddConstantTime() {
        return this.vector.isAddConstantTime();
    }
}

