/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;

public class DenseVector
extends AbstractVector {
    private double[] values;

    public DenseVector() {
        super(0);
    }

    public DenseVector(double[] values) {
        this(values, false);
    }

    public DenseVector(double[] values, boolean shallowCopy) {
        super(values.length);
        this.values = shallowCopy ? values : (double[])values.clone();
    }

    public DenseVector(DenseVector values, boolean shallowCopy) {
        this(values.values, shallowCopy);
    }

    public DenseVector(int cardinality) {
        super(cardinality);
        this.values = new double[cardinality];
    }

    public DenseVector(Vector vector) {
        super(vector.size());
        this.values = new double[vector.size()];
        for (Vector.Element e : vector.nonZeroes()) {
            this.values[e.index()] = e.get();
        }
    }

    @Override
    public double dot(Vector x) {
        if (!x.isDense()) {
            return super.dot(x);
        }
        int size = x.size();
        if (this.values.length != size) {
            throw new CardinalityException(this.values.length, size);
        }
        double sum = 0.0;
        for (int n = 0; n < size; ++n) {
            sum += this.values[n] * x.getQuick(n);
        }
        return sum;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public DenseVector clone() {
        return new DenseVector((double[])this.values.clone());
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    protected double dotSelf() {
        double result = 0.0;
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            result += this.values[i] * this.values[i];
        }
        return result;
    }

    @Override
    public double getQuick(int index) {
        return this.values[index];
    }

    @Override
    public DenseVector like() {
        return new DenseVector(this.size());
    }

    @Override
    public void setQuick(int index, double value) {
        this.invalidateCachedLength();
        this.values[index] = value;
    }

    @Override
    public void incrementQuick(int index, double increment) {
        this.invalidateCachedLength();
        int n = index;
        this.values[n] = this.values[n] + increment;
    }

    @Override
    public Vector assign(double value) {
        this.invalidateCachedLength();
        Arrays.fill(this.values, value);
        return this;
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.length;
    }

    public Vector assign(DenseVector vector) {
        if (vector.values.length != this.values.length) {
            this.values = new double[vector.values.length];
        }
        System.arraycopy(vector.values, 0, this.values, 0, this.values.length);
        return this;
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        int numUpdates = updates.getNumMappings();
        int[] indices = updates.getIndices();
        double[] values = updates.getValues();
        for (int i = 0; i < numUpdates; ++i) {
            this.values[indices[i]] = values[i];
        }
    }

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size());
        }
        if (offset + length > this.size()) {
            throw new IndexException(offset + length, this.size());
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.0;
    }

    @Override
    public boolean isAddConstantTime() {
        return true;
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DenseVector) {
            return Arrays.equals(this.values, ((DenseVector)o).values);
        }
        return super.equals(o);
    }

    public void addAll(Vector v) {
        if (this.size() != v.size()) {
            throw new CardinalityException(this.size(), v.size());
        }
        for (Vector.Element element : v.nonZeroes()) {
            int n = element.index();
            this.values[n] = this.values[n] + element.get();
        }
    }

    private final class DenseElement
    implements Vector.Element {
        int index;

        private DenseElement() {
        }

        @Override
        public double get() {
            return DenseVector.this.values[this.index];
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            DenseVector.this.invalidateCachedLength();
            ((DenseVector)DenseVector.this).values[this.index] = value;
        }
    }

    private final class AllIterator
    implements Iterator<Vector.Element> {
        private final DenseElement element;

        private AllIterator() {
            this.element = new DenseElement();
            this.element.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.element.index + 1 < DenseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (this.element.index + 1 >= DenseVector.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.element.index;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class NonDefaultIterator
    implements Iterator<Vector.Element> {
        private final DenseElement element;
        private int index;
        private int lookAheadIndex;

        private NonDefaultIterator() {
            this.element = new DenseElement();
            this.index = -1;
            this.lookAheadIndex = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.lookAheadIndex == this.index) {
                this.lookAhead();
            }
            return this.lookAheadIndex < DenseVector.this.size();
        }

        private void lookAhead() {
            ++this.lookAheadIndex;
            while (this.lookAheadIndex < DenseVector.this.size() && DenseVector.this.values[this.lookAheadIndex] == 0.0) {
                ++this.lookAheadIndex;
            }
        }

        @Override
        public Vector.Element next() {
            if (this.lookAheadIndex == this.index) {
                this.lookAhead();
            }
            Preconditions.checkState((this.lookAheadIndex > this.index ? 1 : 0) != 0);
            this.index = this.lookAheadIndex;
            if (this.index >= DenseVector.this.size()) {
                throw new NoSuchElementException();
            }
            this.element.index = this.index;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

