/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;

public class ConstantVector
extends AbstractVector {
    private final double value;

    public ConstantVector(double value, int size) {
        super(size);
        this.value = value;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        throw new UnsupportedOperationException("Cannot mutate a ConstantVector");
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AbstractIterator<Vector.Element>(){
            private int i = 0;
            private final int n = ConstantVector.this.size();

            protected Vector.Element computeNext() {
                if (this.i < this.n) {
                    return new AbstractVector.LocalElement(this.i++);
                }
                return (Vector.Element)this.endOfData();
            }
        };
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return this.iterator();
    }

    @Override
    public double getQuick(int index) {
        return this.value;
    }

    @Override
    public Vector like() {
        return new DenseVector(this.size());
    }

    @Override
    public void setQuick(int index, double value) {
        throw new UnsupportedOperationException("Can't set a value in a constant matrix");
    }

    @Override
    public int getNumNondefaultElements() {
        return this.size();
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.0;
    }

    @Override
    public boolean isAddConstantTime() {
        throw new UnsupportedOperationException("Cannot mutate a ConstantVector");
    }
}

