/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Method;
import java.util.Comparator;
import org.easymock.Capture;
import org.easymock.ConstructorArgs;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.LogicalOperator;
import org.easymock.MockType;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MockBuilder;
import org.easymock.internal.MocksControl;
import org.easymock.internal.matchers.Any;
import org.easymock.internal.matchers.ArrayEquals;
import org.easymock.internal.matchers.Captures;
import org.easymock.internal.matchers.Compare;
import org.easymock.internal.matchers.CompareEqual;
import org.easymock.internal.matchers.Contains;
import org.easymock.internal.matchers.EndsWith;
import org.easymock.internal.matchers.Equals;
import org.easymock.internal.matchers.EqualsWithDelta;
import org.easymock.internal.matchers.Find;
import org.easymock.internal.matchers.GreaterOrEqual;
import org.easymock.internal.matchers.GreaterThan;
import org.easymock.internal.matchers.InstanceOf;
import org.easymock.internal.matchers.LessOrEqual;
import org.easymock.internal.matchers.LessThan;
import org.easymock.internal.matchers.Matches;
import org.easymock.internal.matchers.NotNull;
import org.easymock.internal.matchers.Null;
import org.easymock.internal.matchers.Same;
import org.easymock.internal.matchers.StartsWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMock {
    public static final String ENABLE_THREAD_SAFETY_CHECK_BY_DEFAULT = "easymock.enableThreadSafetyCheckByDefault";
    public static final String NOT_THREAD_SAFE_BY_DEFAULT = "easymock.notThreadSafeByDefault";
    public static final String DISABLE_CLASS_MOCKING = "easymock.disableClassMocking";

    public static <T> T createMock(MockType type, Class<T> toMock) {
        return EasyMock.createControl(type).createMock(toMock);
    }

    public static <T> T createMock(String name, MockType type, Class<T> toMock) {
        return EasyMock.createControl(type).createMock(name, toMock);
    }

    public static <T> T createStrictMock(Class<T> toMock) {
        return EasyMock.createStrictControl().createMock(toMock);
    }

    public static <T> T createStrictMock(String name, Class<T> toMock) {
        return EasyMock.createStrictControl().createMock(name, toMock);
    }

    public static <T> T createMock(Class<T> toMock) {
        return EasyMock.createControl().createMock(toMock);
    }

    public static <T> T createMock(String name, Class<T> toMock) {
        return EasyMock.createControl().createMock(name, toMock);
    }

    public static <T> T createNiceMock(Class<T> toMock) {
        return EasyMock.createNiceControl().createMock(toMock);
    }

    public static <T> T createNiceMock(String name, Class<T> toMock) {
        return EasyMock.createNiceControl().createMock(name, toMock);
    }

    @Deprecated
    public static <T> T createStrictMock(Class<T> toMock, Method ... mockedMethods) {
        return EasyMock.createStrictControl().createMock(toMock, mockedMethods);
    }

    @Deprecated
    public static <T> T createStrictMock(String name, Class<T> toMock, Method ... mockedMethods) {
        return EasyMock.createStrictControl().createMock(name, toMock, mockedMethods);
    }

    @Deprecated
    public static <T> T createStrictMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return EasyMock.createStrictControl().createMock(toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public static <T> T createStrictMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return EasyMock.createStrictControl().createMock(name, toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public static <T> T createMock(Class<T> toMock, Method ... mockedMethods) {
        return EasyMock.createControl().createMock(toMock, mockedMethods);
    }

    @Deprecated
    public static <T> T createMock(String name, Class<T> toMock, Method ... mockedMethods) {
        return EasyMock.createControl().createMock(name, toMock, mockedMethods);
    }

    @Deprecated
    public static <T> T createMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return EasyMock.createControl().createMock(toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public static <T> T createMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return EasyMock.createControl().createMock(name, toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public static <T> T createNiceMock(Class<T> toMock, Method ... mockedMethods) {
        return EasyMock.createNiceControl().createMock(toMock, mockedMethods);
    }

    @Deprecated
    public static <T> T createNiceMock(String name, Class<T> toMock, Method ... mockedMethods) {
        return EasyMock.createNiceControl().createMock(name, toMock, mockedMethods);
    }

    @Deprecated
    public static <T> T createNiceMock(Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return EasyMock.createNiceControl().createMock(toMock, constructorArgs, mockedMethods);
    }

    @Deprecated
    public static <T> T createNiceMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        return EasyMock.createNiceControl().createMock(name, toMock, constructorArgs, mockedMethods);
    }

    public static <T> IMockBuilder<T> createMockBuilder(Class<T> toMock) {
        return new MockBuilder<T>(toMock);
    }

    public static IMocksControl createControl(MockType type) {
        return new MocksControl(type);
    }

    public static IMocksControl createStrictControl() {
        return EasyMock.createControl(MockType.STRICT);
    }

    public static IMocksControl createControl() {
        return EasyMock.createControl(MockType.DEFAULT);
    }

    public static IMocksControl createNiceControl() {
        return EasyMock.createControl(MockType.NICE);
    }

    public static <T> IExpectationSetters<T> expect(T value) {
        return EasyMock.getControlForLastCall();
    }

    public static <T> IExpectationSetters<T> expectLastCall() {
        return EasyMock.getControlForLastCall();
    }

    private static <T> IExpectationSetters<T> getControlForLastCall() {
        MocksControl lastControl = LastControl.lastControl();
        if (lastControl == null) {
            LastControl.pullMatchers();
            throw new IllegalStateException("no last call on a mock available");
        }
        return lastControl;
    }

    public static boolean anyBoolean() {
        EasyMock.reportMatcher(Any.ANY);
        return false;
    }

    public static byte anyByte() {
        EasyMock.reportMatcher(Any.ANY);
        return 0;
    }

    public static char anyChar() {
        EasyMock.reportMatcher(Any.ANY);
        return '\u0000';
    }

    public static int anyInt() {
        EasyMock.reportMatcher(Any.ANY);
        return 0;
    }

    public static long anyLong() {
        EasyMock.reportMatcher(Any.ANY);
        return 0L;
    }

    public static float anyFloat() {
        EasyMock.reportMatcher(Any.ANY);
        return 0.0f;
    }

    public static double anyDouble() {
        EasyMock.reportMatcher(Any.ANY);
        return 0.0;
    }

    public static short anyShort() {
        EasyMock.reportMatcher(Any.ANY);
        return 0;
    }

    public static <T> T anyObject() {
        EasyMock.reportMatcher(Any.ANY);
        return null;
    }

    public static <T> T anyObject(Class<T> clazz) {
        EasyMock.reportMatcher(Any.ANY);
        return null;
    }

    public static String anyString() {
        return (String)EasyMock.anyObject();
    }

    public static <T extends Comparable<T>> T geq(Comparable<T> value) {
        EasyMock.reportMatcher(new GreaterOrEqual<T>(value));
        return null;
    }

    public static byte geq(byte value) {
        EasyMock.reportMatcher(new GreaterOrEqual<Byte>(Byte.valueOf(value)));
        return 0;
    }

    public static double geq(double value) {
        EasyMock.reportMatcher(new GreaterOrEqual<Double>(Double.valueOf(value)));
        return 0.0;
    }

    public static float geq(float value) {
        EasyMock.reportMatcher(new GreaterOrEqual<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int geq(int value) {
        EasyMock.reportMatcher(new GreaterOrEqual<Integer>(Integer.valueOf(value)));
        return 0;
    }

    public static long geq(long value) {
        EasyMock.reportMatcher(new GreaterOrEqual<Long>(Long.valueOf(value)));
        return 0L;
    }

    public static short geq(short value) {
        EasyMock.reportMatcher(new GreaterOrEqual<Short>(Short.valueOf(value)));
        return 0;
    }

    public static <T extends Comparable<T>> T leq(Comparable<T> value) {
        EasyMock.reportMatcher(new LessOrEqual<T>(value));
        return null;
    }

    public static byte leq(byte value) {
        EasyMock.reportMatcher(new LessOrEqual<Byte>(Byte.valueOf(value)));
        return 0;
    }

    public static double leq(double value) {
        EasyMock.reportMatcher(new LessOrEqual<Double>(Double.valueOf(value)));
        return 0.0;
    }

    public static float leq(float value) {
        EasyMock.reportMatcher(new LessOrEqual<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int leq(int value) {
        EasyMock.reportMatcher(new LessOrEqual<Integer>(Integer.valueOf(value)));
        return 0;
    }

    public static long leq(long value) {
        EasyMock.reportMatcher(new LessOrEqual<Long>(Long.valueOf(value)));
        return 0L;
    }

    public static short leq(short value) {
        EasyMock.reportMatcher(new LessOrEqual<Short>(Short.valueOf(value)));
        return 0;
    }

    public static <T extends Comparable<T>> T gt(Comparable<T> value) {
        EasyMock.reportMatcher(new GreaterThan<T>(value));
        return null;
    }

    public static byte gt(byte value) {
        EasyMock.reportMatcher(new GreaterThan<Byte>(Byte.valueOf(value)));
        return 0;
    }

    public static double gt(double value) {
        EasyMock.reportMatcher(new GreaterThan<Double>(Double.valueOf(value)));
        return 0.0;
    }

    public static float gt(float value) {
        EasyMock.reportMatcher(new GreaterThan<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int gt(int value) {
        EasyMock.reportMatcher(new GreaterThan<Integer>(Integer.valueOf(value)));
        return 0;
    }

    public static long gt(long value) {
        EasyMock.reportMatcher(new GreaterThan<Long>(Long.valueOf(value)));
        return 0L;
    }

    public static short gt(short value) {
        EasyMock.reportMatcher(new GreaterThan<Short>(Short.valueOf(value)));
        return 0;
    }

    public static <T extends Comparable<T>> T lt(Comparable<T> value) {
        EasyMock.reportMatcher(new LessThan<T>(value));
        return null;
    }

    public static byte lt(byte value) {
        EasyMock.reportMatcher(new LessThan<Byte>(Byte.valueOf(value)));
        return 0;
    }

    public static double lt(double value) {
        EasyMock.reportMatcher(new LessThan<Double>(Double.valueOf(value)));
        return 0.0;
    }

    public static float lt(float value) {
        EasyMock.reportMatcher(new LessThan<Float>(Float.valueOf(value)));
        return 0.0f;
    }

    public static int lt(int value) {
        EasyMock.reportMatcher(new LessThan<Integer>(Integer.valueOf(value)));
        return 0;
    }

    public static long lt(long value) {
        EasyMock.reportMatcher(new LessThan<Long>(Long.valueOf(value)));
        return 0L;
    }

    public static short lt(short value) {
        EasyMock.reportMatcher(new LessThan<Short>(Short.valueOf(value)));
        return 0;
    }

    public static <T> T isA(Class<T> clazz) {
        EasyMock.reportMatcher(new InstanceOf(clazz));
        return null;
    }

    public static String contains(String substring) {
        EasyMock.reportMatcher(new Contains(substring));
        return null;
    }

    public static boolean and(boolean first, boolean second) {
        LastControl.reportAnd(2);
        return false;
    }

    public static byte and(byte first, byte second) {
        LastControl.reportAnd(2);
        return 0;
    }

    public static char and(char first, char second) {
        LastControl.reportAnd(2);
        return '\u0000';
    }

    public static double and(double first, double second) {
        LastControl.reportAnd(2);
        return 0.0;
    }

    public static float and(float first, float second) {
        LastControl.reportAnd(2);
        return 0.0f;
    }

    public static int and(int first, int second) {
        LastControl.reportAnd(2);
        return 0;
    }

    public static long and(long first, long second) {
        LastControl.reportAnd(2);
        return 0L;
    }

    public static short and(short first, short second) {
        LastControl.reportAnd(2);
        return 0;
    }

    public static <T> T and(T first, T second) {
        LastControl.reportAnd(2);
        return null;
    }

    public static boolean or(boolean first, boolean second) {
        LastControl.reportOr(2);
        return false;
    }

    public static byte or(byte first, byte second) {
        LastControl.reportOr(2);
        return 0;
    }

    public static char or(char first, char second) {
        LastControl.reportOr(2);
        return '\u0000';
    }

    public static double or(double first, double second) {
        LastControl.reportOr(2);
        return 0.0;
    }

    public static float or(float first, float second) {
        LastControl.reportOr(2);
        return 0.0f;
    }

    public static int or(int first, int second) {
        LastControl.reportOr(2);
        return first;
    }

    public static long or(long first, long second) {
        LastControl.reportOr(2);
        return 0L;
    }

    public static short or(short first, short second) {
        LastControl.reportOr(2);
        return 0;
    }

    public static <T> T or(T first, T second) {
        LastControl.reportOr(2);
        return null;
    }

    public static boolean not(boolean first) {
        LastControl.reportNot();
        return false;
    }

    public static byte not(byte first) {
        LastControl.reportNot();
        return 0;
    }

    public static char not(char first) {
        LastControl.reportNot();
        return '\u0000';
    }

    public static double not(double first) {
        LastControl.reportNot();
        return 0.0;
    }

    public static float not(float first) {
        LastControl.reportNot();
        return first;
    }

    public static int not(int first) {
        LastControl.reportNot();
        return 0;
    }

    public static long not(long first) {
        LastControl.reportNot();
        return 0L;
    }

    public static short not(short first) {
        LastControl.reportNot();
        return 0;
    }

    public static <T> T not(T first) {
        LastControl.reportNot();
        return null;
    }

    public static boolean eq(boolean value) {
        EasyMock.reportMatcher(new Equals(value));
        return false;
    }

    public static byte eq(byte value) {
        EasyMock.reportMatcher(new Equals(value));
        return 0;
    }

    public static char eq(char value) {
        EasyMock.reportMatcher(new Equals(Character.valueOf(value)));
        return '\u0000';
    }

    public static double eq(double value) {
        EasyMock.reportMatcher(new Equals(value));
        return 0.0;
    }

    public static float eq(float value) {
        EasyMock.reportMatcher(new Equals(Float.valueOf(value)));
        return 0.0f;
    }

    public static int eq(int value) {
        EasyMock.reportMatcher(new Equals(value));
        return 0;
    }

    public static long eq(long value) {
        EasyMock.reportMatcher(new Equals(value));
        return 0L;
    }

    public static short eq(short value) {
        EasyMock.reportMatcher(new Equals(value));
        return 0;
    }

    public static <T> T eq(T value) {
        EasyMock.reportMatcher(new Equals(value));
        return null;
    }

    public static boolean[] aryEq(boolean[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static byte[] aryEq(byte[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static char[] aryEq(char[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static double[] aryEq(double[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static float[] aryEq(float[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static int[] aryEq(int[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static long[] aryEq(long[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static short[] aryEq(short[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static <T> T[] aryEq(T[] value) {
        EasyMock.reportMatcher(new ArrayEquals(value));
        return null;
    }

    public static <T> T isNull() {
        EasyMock.reportMatcher(Null.NULL);
        return null;
    }

    public static <T> T isNull(Class<T> clazz) {
        EasyMock.reportMatcher(Null.NULL);
        return null;
    }

    public static <T> T notNull() {
        EasyMock.reportMatcher(NotNull.NOT_NULL);
        return null;
    }

    public static <T> T notNull(Class<T> clazz) {
        EasyMock.reportMatcher(NotNull.NOT_NULL);
        return null;
    }

    public static String find(String regex) {
        EasyMock.reportMatcher(new Find(regex));
        return null;
    }

    public static String matches(String regex) {
        EasyMock.reportMatcher(new Matches(regex));
        return null;
    }

    public static String startsWith(String prefix) {
        EasyMock.reportMatcher(new StartsWith(prefix));
        return null;
    }

    public static String endsWith(String suffix) {
        EasyMock.reportMatcher(new EndsWith(suffix));
        return null;
    }

    public static double eq(double value, double delta) {
        EasyMock.reportMatcher(new EqualsWithDelta(value, delta));
        return 0.0;
    }

    public static float eq(float value, float delta) {
        EasyMock.reportMatcher(new EqualsWithDelta(Float.valueOf(value), Float.valueOf(delta)));
        return 0.0f;
    }

    public static <T> T same(T value) {
        EasyMock.reportMatcher(new Same(value));
        return null;
    }

    public static <T extends Comparable<T>> T cmpEq(Comparable<T> value) {
        EasyMock.reportMatcher(new CompareEqual<T>(value));
        return null;
    }

    public static <T> T cmp(T value, Comparator<? super T> comparator, LogicalOperator operator) {
        EasyMock.reportMatcher(new Compare<T>(value, comparator, operator));
        return null;
    }

    public static <T> T capture(Capture<T> captured) {
        EasyMock.reportMatcher(new Captures<T>(captured));
        return null;
    }

    public static boolean captureBoolean(Capture<Boolean> captured) {
        EasyMock.reportMatcher(new Captures<Boolean>(captured));
        return false;
    }

    public static int captureInt(Capture<Integer> captured) {
        EasyMock.reportMatcher(new Captures<Integer>(captured));
        return 0;
    }

    public static long captureLong(Capture<Long> captured) {
        EasyMock.reportMatcher(new Captures<Long>(captured));
        return 0L;
    }

    public static float captureFloat(Capture<Float> captured) {
        EasyMock.reportMatcher(new Captures<Float>(captured));
        return 0.0f;
    }

    public static double captureDouble(Capture<Double> captured) {
        EasyMock.reportMatcher(new Captures<Double>(captured));
        return 0.0;
    }

    public static byte captureByte(Capture<Byte> captured) {
        EasyMock.reportMatcher(new Captures<Byte>(captured));
        return 0;
    }

    public static char captureChar(Capture<Character> captured) {
        EasyMock.reportMatcher(new Captures<Character>(captured));
        return '\u0000';
    }

    public static void replay(Object ... mocks) {
        for (Object mock : mocks) {
            EasyMock.getControl(mock).replay();
        }
    }

    public static void reset(Object ... mocks) {
        for (Object mock : mocks) {
            EasyMock.getControl(mock).reset();
        }
    }

    public static void resetToNice(Object ... mocks) {
        for (Object mock : mocks) {
            EasyMock.getControl(mock).resetToNice();
        }
    }

    public static void resetToDefault(Object ... mocks) {
        for (Object mock : mocks) {
            EasyMock.getControl(mock).resetToDefault();
        }
    }

    public static void resetToStrict(Object ... mocks) {
        for (Object mock : mocks) {
            EasyMock.getControl(mock).resetToStrict();
        }
    }

    public static void verify(Object ... mocks) {
        for (Object mock : mocks) {
            EasyMock.getControl(mock).verify();
        }
    }

    public static void checkOrder(Object mock, boolean state) {
        EasyMock.getControl(mock).checkOrder(state);
    }

    public static void reportMatcher(IArgumentMatcher matcher) {
        LastControl.reportMatcher(matcher);
    }

    private static MocksControl getControl(Object mock) {
        return MocksControl.getControl(mock);
    }

    public static Object[] getCurrentArguments() {
        Invocation result = LastControl.getCurrentInvocation();
        if (result == null) {
            throw new IllegalStateException("current arguments are only available when executing callback methods");
        }
        return result.getArguments();
    }

    public static void makeThreadSafe(Object mock, boolean threadSafe) {
        EasyMock.getControl(mock).makeThreadSafe(threadSafe);
    }

    public static void checkIsUsedInOneThread(Object mock, boolean shouldBeUsedInOneThread) {
        EasyMock.getControl(mock).checkIsUsedInOneThread(shouldBeUsedInOneThread);
    }

    public static String getEasyMockProperty(String key) {
        return EasyMockProperties.getInstance().getProperty(key);
    }

    public static String setEasyMockProperty(String key, String value) {
        return EasyMockProperties.getInstance().setProperty(key, value);
    }

    protected EasyMock() {
    }
}

