/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractShortSet
extends AbstractSet {
    public boolean contains(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractShortSet copy() {
        return (AbstractShortSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortSet)) {
            return false;
        }
        final AbstractShortSet other = (AbstractShortSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                return other.contains(key);
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachKey(new ShortProcedure(){
            int i = 0;

            @Override
            public boolean apply(short iterKey) {
                buf[this.i++] = HashUtils.hash(iterKey);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(short var1);

    public abstract boolean remove(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

