/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.decomposer;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.decomposer.lanczos.LanczosState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsBackedLanczosState
extends LanczosState
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(HdfsBackedLanczosState.class);
    public static final String BASIS_PREFIX = "basis";
    public static final String SINGULAR_PREFIX = "singular";
    private Configuration conf;
    private final Path baseDir;
    private final Path basisPath;
    private final Path singularVectorPath;
    private FileSystem fs;

    public HdfsBackedLanczosState(VectorIterable corpus, int desiredRank, Vector initialVector, Path dir) {
        super(corpus, desiredRank, initialVector);
        this.baseDir = dir;
        this.basisPath = new Path(dir, BASIS_PREFIX);
        this.singularVectorPath = new Path(dir, SINGULAR_PREFIX);
        if (corpus instanceof Configurable) {
            this.setConf(((Configurable)corpus).getConf());
        }
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        try {
            this.setupDirs();
            this.updateHdfsState();
        }
        catch (IOException e) {
            log.error("Could not retrieve filesystem: {}", (Object)this.conf, (Object)e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void setupDirs() throws IOException {
        this.fs = this.baseDir.getFileSystem(this.conf);
        this.createDirIfNotExist(this.baseDir);
        this.createDirIfNotExist(this.basisPath);
        this.createDirIfNotExist(this.singularVectorPath);
    }

    private void createDirIfNotExist(Path path) throws IOException {
        if (!this.fs.exists(path) && !this.fs.mkdirs(path)) {
            throw new IOException("Unable to create: " + path);
        }
    }

    @Override
    public void setIterationNumber(int i) {
        super.setIterationNumber(i);
        try {
            this.updateHdfsState();
        }
        catch (IOException e) {
            log.error("Could not update HDFS state: ", e);
        }
    }

    protected void updateHdfsState() throws IOException {
        int i;
        Vector nextVector;
        if (this.conf == null) {
            return;
        }
        int numBasisVectorsOnDisk = 0;
        Path nextBasisVectorPath = new Path(this.basisPath, "basis_" + numBasisVectorsOnDisk);
        while (this.fs.exists(nextBasisVectorPath)) {
            nextBasisVectorPath = new Path(this.basisPath, "basis_" + ++numBasisVectorsOnDisk);
        }
        while (numBasisVectorsOnDisk < this.iterationNumber && (nextVector = this.getBasisVector(numBasisVectorsOnDisk)) != null) {
            this.persistVector(nextBasisVectorPath, numBasisVectorsOnDisk, nextVector);
            nextBasisVectorPath = new Path(this.basisPath, "basis_" + ++numBasisVectorsOnDisk);
        }
        if (this.scaleFactor <= 0.0) {
            this.scaleFactor = this.getScaleFactor();
        }
        this.diagonalMatrix = this.getDiagonalMatrix();
        DenseVector norms = new DenseVector(this.diagonalMatrix.numCols() - 1);
        DenseVector projections = new DenseVector(this.diagonalMatrix.numCols());
        for (i = 0; i < this.diagonalMatrix.numCols() - 1; ++i) {
            norms.set(i, this.diagonalMatrix.get(i, i + 1));
            projections.set(i, this.diagonalMatrix.get(i, i));
        }
        projections.set(i, this.diagonalMatrix.get(i, i));
        this.persistVector(new Path(this.baseDir, "projections"), 0, projections);
        this.persistVector(new Path(this.baseDir, "norms"), 0, norms);
        this.persistVector(new Path(this.baseDir, "scaleFactor"), 0, new DenseVector(new double[]{this.scaleFactor}));
        for (Map.Entry entry : this.singularVectors.entrySet()) {
            this.persistVector(new Path(this.singularVectorPath, "singular_" + entry.getKey()), (Integer)entry.getKey(), (Vector)entry.getValue());
        }
        super.setIterationNumber(numBasisVectorsOnDisk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistVector(Path p, int key, Vector vector) throws IOException {
        SequenceFile.Writer writer = null;
        try {
            if (this.fs.exists(p)) {
                log.warn("{} exists, will overwrite", (Object)p);
                this.fs.delete(p, true);
            }
            writer = new SequenceFile.Writer(this.fs, this.conf, p, IntWritable.class, VectorWritable.class);
            writer.append((Writable)new IntWritable(key), (Writable)new VectorWritable(vector));
        }
        catch (Throwable throwable) {
            Closeables.close(writer, false);
            throw throwable;
        }
        Closeables.close((Closeable)writer, false);
    }

    protected Vector fetchVector(Path p, int keyIndex) throws IOException {
        if (!this.fs.exists(p)) {
            return null;
        }
        SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, p, this.conf);
        IntWritable key = new IntWritable();
        VectorWritable vw = new VectorWritable();
        while (reader.next((Writable)key, (Writable)vw)) {
            if (key.get() != keyIndex) continue;
            return vw.get();
        }
        return null;
    }

    @Override
    public Vector getBasisVector(int i) {
        if (!this.basis.containsKey(i)) {
            try {
                Vector v = this.fetchVector(new Path(this.basisPath, "basis_" + i), i);
                this.basis.put(i, v);
            }
            catch (IOException e) {
                log.error("Could not load basis vector: {}", (Object)i, (Object)e);
            }
        }
        return super.getBasisVector(i);
    }

    @Override
    public Vector getRightSingularVector(int i) {
        if (!this.singularVectors.containsKey(i)) {
            try {
                Vector v = this.fetchVector(new Path(this.singularVectorPath, "basis_" + i), i);
                this.singularVectors.put(i, v);
            }
            catch (IOException e) {
                log.error("Could not load singular vector: {}", (Object)i, (Object)e);
            }
        }
        return super.getRightSingularVector(i);
    }

    @Override
    public double getScaleFactor() {
        if (this.scaleFactor <= 0.0) {
            try {
                Vector v = this.fetchVector(new Path(this.baseDir, "scaleFactor"), 0);
                if (v != null && v.size() > 0) {
                    this.scaleFactor = v.get(0);
                }
            }
            catch (IOException e) {
                log.error("could not load scaleFactor:", e);
            }
        }
        return this.scaleFactor;
    }

    @Override
    public Matrix getDiagonalMatrix() {
        if (this.diagonalMatrix == null) {
            this.diagonalMatrix = new DenseMatrix(this.desiredRank, this.desiredRank);
        }
        if (this.diagonalMatrix.get(0, 1) <= 0.0) {
            try {
                Vector norms = this.fetchVector(new Path(this.baseDir, "norms"), 0);
                Vector projections = this.fetchVector(new Path(this.baseDir, "projections"), 0);
                if (norms != null && projections != null) {
                    int i;
                    for (i = 0; i < projections.size() - 1; ++i) {
                        this.diagonalMatrix.set(i, i, projections.get(i));
                        this.diagonalMatrix.set(i, i + 1, norms.get(i));
                        this.diagonalMatrix.set(i + 1, i, norms.get(i));
                    }
                    this.diagonalMatrix.set(i, i, projections.get(i));
                }
            }
            catch (IOException e) {
                log.error("Could not load diagonal matrix of norms and projections: ", e);
            }
        }
        return this.diagonalMatrix;
    }
}

