/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;

public class TransposeJob
extends AbstractJob {
    public static final String NUM_ROWS_KEY = "SparseRowMatrix.numRows";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new TransposeJob(), (String[])args);
    }

    public int run(String[] strings) throws Exception {
        this.addInputOption();
        this.addOption("numRows", "nr", "Number of rows of the input matrix");
        this.addOption("numCols", "nc", "Number of columns of the input matrix");
        Map<String, List<String>> parsedArgs = this.parseArguments(strings);
        if (parsedArgs == null) {
            return -1;
        }
        int numRows = Integer.parseInt(this.getOption("numRows"));
        int numCols = Integer.parseInt(this.getOption("numCols"));
        DistributedRowMatrix matrix = new DistributedRowMatrix(this.getInputPath(), this.getTempPath(), numRows, numCols);
        matrix.setConf(new Configuration(this.getConf()));
        matrix.transpose();
        return 0;
    }

    public static Configuration buildTransposeJobConf(Path matrixInputPath, Path matrixOutputPath, int numInputRows) throws IOException {
        return TransposeJob.buildTransposeJobConf(new Configuration(), matrixInputPath, matrixOutputPath, numInputRows);
    }

    public static Configuration buildTransposeJobConf(Configuration initialConf, Path matrixInputPath, Path matrixOutputPath, int numInputRows) throws IOException {
        JobConf conf = new JobConf(initialConf, TransposeJob.class);
        conf.setJobName("TransposeJob: " + matrixInputPath + " transpose -> " + matrixOutputPath);
        FileSystem fs = FileSystem.get((URI)matrixInputPath.toUri(), (Configuration)conf);
        matrixInputPath = fs.makeQualified(matrixInputPath);
        matrixOutputPath = fs.makeQualified(matrixOutputPath);
        conf.setInt(NUM_ROWS_KEY, numInputRows);
        FileInputFormat.addInputPath((JobConf)conf, (Path)matrixInputPath);
        conf.setInputFormat(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)matrixOutputPath);
        conf.setMapperClass(TransposeMapper.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(VectorWritable.class);
        conf.setCombinerClass(MergeVectorsCombiner.class);
        conf.setReducerClass(MergeVectorsReducer.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(VectorWritable.class);
        return conf;
    }

    public static class MergeVectorsReducer
    extends MapReduceBase
    implements Reducer<WritableComparable<?>, VectorWritable, WritableComparable<?>, VectorWritable> {
        public void reduce(WritableComparable<?> key, Iterator<VectorWritable> vectors, OutputCollector<WritableComparable<?>, VectorWritable> out, Reporter reporter) throws IOException {
            Vector merged = VectorWritable.merge(vectors).get();
            out.collect(key, (Object)new VectorWritable(new SequentialAccessSparseVector(merged)));
        }
    }

    public static class MergeVectorsCombiner
    extends MapReduceBase
    implements Reducer<WritableComparable<?>, VectorWritable, WritableComparable<?>, VectorWritable> {
        public void reduce(WritableComparable<?> key, Iterator<VectorWritable> vectors, OutputCollector<WritableComparable<?>, VectorWritable> out, Reporter reporter) throws IOException {
            out.collect(key, (Object)VectorWritable.merge(vectors));
        }
    }

    public static class TransposeMapper
    extends MapReduceBase
    implements Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private int newNumCols;

        public void configure(JobConf conf) {
            this.newNumCols = conf.getInt(TransposeJob.NUM_ROWS_KEY, Integer.MAX_VALUE);
        }

        public void map(IntWritable r, VectorWritable v, OutputCollector<IntWritable, VectorWritable> out, Reporter reporter) throws IOException {
            int row = r.get();
            for (Vector.Element e : v.get().nonZeroes()) {
                RandomAccessSparseVector tmp = new RandomAccessSparseVector(this.newNumCols, 1);
                tmp.setQuick(row, e.get());
                r.set(e.index());
                out.collect((Object)r, (Object)new VectorWritable(tmp));
            }
        }
    }
}

