/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.Vector;

public class UpperTriangular
extends AbstractMatrix {
    private static final double EPSILON = 1.0E-12;
    private double[] values;

    public UpperTriangular(int n) {
        super(n, n);
        this.values = new double[n * (n + 1) / 2];
    }

    public UpperTriangular(double[] data, boolean shallow) {
        this(UpperTriangular.elementsToMatrixSize(data != null ? data.length : 0));
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.values = shallow ? data : (double[])data.clone();
    }

    public UpperTriangular(Vector data) {
        this(UpperTriangular.elementsToMatrixSize(data.size()));
        for (Vector.Element el : data.nonZeroes()) {
            this.values[el.index()] = el.get();
        }
    }

    private static int elementsToMatrixSize(int dataSize) {
        return (int)Math.round((-1.0 + Math.sqrt(1 + 8 * dataSize)) / 2.0);
    }

    public UpperTriangular(UpperTriangular mx) {
        this(mx.values, false);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new IndexException(this.columnSize(), other.size());
        }
        if (other.viewPart(column + 1, other.size() - column - 1).norm(1.0) > 1.0E-14) {
            throw new IllegalArgumentException("Cannot set lower portion of triangular matrix to non-zero");
        }
        for (Vector.Element element : other.viewPart(0, column).all()) {
            this.setQuick(element.index(), column, element.get());
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        int i;
        if (this.columnSize() != other.size()) {
            throw new IndexException(this.numCols(), other.size());
        }
        for (i = 0; i < row; ++i) {
            if (!(Math.abs(other.getQuick(i)) > 1.0E-12)) continue;
            throw new IllegalArgumentException("non-triangular source");
        }
        for (i = row; i < this.rows; ++i) {
            this.setQuick(row, i, other.get(i));
        }
        return this;
    }

    public Matrix assignNonZeroElementsInRow(int row, double[] other) {
        System.arraycopy(other, row, this.values, this.getL(row, row), this.rows - row);
        return this;
    }

    @Override
    public double getQuick(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        int i = this.getL(row, column);
        return this.values[i];
    }

    private int getL(int row, int col) {
        return col + row * this.numCols() - (row + 1) * row / 2;
    }

    @Override
    public Matrix like() {
        return this.like(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.values[this.getL((int)row, (int)column)] = value;
    }

    @Override
    public int[] getNumNondefaultElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        return new MatrixView(this, offset, size);
    }

    public double[] getData() {
        return this.values;
    }
}

