/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class MultiLabelVectorWritable
implements Writable {
    private final VectorWritable vectorWritable = new VectorWritable();
    private int[] labels;

    public MultiLabelVectorWritable() {
    }

    public MultiLabelVectorWritable(Vector vector, int[] labels) {
        this.vectorWritable.set(vector);
        this.labels = labels;
    }

    public Vector getVector() {
        return this.vectorWritable.get();
    }

    public void setVector(Vector vector) {
        this.vectorWritable.set(vector);
    }

    public void setLabels(int[] labels) {
        this.labels = labels;
    }

    public int[] getLabels() {
        return this.labels;
    }

    public void readFields(DataInput in) throws IOException {
        this.vectorWritable.readFields(in);
        int labelSize = in.readInt();
        this.labels = new int[labelSize];
        for (int i = 0; i < labelSize; ++i) {
            this.labels[i] = in.readInt();
        }
    }

    public void write(DataOutput out) throws IOException {
        this.vectorWritable.write(out);
        out.writeInt(this.labels.length);
        for (int label : this.labels) {
            out.writeInt(label);
        }
    }

    public static MultiLabelVectorWritable read(DataInput in) throws IOException {
        MultiLabelVectorWritable writable = new MultiLabelVectorWritable();
        writable.readFields(in);
        return writable;
    }

    public static void write(DataOutput out, SequentialAccessSparseVector ssv, int[] labels) throws IOException {
        new MultiLabelVectorWritable(ssv, labels).write(out);
    }
}

