/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.convertors;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mahout.common.Pair;

public class TransactionIterator<T>
extends ForwardingIterator<Pair<int[], Long>> {
    private final int[] transactionBuffer;
    private final Iterator<Pair<int[], Long>> delegate;

    public TransactionIterator(Iterator<Pair<List<T>, Long>> transactions, final Map<T, Integer> attributeIdMapping) {
        this.transactionBuffer = new int[attributeIdMapping.size()];
        this.delegate = Iterators.transform(transactions, new Function<Pair<List<T>, Long>, Pair<int[], Long>>(){

            @Override
            public Pair<int[], Long> apply(Pair<List<T>, Long> from) {
                if (from == null) {
                    return null;
                }
                int index = 0;
                for (Object attribute : from.getFirst()) {
                    if (!attributeIdMapping.containsKey(attribute)) continue;
                    ((TransactionIterator)TransactionIterator.this).transactionBuffer[index++] = (Integer)attributeIdMapping.get(attribute);
                }
                int[] transactionList = new int[index];
                System.arraycopy(TransactionIterator.this.transactionBuffer, 0, transactionList, 0, index);
                return new Pair<int[], Long>(transactionList, from.getSecond());
            }
        });
    }

    @Override
    protected Iterator<Pair<int[], Long>> delegate() {
        return this.delegate;
    }
}

