/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.tools;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.classifier.df.tools.TreeVisualizer;
import org.apache.mahout.common.CommandLineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForestVisualizer {
    private static final Logger log = LoggerFactory.getLogger(ForestVisualizer.class);

    private ForestVisualizer() {
    }

    public static String toString(DecisionForest forest, Dataset dataset, String[] attrNames) {
        List trees;
        try {
            Method getTrees = forest.getClass().getDeclaredMethod("getTrees", new Class[0]);
            getTrees.setAccessible(true);
            trees = (List)getTrees.invoke((Object)forest, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        int cnt = 1;
        StringBuilder buff = new StringBuilder();
        for (Node tree : trees) {
            buff.append("Tree[").append(cnt).append("]:");
            buff.append(TreeVisualizer.toString(tree, dataset, attrNames));
            buff.append('\n');
            ++cnt;
        }
        return buff.toString();
    }

    public static String toString(String forestPath, String datasetPath, String[] attrNames) throws IOException {
        Configuration conf = new Configuration();
        DecisionForest forest = DecisionForest.load(conf, new Path(forestPath));
        Dataset dataset = Dataset.load(conf, new Path(datasetPath));
        return ForestVisualizer.toString(forest, dataset, attrNames);
    }

    public static void print(String forestPath, String datasetPath, String[] attrNames) throws IOException {
        System.out.println(ForestVisualizer.toString(forestPath, datasetPath, attrNames));
    }

    public static void main(String[] args) {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).withMaximum(1).create()).withDescription("Dataset path").create();
        DefaultOption modelOpt = obuilder.withLongName("model").withShortName("m").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Path to the Decision Forest").create();
        DefaultOption attrNamesOpt = obuilder.withLongName("names").withShortName("n").withRequired(false).withArgument(abuilder.withName("names").withMinimum(1).create()).withDescription("Optional, Attribute names").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withShortName("h").withDescription("Print out help").create();
        Group group = gbuilder.withName("Options").withOption(datasetOpt).withOption(modelOpt).withOption(attrNamesOpt).withOption(helpOpt).create();
        try {
            List names;
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption("help")) {
                CommandLineUtil.printHelp(group);
                return;
            }
            String datasetName = cmdLine.getValue(datasetOpt).toString();
            String modelName = cmdLine.getValue(modelOpt).toString();
            String[] attrNames = null;
            if (cmdLine.hasOption(attrNamesOpt) && !(names = cmdLine.getValues(attrNamesOpt)).isEmpty()) {
                attrNames = new String[names.size()];
                names.toArray(attrNames);
            }
            ForestVisualizer.print(modelName, datasetName, attrNames);
        }
        catch (Exception e) {
            log.error("Exception", e);
            CommandLineUtil.printHelp(group);
        }
    }
}

