/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.regex;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.lucene.TokenStreamIterator;
import org.apache.mahout.utils.regex.RegexTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerTransformer
implements RegexTransformer {
    private Analyzer analyzer;
    private String fieldName = "text";
    private static final Logger log = LoggerFactory.getLogger(AnalyzerTransformer.class);

    public AnalyzerTransformer() {
        this(new StandardAnalyzer(Version.LUCENE_46), "text");
    }

    public AnalyzerTransformer(Analyzer analyzer) {
        this(analyzer, "text");
    }

    public AnalyzerTransformer(Analyzer analyzer, String fieldName) {
        this.analyzer = analyzer;
        this.fieldName = fieldName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String transformMatch(String match) {
        StringBuilder result = new StringBuilder();
        TokenStream ts = null;
        try {
            ts = this.analyzer.tokenStream(this.fieldName, new StringReader(match));
            ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            TokenStreamIterator iter = new TokenStreamIterator(ts);
            while (iter.hasNext()) {
                result.append((String)iter.next()).append(' ');
            }
            ts.end();
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(ts, true);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            Closeables.close(ts, true);
            return result.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return result.toString();
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }
}

