/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.clustering;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.WeightedPropertyVectorWritable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.StringUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.clustering.AbstractClusterWriter;

public class GraphMLClusterWriter
extends AbstractClusterWriter {
    private static final Pattern VEC_PATTERN = Pattern.compile("\\{|\\:|\\,|\\}");
    private final Map<Integer, Color> colors = new HashMap<Integer, Color>();
    private Color lastClusterColor;
    private float lastX;
    private float lastY;
    private Random random;
    private int posStep;
    private final String[] dictionary;
    private final int numTopFeatures;
    private final int subString;

    public GraphMLClusterWriter(Writer writer, Map<Integer, List<WeightedPropertyVectorWritable>> clusterIdToPoints, DistanceMeasure measure, int numTopFeatures, String[] dictionary, int subString) throws IOException {
        super(writer, clusterIdToPoints, measure);
        this.dictionary = dictionary;
        this.numTopFeatures = numTopFeatures;
        this.subString = subString;
        this.init(writer);
    }

    private void init(Writer writer) throws IOException {
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.append("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\nhttp://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">");
        writer.append("<key attr.name=\"r\" attr.type=\"int\" for=\"node\" id=\"r\"/>\n<key attr.name=\"g\" attr.type=\"int\" for=\"node\" id=\"g\"/>\n<key attr.name=\"b\" attr.type=\"int\" for=\"node\" id=\"b\"/><key attr.name=\"size\" attr.type=\"int\" for=\"node\" id=\"size\"/><key attr.name=\"weight\" attr.type=\"float\" for=\"edge\" id=\"weight\"/><key attr.name=\"x\" attr.type=\"float\" for=\"node\" id=\"x\"/><key attr.name=\"y\" attr.type=\"float\" for=\"node\" id=\"y\"/>");
        writer.append("<graph edgedefault=\"undirected\">");
        this.lastClusterColor = new Color();
        this.posStep = (int)(0.1 * (double)this.clusterIdToPoints.size()) + 100;
        this.random = RandomUtils.getRandom();
    }

    @Override
    public void write(ClusterWritable clusterWritable) throws IOException {
        StringBuilder line = new StringBuilder();
        Cluster cluster = clusterWritable.getValue();
        Color rgb = this.getColor(cluster.getId());
        String topTerms = "";
        if (this.dictionary != null) {
            topTerms = GraphMLClusterWriter.getTopTerms(cluster.getCenter(), this.dictionary, this.numTopFeatures);
        }
        String clusterLabel = String.valueOf(cluster.getId()) + '_' + topTerms;
        float x = this.lastX + 1000.0f;
        float y = this.lastY;
        if (x > (float)(1000 + this.posStep)) {
            y = this.lastY + 1000.0f;
            x = 0.0f;
        }
        line.append(GraphMLClusterWriter.createNode(clusterLabel, rgb, x, y));
        List points = (List)this.clusterIdToPoints.get(cluster.getId());
        if (points != null) {
            for (WeightedPropertyVectorWritable point : points) {
                String vecStr;
                Vector theVec = point.getVector();
                double distance = 1.0;
                if (this.measure != null) {
                    distance = this.measure.distance(cluster.getCenter().getLengthSquared(), cluster.getCenter(), theVec) * 500.0;
                }
                int angle = this.random.nextInt(360);
                double angleRads = Math.toRadians(angle);
                float targetX = x + (float)(distance * Math.cos(angleRads));
                float targetY = y + (float)(distance * Math.sin(angleRads));
                if (theVec instanceof NamedVector) {
                    vecStr = ((NamedVector)theVec).getName();
                } else {
                    vecStr = theVec.asFormatString();
                    vecStr = VEC_PATTERN.matcher(vecStr).replaceAll("_");
                }
                if (this.subString > 0 && vecStr.length() > this.subString) {
                    vecStr = vecStr.substring(0, this.subString);
                }
                line.append(GraphMLClusterWriter.createNode(vecStr, rgb, targetX, targetY));
                line.append(GraphMLClusterWriter.createEdge(clusterLabel, vecStr, distance));
            }
        }
        this.lastClusterColor = rgb;
        this.lastX = x;
        this.lastY = y;
        this.getWriter().append(line).append("\n");
    }

    private Color getColor(int clusterId) {
        Color result = this.colors.get(clusterId);
        if (result == null) {
            result = new Color();
            int incR = 0;
            int incG = 0;
            int incB = 0;
            if (this.lastClusterColor.r + 20 < 256 && this.lastClusterColor.g + 20 < 256 && this.lastClusterColor.b + 20 < 256) {
                incR = 20;
                incG = 0;
                incB = 0;
            } else if (this.lastClusterColor.r + 20 >= 256 && this.lastClusterColor.g + 20 < 256 && this.lastClusterColor.b + 20 < 256) {
                incG = 20;
                incB = 0;
            } else if (this.lastClusterColor.r + 20 >= 256 && this.lastClusterColor.g + 20 >= 256 && this.lastClusterColor.b + 20 < 256) {
                incB = 20;
            } else {
                incR += 3;
                incG += 3;
                incR += 3;
            }
            result.r = (this.lastClusterColor.r + incR) % 256;
            result.g = (this.lastClusterColor.g + incG) % 256;
            result.b = (this.lastClusterColor.b + incB) % 256;
            this.colors.put(clusterId, result);
        }
        return result;
    }

    private static String createEdge(String left, String right, double distance) {
        left = StringUtils.escapeXML(left);
        right = StringUtils.escapeXML(right);
        return "<edge id=\"" + left + '_' + right + "\" source=\"" + left + "\" target=\"" + right + "\">" + "<data key=\"weight\">" + distance + "</data></edge>";
    }

    private static String createNode(String s, Color rgb, float x, float y) {
        return "<node id=\"" + StringUtils.escapeXML(s) + "\"><data key=\"r\">" + rgb.r + "</data>" + "<data key=\"g\">" + rgb.g + "</data>" + "<data key=\"b\">" + rgb.b + "</data>" + "<data key=\"x\">" + x + "</data>" + "<data key=\"y\">" + y + "</data>" + "</node>";
    }

    @Override
    public void close() throws IOException {
        this.getWriter().append("</graph>").append("</graphml>");
        super.close();
    }

    private static class Color {
        int r;
        int g;
        int b;

        private Color() {
        }
    }
}

