/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.text.SequenceFilesFromDirectoryFilter;
import org.apache.mahout.utils.io.ChunkedWriter;

public final class PrefixAdditionFilter
extends SequenceFilesFromDirectoryFilter {
    public PrefixAdditionFilter(Configuration conf, String keyPrefix, Map<String, String> options, ChunkedWriter writer, Charset charset, FileSystem fs) {
        super(conf, keyPrefix, options, writer, charset, fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(FileStatus fst, Path current) throws IOException {
        FileSystem fs = this.getFs();
        ChunkedWriter writer = this.getWriter();
        if (fst.isDir()) {
            String dirPath = this.getPrefix() + "/" + current.getName() + "/" + fst.getPath().getName();
            fs.listStatus(fst.getPath(), (PathFilter)new PrefixAdditionFilter(this.getConf(), dirPath, this.getOptions(), writer, this.getCharset(), fs));
        } else {
            FSDataInputStream in = null;
            try {
                in = fs.open(fst.getPath());
                StringBuilder file = new StringBuilder();
                for (String aFit : new FileLineIterable((InputStream)in, this.getCharset(), false)) {
                    file.append(aFit).append('\n');
                }
                String name = current.getName().equals(fst.getPath().getName()) ? current.getName() : current.getName() + "/" + fst.getPath().getName();
                writer.write(this.getPrefix() + "/" + name, file.toString());
            }
            finally {
                Closeables.close((Closeable)in, false);
            }
        }
    }
}

