/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd.qr;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.iterator.CopyConstructorIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.UpperTriangular;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.GivensThinSolver;

public class QRFirstStep
implements Closeable,
OutputCollector<Writable, Vector> {
    public static final String PROP_K = "ssvd.k";
    public static final String PROP_P = "ssvd.p";
    public static final String PROP_AROWBLOCK_SIZE = "ssvd.arowblock.size";
    private int kp;
    private List<double[]> yLookahead;
    private GivensThinSolver qSolver;
    private int blockCnt;
    private final DenseBlockWritable value = new DenseBlockWritable();
    private final Writable tempKey = new IntWritable();
    private MultipleOutputs outputs;
    private final Deque<Closeable> closeables = Lists.newLinkedList();
    private SequenceFile.Writer tempQw;
    private Path tempQPath;
    private final List<UpperTriangular> rSubseq = Lists.newArrayList();
    private final Configuration jobConf;
    private final OutputCollector<? super Writable, ? super DenseBlockWritable> qtHatOut;
    private final OutputCollector<? super Writable, ? super VectorWritable> rHatOut;

    public QRFirstStep(Configuration jobConf, OutputCollector<? super Writable, ? super DenseBlockWritable> qtHatOut, OutputCollector<? super Writable, ? super VectorWritable> rHatOut) {
        this.jobConf = jobConf;
        this.qtHatOut = qtHatOut;
        this.rHatOut = rHatOut;
        this.setup();
    }

    @Override
    public void close() throws IOException {
        this.cleanup();
    }

    public int getKP() {
        return this.kp;
    }

    private void flushSolver() throws IOException {
        UpperTriangular r = this.qSolver.getRTilde();
        double[][] qt = this.qSolver.getThinQtTilde();
        this.rSubseq.add(r);
        this.value.setBlock(qt);
        this.getTempQw().append(this.tempKey, (Writable)this.value);
        this.value.setBlock(null);
        this.qSolver.reset();
    }

    private void flushQBlocks() throws IOException {
        if (this.blockCnt == 1) {
            this.value.setBlock(this.qSolver.getThinQtTilde());
            this.outputQHat(this.value);
            this.outputR(new VectorWritable(new DenseVector(this.qSolver.getRTilde().getData(), true)));
        } else {
            this.secondPass();
        }
    }

    private void outputQHat(DenseBlockWritable value) throws IOException {
        this.qtHatOut.collect((Object)NullWritable.get(), (Object)value);
    }

    private void outputR(VectorWritable value) throws IOException {
        this.rHatOut.collect((Object)NullWritable.get(), (Object)value);
    }

    private void secondPass() throws IOException {
        this.qSolver = null;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.jobConf);
        SequenceFile.Reader tempQr = new SequenceFile.Reader((FileSystem)localFs, this.tempQPath, this.jobConf);
        this.closeables.addFirst((Closeable)tempQr);
        int qCnt = 0;
        while (tempQr.next(this.tempKey, (Writable)this.value)) {
            this.value.setBlock(GivensThinSolver.computeQtHat(this.value.getBlock(), qCnt, new CopyConstructorIterator<UpperTriangular>(this.rSubseq.iterator())));
            if (qCnt == 1) {
                GivensThinSolver.mergeR(this.rSubseq.get(0), this.rSubseq.remove(1));
            } else {
                ++qCnt;
            }
            this.outputQHat(this.value);
        }
        assert (this.rSubseq.size() == 1);
        this.outputR(new VectorWritable(new DenseVector(this.rSubseq.get(0).getData(), true)));
    }

    protected void map(Vector incomingYRow) throws IOException {
        double[] yRow;
        if (this.yLookahead.size() == this.kp) {
            if (this.qSolver.isFull()) {
                this.flushSolver();
                ++this.blockCnt;
            }
            yRow = this.yLookahead.remove(0);
            this.qSolver.appendRow(yRow);
        } else {
            yRow = new double[this.kp];
        }
        if (incomingYRow.isDense()) {
            for (int i = 0; i < this.kp; ++i) {
                yRow[i] = incomingYRow.get(i);
            }
        } else {
            Arrays.fill(yRow, 0.0);
            for (Vector.Element yEl : incomingYRow.nonZeroes()) {
                yRow[yEl.index()] = yEl.get();
            }
        }
        this.yLookahead.add(yRow);
    }

    protected void setup() {
        int r = Integer.parseInt(this.jobConf.get(PROP_AROWBLOCK_SIZE));
        int k = Integer.parseInt(this.jobConf.get(PROP_K));
        int p = Integer.parseInt(this.jobConf.get(PROP_P));
        this.kp = k + p;
        this.yLookahead = Lists.newArrayListWithCapacity(this.kp);
        this.qSolver = new GivensThinSolver(r, this.kp);
        this.outputs = new MultipleOutputs(new JobConf(this.jobConf));
        this.closeables.addFirst(new Closeable(){

            @Override
            public void close() throws IOException {
                QRFirstStep.this.outputs.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() throws IOException {
        try {
            if (this.qSolver == null && this.yLookahead.isEmpty()) {
                return;
            }
            if (this.qSolver == null) {
                this.qSolver = new GivensThinSolver(this.yLookahead.size(), this.kp);
            }
            this.qSolver.adjust(this.qSolver.getCnt() + this.yLookahead.size());
            while (!this.yLookahead.isEmpty()) {
                this.qSolver.appendRow(this.yLookahead.remove(0));
            }
            assert (this.qSolver.isFull());
            if (++this.blockCnt > 1) {
                this.flushSolver();
                assert (this.tempQw != null);
                this.closeables.remove(this.tempQw);
                Closeables.close((Closeable)this.tempQw, false);
            }
            this.flushQBlocks();
        }
        finally {
            IOUtils.close(this.closeables);
        }
    }

    private SequenceFile.Writer getTempQw() throws IOException {
        if (this.tempQw == null) {
            String taskTmpDir = System.getProperty("java.io.tmpdir");
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.jobConf);
            Path parent = new Path(taskTmpDir);
            Path sub = new Path(parent, "qw_" + System.currentTimeMillis());
            this.tempQPath = new Path(sub, "q-temp.seq");
            this.tempQw = SequenceFile.createWriter((FileSystem)localFs, (Configuration)this.jobConf, (Path)this.tempQPath, IntWritable.class, DenseBlockWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            this.closeables.addFirst((Closeable)this.tempQw);
            this.closeables.addFirst(new IOUtils.DeleteFileOnClose(new File(this.tempQPath.toString())));
        }
        return this.tempQw;
    }

    public void collect(Writable key, Vector vw) throws IOException {
        this.map(vw);
    }
}

