/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.common.iterator.StringRecordIterator;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.convertors.ContextStatusUpdater;
import org.apache.mahout.fpm.pfpgrowth.convertors.SequenceFileOutputCollector;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.StringOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPGrowth;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth2.FPGrowthObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FPGrowthDriver
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(FPGrowthDriver.class);

    private FPGrowthDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new FPGrowthDriver(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("minSupport", "s", "(Optional) The minimum number of times a co-occurrence must be present. Default Value: 3", "3");
        this.addOption("maxHeapSize", "k", "(Optional) Maximum Heap Size k, to denote the requirement to mine top K items. Default value: 50", "50");
        this.addOption("numGroups", "g", "(Optional) Number of groups the features should be divided in the map-reduce version. Doesn't work in sequential version Default Value:1000", Integer.toString(1000));
        this.addOption("splitterPattern", "regex", "Regular Expression pattern used to split given string transaction into itemsets. Default value splits comma separated itemsets.  Default Value: \"[ ,\\t]*[,|\\t][ ,\\t]*\" ", "[ ,\t]*[,|\t][ ,\t]*");
        this.addOption("numTreeCacheEntries", "tc", "(Optional) Number of entries in the tree cache to prevent duplicate tree building. (Warning) a first level conditional FP-Tree might consume a lot of memory, so keep this value small, but big enough to prevent duplicate tree building. Default Value:5 Recommended Values: [5-10]", "5");
        this.addOption("method", "method", "Method of processing: sequential|mapreduce", "sequential");
        this.addOption("encoding", "e", "(Optional) The file encoding.  Default value: UTF-8", "UTF-8");
        this.addFlag("useFPG2", "2", "Use an alternate FPG implementation");
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Parameters params = new Parameters();
        if (this.hasOption("minSupport")) {
            String minSupportString = this.getOption("minSupport");
            params.set("minSupport", minSupportString);
        }
        if (this.hasOption("maxHeapSize")) {
            String maxHeapSizeString = this.getOption("maxHeapSize");
            params.set("maxHeapSize", maxHeapSizeString);
        }
        if (this.hasOption("numGroups")) {
            String numGroupsString = this.getOption("numGroups");
            params.set("numGroups", numGroupsString);
        }
        if (this.hasOption("numTreeCacheEntries")) {
            String numTreeCacheString = this.getOption("numTreeCacheEntries");
            params.set("treeCacheSize", numTreeCacheString);
        }
        if (this.hasOption("splitterPattern")) {
            String patternString = this.getOption("splitterPattern");
            params.set("splitPattern", patternString);
        }
        String encoding = "UTF-8";
        if (this.hasOption("encoding")) {
            encoding = this.getOption("encoding");
        }
        params.set("encoding", encoding);
        if (this.hasOption("useFPG2")) {
            params.set("use_fpg2", "true");
        }
        Path inputDir = this.getInputPath();
        Path outputDir = this.getOutputPath();
        params.set("input", inputDir.toString());
        params.set("output", outputDir.toString());
        String classificationMethod = this.getOption("method");
        if ("sequential".equalsIgnoreCase(classificationMethod)) {
            FPGrowthDriver.runFPGrowth(params);
        } else if ("mapreduce".equalsIgnoreCase(classificationMethod)) {
            Configuration conf = new Configuration();
            HadoopUtil.delete(conf, outputDir);
            PFPGrowth.runPFPGrowth(params);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runFPGrowth(Parameters params) throws IOException {
        Object fp;
        log.info("Starting Sequential FPGrowth");
        int maxHeapSize = Integer.valueOf(params.get("maxHeapSize", "50"));
        int minSupport = Integer.valueOf(params.get("minSupport", "3"));
        Path output = new Path(params.get("output", "output.txt"));
        Path input = new Path(params.get("input"));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        Charset encoding = Charset.forName(params.get("encoding"));
        String pattern = params.get("splitPattern", PFPGrowth.SPLITTER.toString());
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, output, Text.class, TopKStringPatterns.class);
        FSDataInputStream inputStream = null;
        FSDataInputStream inputStreamAgain = null;
        HashSet features = Sets.newHashSet();
        if ("true".equals(params.get("use_fpg2"))) {
            fp = new FPGrowthObj();
            try {
                inputStream = fs.open(input);
                inputStreamAgain = fs.open(input);
                ((FPGrowthObj)fp).generateTopKFrequentPatterns(new StringRecordIterator(new FileLineIterable((InputStream)inputStream, encoding, false), pattern), ((FPGrowthObj)fp).generateFList(new StringRecordIterator(new FileLineIterable((InputStream)inputStreamAgain, encoding, false), pattern), minSupport), (long)minSupport, maxHeapSize, features, new StringOutputConverter(new SequenceFileOutputCollector<Text, TopKStringPatterns>(writer)));
            }
            finally {
                Closeables.close((Closeable)writer, false);
                Closeables.close((Closeable)inputStream, true);
                Closeables.close((Closeable)inputStreamAgain, true);
            }
        }
        fp = new FPGrowth();
        inputStream = fs.open(input);
        inputStreamAgain = fs.open(input);
        try {
            ((FPGrowth)fp).generateTopKFrequentPatterns(new StringRecordIterator(new FileLineIterable((InputStream)inputStream, encoding, false), pattern), ((FPGrowth)fp).generateFList(new StringRecordIterator(new FileLineIterable((InputStream)inputStreamAgain, encoding, false), pattern), minSupport), minSupport, maxHeapSize, features, new StringOutputConverter(new SequenceFileOutputCollector<Text, TopKStringPatterns>(writer)), new ContextStatusUpdater(null));
        }
        finally {
            Closeables.close((Closeable)writer, false);
            Closeables.close((Closeable)inputStream, true);
            Closeables.close((Closeable)inputStreamAgain, true);
        }
        List<Pair<String, TopKStringPatterns>> frequentPatterns = FPGrowth.readFrequentPattern(conf, output);
        for (Pair<String, TopKStringPatterns> entry : frequentPatterns) {
            log.info("Dumping Patterns for Feature: {} \n{}", (Object)entry.getFirst(), (Object)entry.getSecond());
        }
    }
}

