/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;

public final class FixedSizeSamplingIterator<T>
extends ForwardingIterator<T> {
    private final Iterator<T> delegate;

    public FixedSizeSamplingIterator(int size, Iterator<T> source) {
        ArrayList<T> buf = Lists.newArrayListWithCapacity(size);
        int sofar = 0;
        RandomWrapper random = RandomUtils.getRandom();
        while (source.hasNext()) {
            T v = source.next();
            ++sofar;
            if (buf.size() < size) {
                buf.add(v);
                continue;
            }
            int position = ((Random)random).nextInt(sofar);
            if (position >= buf.size()) continue;
            buf.set(position, v);
        }
        this.delegate = buf.iterator();
    }

    @Override
    protected Iterator<T> delegate() {
        return this.delegate;
    }
}

